/*
 * Decompiled with CFR 0.152.
 */
package com.product.model;

import com.product.language.MessageSourceHelper;
import com.product.model.ServiceSession;
import com.shiji.core.util.I18nUtil;
import java.util.ArrayList;
import java.util.Locale;
import org.springframework.util.StringUtils;

public class ServiceResponse {
    String returncode;
    Object data;

    public String getReturncode() {
        return this.returncode;
    }

    public void setReturncode(String returncode) {
        this.returncode = returncode;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static ServiceResponse buildSuccess(Object obj) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode("0");
        response.setData(obj);
        return response;
    }

    public static ServiceResponse buildFailure(ServiceSession session, String returncode) {
        return ServiceResponse.buildFailure(session, returncode, null);
    }

    public static ServiceResponse buildFailure(ServiceSession session, String returncode, String formatmsg, Object ... args) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(returncode);
        response.setData(MessageSourceHelper.getDefault().getMessage(returncode, formatmsg, session != null && session.getLocale() != null ? new Locale(session.getLocale()) : null, args));
        return response;
    }

    public static ServiceResponse buildFailure(ServiceSession session, String returncode, String msg) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(returncode);
        response.setData(msg);
        return response;
    }

    public static ServiceResponse buildFailureWithErrCode(String returncode, Object[] args) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(returncode);
        String msg = I18nUtil.getMessage(returncode, args);
        response.setData(msg);
        return response;
    }

    public static ServiceResponse buildFailureWithErrCode(String returncode, Object[] args, String locale) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(returncode);
        String msg = I18nUtil.getMessage(returncode, args, I18nUtil.toLocale(locale));
        response.setData(msg);
        return response;
    }

    public static ServiceResponse buildFailureWithErrCode(String returncode, Object[] args, Locale locale) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(returncode);
        String msg = I18nUtil.getMessage(returncode, args, locale);
        response.setData(msg);
        return response;
    }

    public static ServiceResponse buildFailureWithErrCode(ServiceSession session, String returncode, Object ... args) {
        ServiceResponse response = new ServiceResponse();
        response.setReturncode(returncode);
        String msg = "";
        msg = !StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)session.getLocale()) ? I18nUtil.getMessage(returncode, args, I18nUtil.toLocale(session.getLocale())) : I18nUtil.getMessage(returncode, args);
        response.setData(msg);
        return response;
    }

    public static ServiceResponse buildFailureJoin(ServiceSession session, String ... msgcodes) {
        Locale locale = null;
        if (!StringUtils.isEmpty((Object)session) && !StringUtils.isEmpty((Object)session.getLocale())) {
            locale = I18nUtil.toLocale(session.getLocale());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String msgcode : msgcodes) {
            if (!StringUtils.isEmpty((Object)locale)) {
                list.add(I18nUtil.getMessage(msgcode, locale));
                continue;
            }
            list.add(I18nUtil.getMessage(msgcode));
        }
        String msg = String.join((CharSequence)"", list);
        ServiceResponse response = new ServiceResponse();
        response.setReturncode("10000");
        response.setData(msg);
        return response;
    }
}

