/*
 * Decompiled with CFR 0.152.
 */
package com.product.storage.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.product.storage.parser.MongoExpr;
import com.product.storage.parser.QueryExtractor;
import com.product.storage.parser.SQLTextExpr;
import com.shiji.core.util.SQLCheckUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;

public class ExprTranslator {
    private static final Log LOG = LogFactory.getLog(ExprTranslator.class);
    private static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final Map<String, SQLBinaryOperator> opMap = new HashMap<String, SQLBinaryOperator>();

    public static SQLExprTableSource translateTableName(String tableName) {
        return new SQLExprTableSource((SQLExpr)new SQLIdentifierExpr(tableName));
    }

    public static SQLExpr translateKey(String key) {
        return new SQLIdentifierExpr(key);
    }

    public static SQLExpr translateWhere(Document queryObj, QueryExtractor.DBTYPE dbType) {
        return ExprTranslator.parse(queryObj, dbType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SQLExpr parse(Document object, QueryExtractor.DBTYPE dbType) {
        SQLExpr expr = null;
        boolean first = true;
        for (String key : object.keySet()) {
            SQLExpr subExpr = null;
            if (key.startsWith("$")) {
                Object value = object.get((Object)key);
                if (!(value instanceof List)) {
                    throw new IllegalArgumentException("Syntex Error");
                }
                if (key.equals("$and") || key.equals("$or")) {
                    subExpr = ExprTranslator.parseOperator(key, (List)value, dbType);
                } else {
                    if (!key.equals("$nor")) throw new IllegalArgumentException("Syntex Error");
                    subExpr = new SQLUnaryExpr(SQLUnaryOperator.NOT, ExprTranslator.parseOperator("$and", (List)value, dbType));
                }
            } else {
                subExpr = ExprTranslator.parseSingleKey(key, object.get((Object)key), dbType);
            }
            if (first) {
                expr = subExpr;
                first = false;
                continue;
            }
            expr = new SQLBinaryOpExpr(expr, key.equals("$or") ? SQLBinaryOperator.BooleanOr : SQLBinaryOperator.BooleanAnd, subExpr);
        }
        return expr;
    }

    private static SQLExpr parseSingleKey(String key, Object object, QueryExtractor.DBTYPE dbType) {
        SQLBinaryOpExpr expr = null;
        SQLIdentifierExpr left = new SQLIdentifierExpr(key);
        if (object instanceof Document) {
            Document obj = (Document)object;
            boolean first = true;
            for (String op : obj.keySet()) {
                SQLExpr subExpr = null;
                switch (MongoExpr.fromString(op)) {
                    case 6: {
                        subExpr = ExprTranslator.parseNot(key, obj.get((Object)op), dbType);
                        break;
                    }
                    case 7: 
                    case 8: {
                        subExpr = ExprTranslator.parseIn((SQLExpr)left, op.equals("$nin"), obj.get((Object)op), dbType);
                        break;
                    }
                    case 9: {
                        subExpr = ExprTranslator.parseExists((SQLExpr)left, obj.get((Object)op));
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        subExpr = ExprTranslator.parseRelational((SQLExpr)left, op, obj.get((Object)op), dbType);
                        break;
                    }
                    default: {
                        LOG.warn((Object)("Unsupported operator: " + op));
                        throw new IllegalArgumentException("Unsupported operator: " + op);
                    }
                }
                if (first) {
                    expr = subExpr;
                    first = false;
                    continue;
                }
                expr = new SQLBinaryOpExpr((SQLExpr)expr, key.equals("$or") ? SQLBinaryOperator.BooleanOr : SQLBinaryOperator.BooleanAnd, subExpr);
            }
        } else {
            SQLExpr right = null;
            if (object instanceof Pattern) {
                expr = new SQLBinaryOpExpr((SQLExpr)left, SQLBinaryOperator.Like, ExprTranslator.parseObject(object.toString(), dbType));
            } else {
                right = ExprTranslator.parseObject(object, dbType);
                expr = new SQLBinaryOpExpr((SQLExpr)left, SQLBinaryOperator.Equality, right);
            }
        }
        return expr;
    }

    private static SQLExpr parseNot(String key, Object object, QueryExtractor.DBTYPE dbType) {
        return new SQLNotExpr(ExprTranslator.parseSingleKey(key, object, dbType));
    }

    private static SQLExpr parseIn(SQLExpr left, boolean not, Object object, QueryExtractor.DBTYPE dbType) {
        SQLInListExpr inListExpr = new SQLInListExpr(left, not);
        Collection collection = (Collection)object;
        for (Object obj : collection) {
            String value;
            boolean successful = false;
            if (obj instanceof String && !StringUtils.isEmpty((CharSequence)(value = (String)obj))) {
                if ((value = value.trim()).startsWith("(") && value.endsWith(")")) {
                    successful = true;
                    inListExpr.getTargetList().add(new SQLTextExpr(value));
                } else if (value.startsWith("#{") && value.endsWith("}")) {
                    successful = true;
                    value = value.replaceFirst("^#\\{", "").replaceFirst("\\}$", "");
                    inListExpr.getTargetList().add(new SQLTextExpr(value));
                }
            }
            if (successful) continue;
            inListExpr.getTargetList().add(ExprTranslator.parseObject(obj, dbType));
        }
        return inListExpr;
    }

    private static SQLExpr parseExists(SQLExpr left, Object object) {
        SQLNullExpr rightExpr = new SQLNullExpr();
        SQLBinaryOpExpr expr = null;
        expr = Boolean.valueOf(object.toString()) == false ? new SQLBinaryOpExpr(left, SQLBinaryOperator.Is, (SQLExpr)rightExpr) : new SQLBinaryOpExpr(left, SQLBinaryOperator.IsNot, (SQLExpr)rightExpr);
        return expr;
    }

    public static SQLExpr parseObject(Object obj, QueryExtractor.DBTYPE dbType) {
        SQLNullExpr expr = null;
        if (obj == null) {
            expr = new SQLNullExpr();
        } else if (obj instanceof Number) {
            expr = new SQLNumberExpr((Number)obj);
        } else if (obj instanceof String) {
            expr = new SQLCharExpr((String)obj);
        } else if (obj instanceof JSONObject) {
            expr = new SQLCharExpr(((JSONObject)obj).toJSONString());
        } else if (obj instanceof Boolean) {
            expr = new SQLBooleanExpr(((Boolean)obj).booleanValue());
            if (dbType == QueryExtractor.DBTYPE.SQLITE) {
                expr = new SQLNumberExpr((Number)(TypeUtils.castToBoolean((Object)obj) == true ? 1 : 0));
            }
        } else if (obj instanceof Character) {
            expr = new SQLCharExpr(obj.toString());
        } else if (obj instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATETIME_PATTERN);
            String date = formatter.format((Date)obj);
            if (dbType == QueryExtractor.DBTYPE.ORACLE) {
                expr = new SQLDateExpr();
                ((SQLDateExpr)expr).setLiteral(date);
            } else {
                expr = new SQLCharExpr(date);
            }
        } else if (obj instanceof LocalDateTime) {
            String date = ((LocalDateTime)obj).format(DateTimeFormatter.ofPattern(DATETIME_PATTERN));
            if (dbType == QueryExtractor.DBTYPE.ORACLE) {
                expr = new SQLDateExpr();
                ((SQLDateExpr)expr).setLiteral(date);
            } else {
                expr = new SQLCharExpr(date);
            }
        } else if (obj instanceof LocalDate) {
            String date = ((LocalDate)obj).format(DateTimeFormatter.ISO_LOCAL_DATE);
            if (dbType == QueryExtractor.DBTYPE.ORACLE) {
                expr = new SQLDateExpr();
                ((SQLDateExpr)expr).setLiteral(date);
            } else {
                expr = new SQLCharExpr(date);
            }
        } else {
            LOG.warn((Object)"Unsupported data type");
            throw new IllegalArgumentException("Unsupported data type in query: " + obj.getClass().getName());
        }
        expr = SQLCheckUtil.filterIllegalChar((SQLExpr)expr);
        return expr;
    }

    private static SQLExpr parseRelational(SQLExpr left, String op, Object object, QueryExtractor.DBTYPE dbType) {
        SQLBinaryOperator oper = opMap.get(op);
        return new SQLBinaryOpExpr(left, oper, ExprTranslator.parseObject(object, dbType));
    }

    private static SQLExpr parseOperator(String key, List list, QueryExtractor.DBTYPE dbType) {
        SQLExpr leftExpr = null;
        boolean first = true;
        for (Object object : list) {
            SQLExpr subExpr = ExprTranslator.parse((Document)object, dbType);
            if (first) {
                leftExpr = subExpr;
                first = false;
                continue;
            }
            leftExpr = new SQLBinaryOpExpr(leftExpr, key.equals("$or") ? SQLBinaryOperator.BooleanOr : SQLBinaryOperator.BooleanAnd, subExpr);
        }
        return leftExpr;
    }

    static {
        opMap.put("$ne", SQLBinaryOperator.NotEqual);
        opMap.put("$lt", SQLBinaryOperator.LessThan);
        opMap.put("$lte", SQLBinaryOperator.LessThanOrEqual);
        opMap.put("$gt", SQLBinaryOperator.GreaterThan);
        opMap.put("$gte", SQLBinaryOperator.GreaterThanOrEqual);
        opMap.put("$and", SQLBinaryOperator.BooleanAnd);
        opMap.put("$or", SQLBinaryOperator.BooleanOr);
    }
}

