/*
 * Decompiled with CFR 0.152.
 */
package com.product.util;

import com.product.exception.DatabaseExportException;
import com.product.model.DbMessageCode;
import com.shiji.core.util.I18nUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DbConnection {
    private static final Logger log = LoggerFactory.getLogger(DbConnection.class);

    public static Connection getConn(String jdbcUrl, String userName, String password, String driverClassName) throws Exception {
        Connection connection = null;
        try {
            Class.forName(driverClassName);
            connection = DriverManager.getConnection(jdbcUrl, userName, password);
            if (connection == null) {
                throw new DatabaseExportException(DbMessageCode.DATABASE_LINK_IS_NULL_ERROR.getCode(), I18nUtil.getMessage(DbMessageCode.DATABASE_LINK_IS_NULL_ERROR.getCode()));
            }
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5\u6570\u636e\u5e93\u9519\u8bef={}", (Throwable)e);
            if (e instanceof ClassNotFoundException) {
                throw new DatabaseExportException(DbMessageCode.DATABASE_DRIVE_IS_NULL_ERROR.getCode(), I18nUtil.getMessage(DbMessageCode.DATABASE_DRIVE_IS_NULL_ERROR.getCode()));
            }
            if (e instanceof DatabaseExportException) {
                throw new DatabaseExportException(DbMessageCode.DATABASE_LINK_IS_NULL_ERROR.getCode(), I18nUtil.getMessage(DbMessageCode.DATABASE_LINK_IS_NULL_ERROR.getCode()));
            }
            throw new RuntimeException(e);
        }
        return connection;
    }

    public static void closeRs(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "\u672a\u77e5\u9519\u8bef!";
                }
                rs = null;
                System.out.println(String.format("\u6267\u884c\u5173\u95ed\u65f6\u53d1\u751f\u9519\u8bef:%1$s", message));
                e.printStackTrace();
            }
        }
        log.info("\u5df2\u5173\u95ed\u6570\u636e\u5e93ResultSet\u8fde\u63a5");
    }

    public static void closeStat(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "\u672a\u77e5\u9519\u8bef!";
                }
                statement = null;
                System.out.println(String.format("\u6267\u884c\u5173\u95ed\u65f6\u53d1\u751f\u9519\u8bef:%1$s", message));
                e.printStackTrace();
            }
        }
        log.info("\u5df2\u5173\u95ed\u6570\u636e\u5e93Statement\u8fde\u63a5");
    }

    public static void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "\u672a\u77e5\u9519\u8bef!";
                }
                connection = null;
                System.out.println(String.format("\u6267\u884c\u5173\u95ed\u65f6\u53d1\u751f\u9519\u8bef:%1$s", message));
                e.printStackTrace();
            }
        }
        log.info("\u5df2\u5173\u95ed\u6570\u636e\u5e93Connection\u8fde\u63a5");
    }

    public static List<Map<String, Object>> toListMap(ResultSet ret) throws SQLException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ResultSetMetaData meta = ret.getMetaData();
        int cot = meta.getColumnCount();
        while (ret.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 0; i < cot; ++i) {
                map.put(meta.getColumnName(i + 1), ret.getObject(i + 1));
            }
            list.add(map);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Map<String, Object>> query(Connection connection, String querySQL) {
        List<Map<String, Object>> list;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            List<Map<String, Object>> dataList;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(querySQL);
            list = dataList = DbConnection.toListMap(resultSet);
        }
        catch (Exception e) {
            try {
                log.error("\u53d1\u751f\u9519\u8bef:{}", (Object)e.getMessage(), (Object)e);
            }
            catch (Throwable throwable) {
                DbConnection.closeRs(resultSet);
                DbConnection.closeStat(statement);
                throw throwable;
            }
            DbConnection.closeRs(resultSet);
            DbConnection.closeStat(statement);
            return null;
        }
        DbConnection.closeRs(resultSet);
        DbConnection.closeStat(statement);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exec(Connection connection, String querySQL) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            statement.execute(querySQL);
            String string = null;
            return string;
        }
        catch (Exception e) {
            log.error("\u53d1\u751f\u9519\u8bef:{}", (Object)e.getMessage(), (Object)e);
            String string = e.getMessage();
            return string;
        }
        finally {
            DbConnection.closeRs(resultSet);
            DbConnection.closeStat(statement);
        }
    }

    public static String execBatch(Connection connection, String sqlBatch) {
        String[] sqls = sqlBatch.split(";");
        StringBuffer buf = new StringBuffer();
        for (String sql : sqls) {
            String str;
            log.info("sql:" + sql);
            if (StringUtils.isEmpty((Object)sql.trim()) || StringUtils.isEmpty((Object)(str = DbConnection.exec(connection, sql)))) continue;
            buf.append(str).append("/n ");
        }
        return buf.toString();
    }
}

