/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import com.product.annotation.NotField;
import com.product.annotation.ReferQuery;
import com.product.language.MessageSourceHelper;
import com.shiji.core.util.ReflectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.core.GenericTypeResolver;

public class BaseComponent<T> {
    private String lastErrMessage = "";
    private String lastWarMessage = "";
    private int lastErrCode = 0;
    protected final Class<T> beanClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), BaseComponent.class);

    protected Class<T> getBeanClass() {
        return this.beanClass;
    }

    public String getLastWarMessage() {
        return this.lastWarMessage;
    }

    public void setLastWarMessage(String lastWarMessage) {
        this.lastWarMessage = lastWarMessage;
    }

    public String getLastErrMessage() {
        return this.lastErrMessage;
    }

    public void setLastErrMessage(String lastErrMessage) {
        this.lastErrMessage = lastErrMessage;
    }

    public void setLastErrMessage(String returncode, String formatmsg, Object ... args) {
        this.setLastErrCode(-1);
        this.setLastErrMessage(MessageSourceHelper.getDefault().getMessage(returncode, formatmsg, null, args));
    }

    public int getLastErrCode() {
        return this.lastErrCode;
    }

    public void setLastErrCode(int lastErrCode) {
        this.lastErrCode = lastErrCode;
    }

    protected String[] checkFields(String[] paramFields, Set<String> returnSet) {
        List<Field> modelFields = ReflectUtils.getAllFields(this.beanClass);
        Field[] modelFieldsAll = modelFields.toArray(new Field[modelFields.size()]);
        return BaseComponent.checkFields(paramFields, returnSet, modelFieldsAll);
    }

    public static String[] checkFields(String[] paramFields, Set<String> returnSet, Field[] modelFields) {
        String[] modelFieldNames = new String[modelFields.length];
        Field.setAccessible(modelFields, true);
        boolean entIdflag = true;
        for (int i = 0; i < modelFieldNames.length; ++i) {
            modelFieldNames[i] = modelFields[i].getName();
        }
        HashSet<String> set = new HashSet<String>();
        for (String paramfield : paramFields) {
            if ("entId".equals(paramfield)) {
                entIdflag = false;
            }
            set.add(paramfield);
        }
        for (String modelField : modelFieldNames) {
            set.remove(modelField);
        }
        returnSet.addAll(set);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(paramFields));
        for (Field field : modelFields) {
            if (!field.isAnnotationPresent(ReferQuery.class) && !field.isAnnotationPresent(NotField.class)) continue;
            list.remove(field.getName());
        }
        if (entIdflag && Arrays.stream(modelFields).anyMatch(e -> e.getName().equalsIgnoreCase("entId"))) {
            list.add("entId");
        }
        return list.toArray(new String[list.size()]);
    }
}

