/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.product.model.AbstractEntityBean;
import com.product.service.QueryConvertHandler;
import com.shiji.core.util.I18nUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.StringUtils;

public class CustomQueryConvert
implements QueryConvertHandler {
    protected boolean isExactMatchKey(String key) {
        if (key.endsWith("code")) {
            return false;
        }
        return !key.endsWith("status");
    }

    protected Object getObject(JSONObject paramsObject, String keyName) {
        Object value = paramsObject.get((Object)keyName);
        return value;
    }

    protected Object[] getObject(Object value) {
        Object[] response = null;
        if (value instanceof JSONArray) {
            JSONArray ja = (JSONArray)value;
            response = new Object[ja.size()];
            for (int i = 0; i < ja.size(); ++i) {
                Object obj;
                response[i] = obj = ja.get(i);
            }
        } else if (value instanceof List) {
            List valueList = (List)value;
            response = new Object[valueList.size()];
            for (int i = 0; i < valueList.size(); ++i) {
                Object obj = valueList.get(i);
                response[i] = obj;
            }
        } else {
            response = value instanceof String && value.toString().startsWith("#{") && ((String)value).endsWith("}") ? new Object[]{value} : value.toString().split(",");
        }
        return response;
    }

    protected void rowParse(Criteria criteria, String keyName, JSONObject paramsObject) {
        if ("$gt".equalsIgnoreCase(keyName) || ">".equalsIgnoreCase(keyName)) {
            criteria.gt(this.getObject(paramsObject, keyName));
        } else if ("$gte".equalsIgnoreCase(keyName) || ">=".equalsIgnoreCase(keyName)) {
            criteria.gte(this.getObject(paramsObject, keyName));
        } else if ("$lt".equalsIgnoreCase(keyName) || "<".equalsIgnoreCase(keyName)) {
            criteria.lt(this.getObject(paramsObject, keyName));
        } else if ("$lte".equalsIgnoreCase(keyName) || "<=".equalsIgnoreCase(keyName)) {
            criteria.lte(this.getObject(paramsObject, keyName));
        } else if ("$ne".equalsIgnoreCase(keyName) || "<>".equalsIgnoreCase(keyName) || "!=".equalsIgnoreCase(keyName)) {
            Object value = this.getObject(paramsObject, keyName);
            if (value instanceof String && "$null".equalsIgnoreCase(value.toString())) {
                criteria.exists(false);
            } else {
                criteria.ne(value);
            }
        } else if ("$is".equalsIgnoreCase(keyName) || "==".equalsIgnoreCase(keyName) || "=".equalsIgnoreCase(keyName)) {
            Object value = this.getObject(paramsObject, keyName);
            if (value instanceof String && "$null".equalsIgnoreCase(value.toString())) {
                criteria.exists(false);
            } else {
                criteria.is(this.getObject(paramsObject, keyName));
            }
        } else if ("$in".equalsIgnoreCase(keyName) || "in".equalsIgnoreCase(keyName)) {
            criteria.in(this.getObject(this.getObject(paramsObject, keyName)));
        } else if ("$nin".equalsIgnoreCase(keyName) || "nin".equalsIgnoreCase(keyName) || "notin".equalsIgnoreCase(keyName)) {
            Object value = this.getObject(paramsObject, keyName);
            if (value instanceof String && "$null".equalsIgnoreCase(value.toString())) {
                criteria.exists(true);
            } else {
                criteria.nin(this.getObject(this.getObject(paramsObject, keyName)));
            }
        } else if ("$all".equalsIgnoreCase(keyName) || "all".equalsIgnoreCase(keyName)) {
            criteria.all(this.getObject(this.getObject(paramsObject, keyName)));
        } else if ("$exists".equalsIgnoreCase(keyName)) {
            boolean exists = TypeUtils.castToBoolean((Object)paramsObject.get((Object)keyName));
            criteria.exists(exists);
        } else if ("$isnull".equalsIgnoreCase(keyName)) {
            criteria.exists(false);
        } else if ("$isnotnull".equalsIgnoreCase(keyName)) {
            criteria.exists(true);
        } else if ("$like".equalsIgnoreCase(keyName) || "like".equalsIgnoreCase(keyName)) {
            Object value = this.getObject(paramsObject, keyName);
            if (String.valueOf(value).indexOf("%") < 0) {
                criteria.regex(String.valueOf(value) + "%");
            } else {
                criteria.regex(String.valueOf(value));
            }
        } else {
            Object value = this.getObject(paramsObject, keyName);
            if (value instanceof String && !StringUtils.isEmpty((Object)value)) {
                if (this.isExactMatchKey(keyName)) {
                    String[] ss = ((String)value).split(",");
                    if (ss.length > 1) {
                        criteria.in((Object[])ss);
                    } else {
                        criteria.is((Object)ss[0]);
                    }
                }
            } else {
                criteria.is(this.getObject(paramsObject, keyName));
            }
        }
    }

    protected List<Criteria> objectParse(JSONObject paramsObject) {
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        Set keySet = paramsObject.keySet();
        for (String keyName : keySet) {
            this.recursionParse(criteriaList, keyName, paramsObject.get((Object)keyName));
        }
        return criteriaList;
    }

    protected List<Criteria> andOrParse(String keyName, Object keyValue) {
        ArrayList<Criteria> criteriaAndOrList = new ArrayList<Criteria>();
        if (!StringUtils.isEmpty((Object)keyValue)) {
            if (keyValue instanceof JSONObject) {
                JSONObject paramsObject = (JSONObject)keyValue;
                List<Criteria> criteriaList = this.objectParse(paramsObject);
                criteriaAndOrList.addAll(criteriaList);
            } else if (keyValue instanceof List) {
                List paramsArray = (List)keyValue;
                for (int i = 0; i < paramsArray.size(); ++i) {
                    JSONObject paramsObject = (JSONObject)JSON.toJSON(paramsArray.get(i));
                    List<Criteria> criteriaList = this.objectParse(paramsObject);
                    criteriaAndOrList.addAll(criteriaList);
                }
            } else {
                throw new RuntimeException(I18nUtil.getMessage("10015", new Object[]{keyName, JSON.toJSONString((Object)keyValue)}));
            }
        }
        return criteriaAndOrList;
    }

    protected List<Criteria> andParse(String keyName, Object keyValue) {
        if (!"$and".equalsIgnoreCase(keyName)) {
            throw new RuntimeException(I18nUtil.getMessage("10016", new Object[]{"$and", keyName}));
        }
        List<Criteria> criteriaList = this.andOrParse(keyName, keyValue);
        return criteriaList;
    }

    protected Criteria orParse(String keyName, Object keyValue) {
        if (!"$or".equalsIgnoreCase(keyName)) {
            throw new RuntimeException(I18nUtil.getMessage("10016", new Object[]{"$or", keyName}));
        }
        List<Criteria> criteriaList = this.andOrParse(keyName, keyValue);
        if (criteriaList.size() > 0) {
            Criteria criteria = new Criteria();
            criteria.orOperator(criteriaList.toArray(new Criteria[criteriaList.size()]));
            return criteria;
        }
        return null;
    }

    protected void recursionParse(List<Criteria> criteriaList, String keyName, Object keyValue) {
        if ("$and".equalsIgnoreCase(keyName)) {
            List<Criteria> criteriaAndList = this.andParse(keyName, keyValue);
            criteriaList.addAll(criteriaAndList);
        } else if ("$or".equalsIgnoreCase(keyName)) {
            Criteria criteria = this.orParse(keyName, keyValue);
            if (criteria != null) {
                criteriaList.add(criteria);
            }
        } else if (StringUtils.isEmpty((Object)keyValue) || keyValue instanceof String && ("$null".equalsIgnoreCase(keyValue.toString()) || "$isnull".equalsIgnoreCase(keyValue.toString()))) {
            Criteria criteria = Criteria.where((String)keyName).exists(false).orOperator(new Criteria[]{Criteria.where((String)keyName).is((Object)"")});
            criteriaList.add(criteria);
        } else if (StringUtils.isEmpty((Object)keyValue) || keyValue instanceof String && ("$notnull".equalsIgnoreCase(keyValue.toString()) || "$isnotnull".equalsIgnoreCase(keyValue.toString()))) {
            Criteria criteria = Criteria.where((String)keyName).exists(true);
            criteriaList.add(criteria);
        } else if (keyValue instanceof JSONObject || keyValue instanceof Map) {
            if (keyValue instanceof Map) {
                keyValue = JSONObject.toJSON((Object)keyValue);
            }
            Criteria criteria = null;
            JSONObject paramsObject = (JSONObject)keyValue;
            Set keySet = paramsObject.keySet();
            for (String itemName : keySet) {
                if ("$and".equalsIgnoreCase(keyName)) {
                    this.recursionParse(criteriaList, keyName, keyValue);
                    continue;
                }
                if ("$or".equalsIgnoreCase(keyName)) {
                    this.recursionParse(criteriaList, keyName, keyValue);
                    continue;
                }
                if (criteria == null) {
                    criteria = Criteria.where((String)keyName);
                    criteriaList.add(criteria);
                }
                this.rowParse(criteria, itemName, paramsObject);
            }
        } else if (keyValue instanceof JSONArray) {
            JSONArray array = (JSONArray)keyValue;
            if (this.checkChildJSONObject(array)) {
                for (int i = 0; i < array.size(); ++i) {
                    Object oo = array.get(i);
                    if (!(oo instanceof JSONObject)) continue;
                    JSONObject paramsObject = (JSONObject)oo;
                    Set keySet = paramsObject.keySet();
                    for (String itemName : keySet) {
                        this.recursionParse(criteriaList, itemName, this.getObject(paramsObject, itemName));
                    }
                }
            } else if (array.size() > 0) {
                Criteria criteria = Criteria.where((String)keyName).in((Collection)array);
                criteriaList.add(criteria);
            }
        } else if (keyValue instanceof ArrayList) {
            ArrayList al = (ArrayList)keyValue;
            if (al.size() > 0) {
                Criteria criteria = Criteria.where((String)keyName).in((Collection)al);
                criteriaList.add(criteria);
            }
        } else if (keyValue.getClass().isArray()) {
            JSONArray array = JSONArray.parseArray((String)JSONObject.toJSONString((Object)keyValue));
            if (array.size() > 0) {
                Criteria criteria = Criteria.where((String)keyName).in((Collection)array);
                criteriaList.add(criteria);
            }
        } else if (keyValue instanceof List) {
            List list = (List)keyValue;
            if (list.size() > 0) {
                Criteria criteria = Criteria.where((String)keyName).in((Collection)list);
                criteriaList.add(criteria);
            }
        } else if (keyValue instanceof String && ((String)keyValue).split(",").length > 1) {
            Object[] str = ((String)keyValue).split(",");
            Criteria criteria = Criteria.where((String)keyName).in(str);
            criteriaList.add(criteria);
        } else {
            Criteria criteria = Criteria.where((String)keyName).is(keyValue);
            criteriaList.add(criteria);
        }
    }

    public boolean checkChildJSONObject(JSONArray array) {
        boolean flag = false;
        for (int i = 0; i < array.size(); ++i) {
            Object oo = array.get(i);
            if (!(oo instanceof JSONObject)) continue;
            return true;
        }
        return flag;
    }

    @Override
    public List<Criteria> onConvert(JSONObject paramsObject, Map<String, Integer> keyMap, Class<?> beanClass) {
        Set keySet = paramsObject.keySet();
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName) || !"$and".equalsIgnoreCase(keyName) && !"$or".equalsIgnoreCase(keyName) && AbstractEntityBean.isTransientField(beanClass, keyName)) continue;
            this.recursionParse(criteriaList, keyName, paramsObject.get((Object)keyName));
        }
        return criteriaList;
    }

    @Override
    public Query baseCreateQuery(Query query, List<Criteria> criteriaList) {
        if (criteriaList.size() > 0) {
            if (criteriaList.size() < 2) {
                query.addCriteria((CriteriaDefinition)criteriaList.get(0));
                return query;
            }
            Criteria criteria = new Criteria();
            criteria.andOperator(criteriaList.toArray(new Criteria[criteriaList.size()]));
            return query.addCriteria((CriteriaDefinition)criteria);
        }
        return query;
    }
}

