/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.component;

import com.product.util.StaticVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class NamedParameterJdbcTemplateImpl
extends NamedParameterJdbcTemplate {
    public NamedParameterJdbcTemplateImpl(DataSource dataSource) {
        super(dataSource);
    }

    public NamedParameterJdbcTemplateImpl(JdbcOperations classicJdbcTemplate) {
        super(classicJdbcTemplate);
    }

    protected String exchange(String sql) {
        String schema = "" + StaticVariable.get("context.schema");
        String entId = "" + StaticVariable.get("context.entId");
        String responseSQL = sql;
        if (!(StringUtils.isEmpty((CharSequence)schema) || StringUtils.isEmpty((CharSequence)entId) || "null".equals(schema) || "null".equals(entId))) {
            if (!sql.startsWith("/* !mycat:schema")) {
                responseSQL = String.format("/* !mycat:schema = %1$s-%2$s*/%3$s", schema, entId, sql);
            }
            System.out.println("\u5728\u6b64\u4fee\u6539SQL\uff1a" + sql + " \u6700\u7ec8SQL:" + responseSQL);
        }
        return responseSQL;
    }

    protected String[] batchExchange(String ... sql) {
        List<String> list = Arrays.asList(sql);
        ArrayList<String> response = new ArrayList<String>();
        for (String itemSQL : list) {
            String oSQL = this.exchange(itemSQL);
            response.add(oSQL);
        }
        return response.toArray(new String[response.size()]);
    }

    public <T> T execute(String sql, SqlParameterSource paramSource, PreparedStatementCallback<T> action) throws DataAccessException {
        return (T)super.execute(this.exchange(sql), paramSource, action);
    }

    public <T> T execute(String sql, Map<String, ?> paramMap, PreparedStatementCallback<T> action) throws DataAccessException {
        return (T)super.execute(this.exchange(sql), paramMap, action);
    }

    public <T> T execute(String sql, PreparedStatementCallback<T> action) throws DataAccessException {
        return (T)super.execute(this.exchange(sql), action);
    }

    public <T> T query(String sql, SqlParameterSource paramSource, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.exchange(sql), paramSource, rse);
    }

    public <T> T query(String sql, Map<String, ?> paramMap, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.exchange(sql), paramMap, rse);
    }

    public <T> T query(String sql, ResultSetExtractor<T> rse) throws DataAccessException {
        return (T)super.query(this.exchange(sql), rse);
    }

    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws DataAccessException {
        super.query(this.exchange(sql), paramSource, rch);
    }

    public void query(String sql, Map<String, ?> paramMap, RowCallbackHandler rch) throws DataAccessException {
        super.query(this.exchange(sql), paramMap, rch);
    }

    public void query(String sql, RowCallbackHandler rch) throws DataAccessException {
        super.query(this.exchange(sql), rch);
    }

    public <T> List<T> query(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        return super.query(this.exchange(sql), paramSource, rowMapper);
    }

    public <T> List<T> query(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        return super.query(this.exchange(sql), paramMap, rowMapper);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        return super.query(this.exchange(sql), rowMapper);
    }

    public <T> T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), paramSource, rowMapper);
    }

    public <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), paramMap, rowMapper);
    }

    public <T> T queryForObject(String sql, SqlParameterSource paramSource, Class<T> requiredType) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), paramSource, requiredType);
    }

    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws DataAccessException {
        return (T)super.queryForObject(this.exchange(sql), paramMap, requiredType);
    }

    public Map<String, Object> queryForMap(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return super.queryForMap(this.exchange(sql), paramSource);
    }

    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return super.queryForMap(this.exchange(sql), paramMap);
    }

    public <T> List<T> queryForList(String sql, SqlParameterSource paramSource, Class<T> elementType) throws DataAccessException {
        return super.queryForList(this.exchange(sql), paramSource, elementType);
    }

    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType) throws DataAccessException {
        return super.queryForList(this.exchange(sql), paramMap, elementType);
    }

    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return super.queryForList(this.exchange(sql), paramSource);
    }

    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return super.queryForList(this.exchange(sql), paramMap);
    }

    public SqlRowSet queryForRowSet(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return super.queryForRowSet(this.exchange(sql), paramSource);
    }

    public SqlRowSet queryForRowSet(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return super.queryForRowSet(this.exchange(sql), paramMap);
    }

    public int update(String sql, SqlParameterSource paramSource) throws DataAccessException {
        return super.update(this.exchange(sql), paramSource);
    }

    public int update(String sql, Map<String, ?> paramMap) throws DataAccessException {
        return super.update(this.exchange(sql), paramMap);
    }

    public int update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder) throws DataAccessException {
        return super.update(this.exchange(sql), paramSource, generatedKeyHolder);
    }

    public int update(String sql, SqlParameterSource paramSource, KeyHolder generatedKeyHolder, String[] keyColumnNames) throws DataAccessException {
        return super.update(this.exchange(sql), paramSource, generatedKeyHolder, keyColumnNames);
    }

    public int[] batchUpdate(String sql, Map<String, ?>[] batchValues) {
        return super.batchUpdate(this.exchange(sql), (Map[])batchValues);
    }

    public int[] batchUpdate(String sql, SqlParameterSource[] batchArgs) {
        return super.batchUpdate(this.exchange(sql), batchArgs);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        return super.getPreparedStatementCreator(this.exchange(sql), paramSource);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource, Consumer<PreparedStatementCreatorFactory> customizer) {
        return super.getPreparedStatementCreator(this.exchange(sql), paramSource, customizer);
    }

    protected ParsedSql getParsedSql(String sql) {
        return super.getParsedSql(this.exchange(sql));
    }

    protected PreparedStatementCreatorFactory getPreparedStatementCreatorFactory(ParsedSql parsedSql, SqlParameterSource paramSource) {
        return super.getPreparedStatementCreatorFactory(parsedSql, paramSource);
    }
}

