/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.controller;

import com.alibaba.fastjson.JSON;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import com.product.util.StaticVariable;
import com.product.util.StatisticUtils;
import com.product.util.Utils;
import com.shiji.core.component.MapTable;
import com.shiji.core.service.InvokerHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Component
public class DataRestController {
    private static final Logger log = LoggerFactory.getLogger(DataRestController.class);
    private static MapTable<String, Object> mapper = new MapTable("beanName", "methodName", "note");
    @Autowired
    InvokerHandler invoker;

    public void put(String path, String beanName, String methodName, String note) {
        mapper.put(path, (Object[])new Object[]{beanName, methodName, note});
    }

    public MapTable<String, Object> getTable() {
        return mapper;
    }

    private ServiceSession getSession(String method, String session, String versionCode, String entId, String userId, String userName, String locale) {
        ServiceSession response = new ServiceSession();
        if (StringUtils.isEmpty((Object)session)) {
            if (!StringUtils.isEmpty((Object)entId)) {
                if (!StringUtils.isEmpty((Object)entId)) {
                    response.setEnt_id(Long.parseLong(entId));
                }
            } else {
                response.setEnt_id(0L);
                response.setUser_id(0L);
            }
            if (!StringUtils.isEmpty((Object)userId)) {
                response.setUser_id(Long.parseLong(userId));
            }
            response.setUser_name(userName);
            response.setLocale(locale);
        } else if (session != null && !session.equals("")) {
            try {
                session = URLDecoder.decode(session, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u8f6c\u6362Session\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
                session = "{'ent_id':0,'user_id':0}";
            }
            response = (ServiceSession)JSON.parseObject((String)session, ServiceSession.class);
        }
        StaticVariable.put("ProductReflect.executeClassMethod.session", response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ResponseBody
    public String onGet(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="method", required=false) String method, @RequestParam(value="session", required=false) String session, @RequestParam(value="ent_id", required=false) String entId, @RequestParam(value="user_id", required=false) String userId, @RequestParam(value="user_name", required=false) String userName, @RequestParam(value="version", required=false) String versionCode, @RequestParam(value="locale", required=false) String locale) {
        long startTimeMillis = System.currentTimeMillis();
        StatisticUtils.onIncrementMethod(method, startTimeMillis);
        ServiceSession contextSession = this.getSession(method, session, versionCode, entId, userId, userName, locale);
        SpringContext.putSession(contextSession);
        SpringContext.removePageno();
        SpringContext.removePageSize();
        String requestURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getServletPath();
        if (request.getQueryString() != null) {
            requestURL = requestURL + "?" + request.getQueryString();
        }
        log.info("\u8bf7\u6c42\u5730\u5740:{}", (Object)requestURL);
        String restPath = request.getServletPath();
        if (mapper.containsKey(restPath)) {
            String beanName = (String)mapper.get(restPath, "beanName");
            String methodName = (String)mapper.get(restPath, "methodName");
            String component = String.format("%1$s.%2$s", beanName, methodName);
            try {
                String string = this.invoker.invoke(component, "", new Object[0]).toString();
                return string;
            }
            finally {
                long endTimeMillis = System.currentTimeMillis();
                long elapsed = endTimeMillis - startTimeMillis;
                StatisticUtils.onDecrementMethod(method, elapsed);
            }
        }
        return "\u672a\u627e\u5230\u8bf7\u6c42\u6620\u5c04\u65b9\u6cd5";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ResponseBody
    public String onPost(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="method", required=false) String method, @RequestParam(value="session", required=false) String session, @RequestParam(value="ent_id", required=false) String entId, @RequestParam(value="user_id", required=false) String userId, @RequestParam(value="user_name", required=false) String userName, @RequestParam(value="version", required=false) String versionCode, @RequestParam(value="locale", required=false) String locale, @RequestBody String params) {
        long startTimeMillis = System.currentTimeMillis();
        StatisticUtils.onIncrementMethod(method, startTimeMillis);
        ServiceSession contextSession = this.getSession(method, session, versionCode, entId, userId, userName, locale);
        SpringContext.putSession(contextSession);
        SpringContext.removePageno();
        SpringContext.removePageSize();
        String menuCode = request.getParameter("menuCode");
        String moduleCode = request.getParameter("moduleCode");
        StaticVariable.put("context.menuCode", menuCode);
        StaticVariable.put("context.moduleCode", moduleCode);
        StaticVariable.put("context.schema", "xxx");
        StaticVariable.put("context.entId", "" + contextSession.getEnt_id());
        String requestURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getServletPath();
        if (request.getQueryString() != null) {
            requestURL = requestURL + "?" + request.getQueryString();
        }
        log.info("\u8bf7\u6c42\u5730\u5740:{} \u8bf7\u6c42\u53c2\u6570:{}", (Object)requestURL, (Object)params);
        String beanName = null;
        String methodName = null;
        if (!StringUtils.isEmpty((Object)method)) {
            int index = method.lastIndexOf(".");
            if (index <= 0) return "\u8bf7\u6c42\u6620\u5c04\u65b9\u6cd5\u9519\u8bef";
            beanName = method.substring(0, index);
            methodName = method.substring(index + 1);
        } else {
            String restPath = request.getServletPath();
            if (!mapper.containsKey(restPath)) return "\u672a\u627e\u5230\u8bf7\u6c42\u6620\u5c04\u65b9\u6cd5";
            beanName = (String)mapper.get(restPath, "beanName");
            methodName = (String)mapper.get(restPath, "methodName");
        }
        String component = String.format("%1$s.%2$s", beanName, methodName);
        log.debug("\u8bf7\u6c42\u65b9\u6cd5\u4e3a:{}", (Object)component);
        try {
            String string = JSON.toJSONString((Object)Utils.toNormalJSONObject(this.invoker.invoke(component, JSON.parseObject((String)params))));
            return string;
        }
        finally {
            long endTimeMillis = System.currentTimeMillis();
            long elapsed = endTimeMillis - startTimeMillis;
            StatisticUtils.onDecrementMethod(method, elapsed);
        }
    }
}

