/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import com.bstek.ureport.provider.report.file.FileReportProvider;
import com.google.common.base.Splitter;
import com.product.util.MapAs;
import com.product.util.SpringContext;
import com.shiji.core.annotation.ModelProperty;
import com.shiji.core.annotation.RestComponent;
import com.shiji.core.component.MapTable;
import com.shiji.core.controller.DataRestController;
import com.shiji.core.ureport.component.IDasReportServiceImpl;
import com.shiji.core.ureport.component.ReportServiceImpl;
import com.shiji.core.ureport.service.ReportService;
import com.shiji.core.util.ArgumentParser;
import com.shiji.core.util.SpringInvoker;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class SwaggerController {
    private static final Logger log = LoggerFactory.getLogger(SwaggerController.class);
    final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private DataRestController restController;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SpringInvoker invoker;
    @Autowired
    private ArgumentParser parser;
    @Autowired
    private ReportServiceImpl report;
    @Value(value="${com.shiji.core.ureport.component.genBusinessType:iDAS}")
    private String businessType;
    @Value(value="${swaggerurlprefix:}")
    private String swaggerurlprefix;
    @Autowired
    private Environment env;
    @Autowired
    private IDasReportServiceImpl iDasReport;

    @GetMapping(value={"/index.doc"})
    public String welcome(Map<String, Object> model) {
        log.info("\u67e5\u770bAPI\u5904\u7406\u7d22\u5f15");
        ArrayList<Map<String, String>> valueList = new ArrayList<Map<String, String>>();
        MapTable<String, Object> table = this.restController.getTable();
        for (String pathKey : table.keySet()) {
            String beanName = (String)table.get(pathKey, "beanName");
            String methodName = (String)table.get(pathKey, "methodName");
            String note = (String)table.get(pathKey, "note");
            String requestURL = String.format("%1$s://%2$s:%3$d/swagger%4$s?method=%5$s.%6$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), pathKey, beanName, methodName);
            Map<String, String> value = MapAs.of("url", requestURL, "note", note);
            valueList.add(value);
        }
        model.put("time", new Date());
        model.put("message", "\u5728\u7ebfAPI\u8c03\u7528");
        model.put("valueList", valueList);
        log.info(JSON.toJSONString(model));
        return "welcome";
    }

    @GetMapping(value={"/index.htm"})
    public String index(Map<String, Object> model) {
        log.info("\u67e5\u770bAPI\u5904\u7406\u7d22\u5f15");
        ArrayList<Map<String, String>> valueList = new ArrayList<Map<String, String>>();
        MapTable<String, Object> table = this.restController.getTable();
        for (String pathKey : table.keySet()) {
            String beanName = (String)table.get(pathKey, "beanName");
            String methodName = (String)table.get(pathKey, "methodName");
            String note = (String)table.get(pathKey, "note");
            String requestURL = null;
            requestURL = !StringUtils.isEmpty((Object)this.swaggerurlprefix) ? String.format("%1$s/generate/%2$s.%3$s", this.swaggerurlprefix, beanName, methodName) : String.format("%1$s://%2$s:%3$d/generate/%4$s.%5$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), beanName, methodName);
            Map<String, String> value = MapAs.of("url", requestURL, "note", note);
            valueList.add(value);
        }
        if (!StringUtils.isEmpty((Object)this.swaggerurlprefix)) {
            String appliactionname = this.env.getProperty("spring.application.name");
            model.put("prefixurl", "/amp-openapi-forward/" + appliactionname);
        }
        model.put("time", new Date());
        model.put("message", "\u5728\u7ebfAPI\u8c03\u7528");
        model.put("valueList", valueList);
        log.info(JSON.toJSONString(model));
        return "welcome";
    }

    @GetMapping(value={"/demo/{ftlname}"})
    public String demoFtl(@PathVariable(value="ftlname") String ftlname, Map<String, Object> model) {
        log.info("\u67e5\u770bdemo:{}", (Object)ftlname);
        return ftlname;
    }

    @GetMapping(value={"/sample/{methodname}"})
    public String sampleFtl(@PathVariable(value="methodname") String methodname, Map<String, Object> model) {
        log.info("\u67e5\u770bsample:{}", (Object)methodname);
        model.put("componentName", "goodsExposerImpl");
        model.put("methodName", "onQuery");
        model.put("methodDesc", "\u5546\u54c1\u57fa\u672c\u8d44\u6599\u67e5\u8be2API");
        Random rand = new Random();
        int iLoop = rand.nextInt(3) + 1;
        ArrayList valueList = new ArrayList();
        for (int i = 0; i < iLoop; ++i) {
            HashMap<String, Object> groupMap = new HashMap<String, Object>();
            valueList.add(groupMap);
            ArrayList<Map<String, String>> itemList = new ArrayList<Map<String, String>>();
            String itemName = String.format("item%1$d", i);
            groupMap.put("itemname", itemName);
            groupMap.put("itemdesc", String.format("item desc %1$d", i));
            groupMap.put("itemList", itemList);
            int jLoop = rand.nextInt(3) + 1;
            for (int j = 0; j < jLoop; ++j) {
                Map<String, String> itemMap = MapAs.of("id", i * 10 + j, "name", String.format("name_%1$d", i * 10 + j), "type", "String", "must", "*\u5fc5\u987b", "desc", String.format("\u7b2c%1$d\u4e2a\u53c2\u6570", i * 10 + j), "value", String.format("%1$09d", i * 10 + j));
                itemList.add(itemMap);
            }
        }
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("test", (Object)"aaa");
        model.put("valueList", valueList);
        model.put("simple", JSON.toJSONString((Object)paramsObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
        model.put("methodURL", "http://127.0.0.1:8081/goods/query?method=goodsExposerImpl.onQuery");
        return "coalesce";
    }

    @GetMapping(value={"/generate/{component}"})
    public String generateFtl(@PathVariable(value="component") String componentName, Map<String, Object> model) {
        String methodName;
        log.info("\u67e5\u770bgenerate:{}", (Object)componentName);
        int index = componentName.lastIndexOf(".");
        if (index < 1) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528Bean\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebfAPI\u8c03\u7528\u8bf7\u6c42\u7ec4\u4ef6\u3010%1$s\u3011\u9519\u8bef!", componentName));
            return "failure";
        }
        String beanName = componentName.substring(0, index);
        Method componentMethod = this.invoker.getRealComponentMethod(beanName, methodName = componentName.substring(index + 1));
        if (componentMethod == null) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528Bean\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebfAPI\u8c03\u7528:\u672a\u627e\u5230\u3010%1$s\u3011\u5bf9\u5e94Bean", beanName));
            return "failure";
        }
        Object exposer = this.invoker.getRealComponent(beanName);
        model.put("componentName", beanName);
        model.put("methodName", methodName);
        model.put("methodDesc", "\u8bf7\u6c42\u65b9\u6cd5\u8bf4\u660e\u6ca1\u914d\u7f6e");
        model.put("collectionName", "\u8fd4\u56de\u6570\u636e\u8868\u540d\u6ca1\u914d\u7f6e");
        ArrayList valueList = new ArrayList();
        ArrayList<Map<String, Object>> responseList = new ArrayList<Map<String, Object>>();
        JSONObject paramsObject = new JSONObject();
        String pathKey = "";
        String dataKey = "";
        try {
            ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>();
            AtomicReference<RestComponent> dataRef = new AtomicReference<RestComponent>();
            pathKey = this.parser.methodParser(exposer, methodName, paramsList, responseList, dataRef);
            RestComponent restComponent = dataRef.get();
            if (restComponent != null) {
                String modelNote = restComponent.note();
                model.put("methodDesc", StringUtils.isEmpty((Object)modelNote) ? "\u8bf7\u6c42\u65b9\u6cd5\u8bf4\u660e\u6ca1\u914d\u7f6e" : modelNote);
                String sampleValue = restComponent.paramsSample();
                if (!StringUtils.isEmpty((Object)sampleValue)) {
                    paramsObject = JSON.parseObject((String)sampleValue);
                }
                dataKey = restComponent.rel();
                model.put("collectionName", dataKey);
                model.put("isReport", restComponent.isReport());
            }
            HashMap<String, Object> defaultMap = new HashMap<String, Object>();
            ArrayList<Map> defaultList = new ArrayList<Map>();
            defaultMap.put("itemname", "all");
            defaultMap.put("itemdesc", "\u5168\u90e8\u53c2\u6570");
            defaultMap.put("itemList", defaultList);
            for (Map map : paramsList) {
                HashMap<String, Object> groupMap = new HashMap<String, Object>();
                ArrayList itemList = new ArrayList();
                String itemName = TypeUtils.castToString(map.get("name"));
                groupMap.put("itemname", itemName);
                groupMap.put("itemdesc", map.get("type"));
                groupMap.put("itemList", itemList);
                Object value = map.get("value");
                if (value == null) continue;
                if (value instanceof List) {
                    List dataList = (List)value;
                    itemList.addAll(dataList);
                    valueList.add(groupMap);
                    continue;
                }
                defaultList.add(map);
            }
            if (defaultList.size() > 0) {
                valueList.add(defaultMap);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5bf9\u8c61\u53d1\u751f\u9519\u8bef:{}", (Object)e.getMessage(), (Object)e);
        }
        String requestURL = null;
        requestURL = !StringUtils.isEmpty((Object)this.swaggerurlprefix) ? String.format("%1$s%2$s?method=%3$s.%4$s", this.swaggerurlprefix, pathKey, beanName, methodName) : String.format("%1$s://%2$s:%3$d%4$s?method=%5$s.%6$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), pathKey, beanName, methodName);
        String reportURL = String.format("%1$s://%2$s:%3$d/preview/ureport/%4$s.%5$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), beanName, methodName);
        model.put("paramsList", valueList);
        model.put("resultList", responseList);
        model.put("simple", JSON.toJSONString((Object)paramsObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
        model.put("methodURL", requestURL);
        model.put("reportURL", reportURL);
        if (!StringUtils.isEmpty((Object)this.swaggerurlprefix)) {
            String applicationname = this.env.getProperty("spring.application.name");
            model.put("prefixurl", "/amp-openapi-forward/" + applicationname);
        } else {
            model.put("prefixurl", "");
        }
        return "coalesce";
    }

    @GetMapping(value={"/preview/ureport/{component}"})
    public ModelAndView generateURP(@PathVariable(value="component") String componentName, Map<String, Object> model) {
        String methodName;
        log.info("\u67e5\u770bgenerateURP:{}", (Object)componentName);
        int index = componentName.lastIndexOf(".");
        if (index < 1) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528Bean\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebf\u751f\u6210u-report\u8c03\u7528\u8bf7\u6c42\u7ec4\u4ef6\u3010%1$s\u3011\u9519\u8bef!", componentName));
            return new ModelAndView("failure");
        }
        String beanName = componentName.substring(0, index);
        Method componentMethod = this.invoker.getComponentMethod(beanName, methodName = componentName.substring(index + 1));
        if (componentMethod == null) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528Bean\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebf\u751f\u6210u-report\u8c03\u7528:\u672a\u627e\u5230\u3010%1$s\u3011\u5bf9\u5e94Bean", beanName));
            return new ModelAndView("failure");
        }
        Object exposer = this.invoker.getContext().getBean(beanName);
        ArrayList<Map<String, Object>> responseList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>();
        AtomicReference<RestComponent> dataRef = new AtomicReference<RestComponent>();
        String pathKey = "";
        try {
            pathKey = this.parser.methodParser(exposer, methodName, paramsList, responseList, dataRef);
        }
        catch (Exception e) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528Bean\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebf\u751f\u6210u-report\u8c03\u7528:\u89e3\u6790\u3010%1$s\u3011\u5bf9\u8c61\u62a5\u9519\uff1a%2$s", componentName, e.getMessage()));
            e.printStackTrace();
            return new ModelAndView("failure");
        }
        if (responseList == null || responseList.size() < 1) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528Bean\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebf\u751f\u6210u-report\u8c03\u7528:\u89e3\u6790\u3010%1$s\u3011\u5bf9\u8c61\u5f02\u5e38\uff1a\u672a\u77e5\u7ed3\u679c\u96c6\u7c7b\u578b\u4e0d\u80fd\u751f\u6210\u62a5\u8868\u5c55\u793a", componentName));
            return new ModelAndView("failure");
        }
        String dataKey = "\u8fd4\u56de\u6570\u636e\u8868\u540d";
        RestComponent restComponent = dataRef.get();
        if (restComponent != null) {
            dataKey = restComponent.rel();
        }
        log.info("pathKey:{} collectionName:{} paramsList:{} responseList:{}", new Object[]{pathKey, dataKey, JSON.toJSONString(paramsList), JSON.toJSONString(responseList)});
        String fileName = String.format("%1$s.ureport.xml", componentName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.report.generate(componentName, baos, (Long)0L, componentName, paramsList, responseList);
        byte[] btBuffer = baos.toByteArray();
        String content = "";
        try {
            content = new String(btBuffer, "utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            model.put("time", new Date());
            model.put("title", "API\u751f\u6210\u62a5\u8868\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebf\u751f\u6210u-report\u8c03\u7528:\u89e3\u6790\u3010%1$s\u3011\u5bf9\u8c61\u62a5\u9519\uff1a%2$s", componentName, uee.getMessage()));
            uee.printStackTrace();
            return new ModelAndView("failure");
        }
        FileReportProvider fileReportProvider = SpringContext.getBean(FileReportProvider.class, new Object[0]);
        fileReportProvider.saveReport(fileName, content);
        String requestURL = String.format("%1$s://%2$s:%3$d/ureport/preview?_u=file:%4$s&token=111", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), fileName);
        ModelAndView modelAndView = new ModelAndView((View)new RedirectView(requestURL));
        return modelAndView;
    }

    private ReportService getIdsReportService() {
        return this.iDasReport;
    }

    @GetMapping(value={"/igenerate/ureport/{reportCode}"})
    public ModelAndView iGenerateURP(@PathVariable(value="reportCode") String reportCode, @RequestParam(value="refers", required=false, defaultValue="") String refers, Map<String, Object> model) {
        log.info("\u67e5\u770biDasGenerateURP:{}", (Object)reportCode);
        String fileName = String.format("%1$s.ureport.xml", reportCode);
        List referList = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)refers);
        this.getIdsReportService().generate(0L, reportCode, fileName, referList);
        String requestURL = String.format("%1$s://%2$s:%3$d/ureport/preview?_u=file:%4$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), fileName);
        ModelAndView modelAndView = new ModelAndView((View)new RedirectView(requestURL));
        return modelAndView;
    }

    @GetMapping(value={"/swagger/**"})
    public String onSwagger(@RequestParam(value="method") String method, Map<String, Object> model) {
        RestComponent restComponent;
        String modelValue;
        log.info("\u67e5\u770bAPI\u5904\u7406\u7d22\u5f15:{}", (Object)this.request.getServletPath());
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        String pathKey = this.request.getServletPath().substring(8);
        log.info("\u67e5\u770bAPI\u5904\u7406\u7d22\u5f15:{}", (Object)pathKey);
        MapTable<String, Object> table = this.restController.getTable();
        if (!table.containsKey(pathKey)) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebfAPI\u8c03\u7528:\u8def\u5f84\u3010%1$s\u3011\u5339\u914d\u65b9\u6cd5\u3010%2$s\u3011\u672a\u627e\u5230", pathKey, method));
            return "failure";
        }
        String beanName = (String)table.get(pathKey, "beanName");
        String methodName = (String)table.get(pathKey, "methodName");
        model.put("componentName", beanName);
        model.put("methodName", methodName);
        model.put("methodDesc", "");
        String requestURL = String.format("%1$s://%2$s:%3$d%4$s?method=%5$s.%6$s", this.request.getScheme(), this.request.getServerName(), this.request.getServerPort(), pathKey, beanName, methodName);
        Method componentMethod = this.invoker.getComponentMethod(beanName, methodName);
        if (componentMethod == null) {
            model.put("time", new Date());
            model.put("title", "API\u8c03\u7528Bean\u5f02\u5e38");
            model.put("message", String.format("\u5728\u7ebfAPI\u8c03\u7528:\u8def\u5f84\u3010%1$s\u3011\u5339\u914d\u65b9\u6cd5\u3010%2$s\u3011\u672a\u627e\u5230", pathKey, method));
            return "failure";
        }
        ArrayList<Map<String, String>> valueList = new ArrayList<Map<String, String>>();
        JSONObject paramsObject = new JSONObject();
        Parameter[] parameters = componentMethod.getParameters();
        JSONObject modelObject = new JSONObject();
        boolean isRestComponent = componentMethod.isAnnotationPresent(RestComponent.class);
        if (isRestComponent && !StringUtils.isEmpty((Object)(modelValue = (restComponent = componentMethod.getAnnotation(RestComponent.class)).paramsSample()))) {
            modelObject = JSON.parseObject((String)modelValue);
            log.info("\u83b7\u53d6\u5230\u3010{}.{}\u3011\u793a\u4f8b\u6570\u636e:{}", new Object[]{beanName, methodName, JSON.toJSONString((Object)modelObject)});
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter paramItem = parameters[i];
            String name = paramItem.getName();
            String type = paramItem.getType().getName();
            String desc = "";
            String value = null;
            String must = "";
            boolean isModelProperty = paramItem.isAnnotationPresent(ModelProperty.class);
            if (isModelProperty) {
                ModelProperty modelProperty = paramItem.getAnnotation(ModelProperty.class);
                desc = modelProperty.note();
                must = modelProperty.required() ? "*\u5fc5\u987b" : "";
                value = modelProperty.value();
            }
            Map<String, String> paramsMap = MapAs.of("id", i + 1, "name", name, "type", type, "desc", desc, "must", must, "value", value);
            valueList.add(paramsMap);
            if (paramItem.getType().equals(String.class)) {
                paramsObject.put(name, (Object)(value == null ? "" : value));
                continue;
            }
            if (paramItem.getType().equals(Integer.class)) {
                paramsObject.put(name, (Object)(value == null ? 1 : TypeUtils.castToInt((Object)value)));
                continue;
            }
            if (paramItem.getType().equals(Long.class)) {
                paramsObject.put(name, (Object)(value == null ? 1L : TypeUtils.castToLong((Object)value)));
                continue;
            }
            if (paramItem.getType().equals(Date.class)) {
                paramsObject.put(name, (Object)(value == null ? TypeUtils.castToDate((Object)value) : new Date()));
                continue;
            }
            if (paramItem.getType().equals(JSONObject.class)) {
                paramsObject.put(name, (Object)(value == null ? JSON.parseObject((String)value) : new JSONObject()));
                continue;
            }
            if (paramItem.getType().equals(JSONArray.class)) {
                paramsObject.put(name, (Object)(value == null ? JSON.parseArray((String)value) : new JSONArray()));
                continue;
            }
            if (paramItem.getType().equals(List.class)) {
                paramsObject.put(name, value == null ? TypeUtils.cast((Object)value, List.class, null) : new ArrayList());
                continue;
            }
            if (paramItem.getType().equals(Map.class)) {
                paramsObject.put(name, new HashMap());
                continue;
            }
            Object data = null;
            if (value == null) {
                try {
                    Field[] fields;
                    data = paramItem.getType().newInstance();
                    BeanWrapperImpl beanWrapper = new BeanWrapperImpl(data);
                    for (Field field : fields = data.getClass().getDeclaredFields()) {
                        ModelProperty modelProperty;
                        if (!field.isAnnotationPresent(ModelProperty.class) || StringUtils.isEmpty((Object)(modelProperty = field.getAnnotation(ModelProperty.class)).value())) continue;
                        beanWrapper.setPropertyValue(field.getName(), TypeUtils.cast((Object)modelProperty.value(), field.getType(), null));
                    }
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else {
                data = JSON.parseObject((String)value, paramItem.getType());
            }
            paramsObject.put(name, data);
        }
        model.put("valueList", valueList);
        model.put("simple", JSON.toJSONString((Object)paramsObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat}));
        model.put("methodURL", requestURL);
        log.info(JSON.toJSONString(model));
        return "swagger";
    }
}

