/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.util.TypeUtils;
import com.bstek.ureport.definition.Alignment;
import com.bstek.ureport.definition.Band;
import com.bstek.ureport.definition.Border;
import com.bstek.ureport.definition.BorderStyle;
import com.bstek.ureport.definition.CellDefinition;
import com.bstek.ureport.definition.CellStyle;
import com.bstek.ureport.definition.ColumnDefinition;
import com.bstek.ureport.definition.Expand;
import com.bstek.ureport.definition.HtmlReportAlign;
import com.bstek.ureport.definition.Order;
import com.bstek.ureport.definition.Orientation;
import com.bstek.ureport.definition.PagingMode;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.PaperType;
import com.bstek.ureport.definition.ReportDefinition;
import com.bstek.ureport.definition.RowDefinition;
import com.bstek.ureport.definition.WhiteSpace;
import com.bstek.ureport.definition.dataset.BeanDatasetDefinition;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.SpringBeanDatasourceDefinition;
import com.bstek.ureport.definition.mapping.MappingType;
import com.bstek.ureport.definition.searchform.Align;
import com.bstek.ureport.definition.searchform.ColComponent;
import com.bstek.ureport.definition.searchform.Component;
import com.bstek.ureport.definition.searchform.GridComponent;
import com.bstek.ureport.definition.searchform.LabelPosition;
import com.bstek.ureport.definition.searchform.ResetButtonComponent;
import com.bstek.ureport.definition.searchform.SearchForm;
import com.bstek.ureport.definition.searchform.SubmitButtonComponent;
import com.bstek.ureport.definition.searchform.TextInputComponent;
import com.bstek.ureport.definition.value.AggregateType;
import com.bstek.ureport.definition.value.DatasetValue;
import com.bstek.ureport.definition.value.ExpressionValue;
import com.bstek.ureport.definition.value.SimpleValue;
import com.bstek.ureport.definition.value.Value;
import com.bstek.ureport.definition.value.ValueType;
import com.shiji.core.ureport.component.ReportTitle;
import com.shiji.core.ureport.component.ReportWirter;
import com.shiji.core.ureport.component.SummaryType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractReportService
extends ReportWirter {
    @org.springframework.beans.factory.annotation.Value(value="${ureport.pageSizes:30}")
    Integer pageSizes;
    @org.springframework.beans.factory.annotation.Value(value="${ureport.paperconf.paperType:A3}")
    String papertype;

    protected abstract List<Map<String, Object>> onBeforeGenerateSearchForm(List<Map<String, Object>> var1);

    protected Component onGenerateSearchFormItem(Long entId, Map<String, Object> paramItem) {
        String bindParameter = TypeUtils.castToString((Object)paramItem.get("name"));
        String label = TypeUtils.castToString((Object)paramItem.get("desc"));
        TextInputComponent component = this.createTextInput(bindParameter, label, LabelPosition.left);
        return component;
    }

    public SearchForm generateSearchForm(Long entId, List<Map<String, Object>> paramsList) {
        paramsList = this.onBeforeGenerateSearchForm(paramsList);
        ArrayList<Component> searchComponents = new ArrayList<Component>();
        SubmitButtonComponent submitBtn = this.createSubmitButton("\u6267\u884c\u67e5\u8be2", "btn-default", "Submit-button", Align.left);
        ResetButtonComponent resetBtn = this.createResetButton("\u6e05\u7a7a\u6761\u4ef6", "btn-default", "Reset-button", Align.left);
        ArrayList<Component> componentList = new ArrayList<Component>();
        for (int i = 0; i < paramsList.size(); ++i) {
            Map<String, Object> paramItem = paramsList.get(i);
            Component component = this.onGenerateSearchFormItem(entId, paramItem);
            componentList.add(component);
        }
        if (componentList.size() < 4) {
            if (componentList.size() < 1) {
                ArrayList<ColComponent> colsList = new ArrayList<ColComponent>();
                List<Component> children = Arrays.asList(submitBtn);
                ColComponent colComponent = this.createColComponent(1, children);
                colsList.add(colComponent);
                GridComponent gridComponent = this.createGridComponent(colsList);
                searchComponents.add((Component)gridComponent);
            } else if (componentList.size() < 2) {
                ArrayList<ColComponent> colsList = new ArrayList<ColComponent>();
                colFirstComponent = this.createColComponent(4, Arrays.asList((Component)componentList.get(0)));
                ColComponent colNextComponent = this.createColComponent(2, Arrays.asList(submitBtn));
                ColComponent colLastComponent = this.createColComponent(2, Arrays.asList(resetBtn));
                colsList.add(colFirstComponent);
                colsList.add(colNextComponent);
                colsList.add(colLastComponent);
                GridComponent gridComponent = this.createGridComponent(colsList);
                searchComponents.add((Component)gridComponent);
            } else if (componentList.size() < 3) {
                ArrayList<ColComponent> colsList = new ArrayList<ColComponent>();
                colFirstComponent = this.createColComponent(4, Arrays.asList((Component)componentList.get(0)));
                colSecondComponent = this.createColComponent(4, Arrays.asList((Component)componentList.get(1)));
                ColComponent colNextComponent = this.createColComponent(2, Arrays.asList(submitBtn));
                ColComponent colLastComponent = this.createColComponent(2, Arrays.asList(resetBtn));
                colsList.add(colFirstComponent);
                colsList.add(colSecondComponent);
                colsList.add(colNextComponent);
                colsList.add(colLastComponent);
                GridComponent gridComponent = this.createGridComponent(colsList);
                searchComponents.add((Component)gridComponent);
            } else {
                ArrayList<ColComponent> colsList = new ArrayList<ColComponent>();
                colFirstComponent = this.createColComponent(4, Arrays.asList((Component)componentList.get(0)));
                colSecondComponent = this.createColComponent(4, Arrays.asList((Component)componentList.get(1)));
                ColComponent colThirdComponent = this.createColComponent(4, Arrays.asList((Component)componentList.get(2)));
                ColComponent colNextComponent = this.createColComponent(2, Arrays.asList(submitBtn));
                ColComponent colLastComponent = this.createColComponent(2, Arrays.asList(resetBtn));
                colsList.add(colFirstComponent);
                colsList.add(colSecondComponent);
                colsList.add(colThirdComponent);
                colsList.add(colNextComponent);
                colsList.add(colLastComponent);
                GridComponent gridComponent = this.createGridComponent(colsList);
                searchComponents.add((Component)gridComponent);
            }
        } else if (componentList.size() < 5) {
            isSearchBtn = false;
            boolean isResetBtn = false;
            int i = 0;
            while (i < componentList.size()) {
                ArrayList<ColComponent> colsList = new ArrayList<ColComponent>();
                for (int j = 0; j < 2 && i < componentList.size(); ++j) {
                    ColComponent colComponent = this.createColComponent(3, Arrays.asList((Component)componentList.get(i++)));
                    colsList.add(colComponent);
                }
                if (!isSearchBtn) {
                    isSearchBtn = true;
                    colComponent = this.createColComponent(1, Arrays.asList(submitBtn));
                    colsList.add(colComponent);
                } else if (!isResetBtn) {
                    isResetBtn = true;
                    colComponent = this.createColComponent(1, Arrays.asList(resetBtn));
                    colsList.add(colComponent);
                } else {
                    colComponent = this.createColComponent(1, Arrays.asList(new Component[0]));
                    colsList.add(colComponent);
                }
                GridComponent gridComponent = this.createGridComponent(colsList);
                searchComponents.add((Component)gridComponent);
            }
        } else {
            isSearchBtn = false;
            boolean isResetBtn = false;
            int i = 0;
            while (i < componentList.size()) {
                ArrayList<ColComponent> colsList = new ArrayList<ColComponent>();
                for (int j = 0; j < 3 && i < componentList.size(); ++j) {
                    ColComponent colComponent = this.createColComponent(3, Arrays.asList((Component)componentList.get(i++)));
                    colsList.add(colComponent);
                }
                if (!isSearchBtn) {
                    isSearchBtn = true;
                    colComponent = this.createColComponent(1, Arrays.asList(submitBtn));
                    colsList.add(colComponent);
                } else if (!isResetBtn) {
                    isResetBtn = true;
                    colComponent = this.createColComponent(1, Arrays.asList(resetBtn));
                    colsList.add(colComponent);
                } else {
                    colComponent = this.createColComponent(1, Arrays.asList(new Component[0]));
                    colsList.add(colComponent);
                }
                GridComponent gridComponent = this.createGridComponent(colsList);
                searchComponents.add((Component)gridComponent);
            }
        }
        SearchForm searchForm = this.createSearchForm(searchComponents);
        return searchForm;
    }

    protected DatasetDefinition getBeanDatasetDefinition(String datasetName, String methodName, List<Field> fields) {
        BeanDatasetDefinition dataset = new BeanDatasetDefinition();
        dataset.setName(datasetName);
        dataset.setMethod(methodName);
        dataset.setClazz("");
        dataset.setFields(fields);
        return dataset;
    }

    protected DatasourceDefinition getSpringBeanDataSource(String datasouceName, String beanName, List<DatasetDefinition> datasets) {
        SpringBeanDatasourceDefinition dataSource = new SpringBeanDatasourceDefinition();
        dataSource.setName(datasouceName);
        dataSource.setBeanId(beanName);
        dataSource.setDatasets(datasets);
        return dataSource;
    }

    protected CellStyle getDefaultCellStyle() {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFontSize(10);
        cellStyle.setBgcolor("255,255,255");
        cellStyle.setAlign(Alignment.center);
        cellStyle.setValign(Alignment.middle);
        Border border = new Border();
        border.setWidth(1);
        border.setStyle(BorderStyle.solid);
        border.setColor("0,0,0");
        cellStyle.setLeftBorder(border);
        cellStyle.setRightBorder(border);
        cellStyle.setTopBorder(border);
        cellStyle.setBottomBorder(border);
        return cellStyle;
    }

    protected String getColumnName(int index) {
        String COLUMN_CONSTANT = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int modIndex = index % "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
        int colCount = index / "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length();
        String firstName = "";
        String lastName = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".substring(modIndex, modIndex + 1);
        if (colCount > 0) {
            firstName = this.getColumnName(colCount - 1);
        }
        return String.format("%1$s%2$s", firstName, lastName);
    }

    public String getCellName(int rowIndex, int colIndex) {
        if (colIndex < 0) {
            colIndex = 0;
        }
        String columnName = this.getColumnName(colIndex);
        return String.format("%1$s%2$d", columnName, rowIndex + 1);
    }

    protected CellDefinition generateTitle(ReportTitle title, Integer colSpans, CellStyle style) {
        CellDefinition cellTitle = new CellDefinition();
        cellTitle.setRowNumber(title.getRownumber().intValue());
        cellTitle.setName(this.getCellName(cellTitle.getRowNumber() - 1, cellTitle.getColumnNumber() - 1));
        cellTitle.setColumnNumber(1);
        cellTitle.setExpand(Expand.None);
        cellTitle.setColSpan(colSpans.intValue());
        if (title.getType().equals((Object)ValueType.simple)) {
            cellTitle.setValue((Value)new SimpleValue(title.value));
        } else if (title.getType().equals((Object)ValueType.expression)) {
            cellTitle.setValue((Value)new ExpressionValue(title.value));
        }
        CellStyle titleStyle = new CellStyle();
        BeanUtils.copyProperties((Object)style, (Object)titleStyle);
        titleStyle.setAlign(title.getAlignment());
        titleStyle.setLeftBorder(null);
        titleStyle.setRightBorder(null);
        titleStyle.setTopBorder(null);
        titleStyle.setBottomBorder(null);
        titleStyle.setFontSize(title.getFontSize().intValue());
        titleStyle.setBold(title.getBold());
        cellTitle.setCellStyle(titleStyle);
        return cellTitle;
    }

    protected List<Field> getDefaultGrid(ReportDefinition report, CellStyle style, List<Map<String, Object>> fieldList, List<Map<String, Object>> groupsList, List<ReportTitle> titles) {
        CellStyle stylehead = new CellStyle();
        BeanUtils.copyProperties((Object)style, (Object)stylehead);
        stylehead.setBold(Boolean.valueOf(true));
        CellStyle bodystyle = new CellStyle();
        BeanUtils.copyProperties((Object)style, (Object)bodystyle);
        ArrayList<String> groupFields = new ArrayList<String>();
        if (!StringUtils.isEmpty(groupsList) && groupsList.size() > 0) {
            List<String> list = fieldList.stream().map(p -> p.get("colName").toString()).collect(Collectors.toList());
            for (Map<String, Object> map : groupsList) {
                int leftCellCol = 0;
                if (map.containsKey("groupFields") && !StringUtils.isEmpty((Object)map.get("groupFields"))) {
                    String fields = map.get("groupFields").toString();
                    String[] str = fields.split(",");
                    leftCellCol = this.getLeftCellCol(str, list);
                    groupFields.add(fields);
                }
                map.put("leftCellCol", leftCellCol);
            }
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<CellDefinition> cells = new ArrayList<CellDefinition>();
        ArrayList<RowDefinition> rows = new ArrayList<RowDefinition>();
        ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
        report.setCells(cells);
        report.setRows(rows);
        report.setColumns(columns);
        int rowNumber = 1;
        for (ReportTitle title : titles) {
            RowDefinition rowTitle = new RowDefinition();
            rowTitle.setRowNumber(rowNumber);
            rowTitle.setHeight(title.getHeight().intValue());
            rowTitle.setBand(Band.headerrepeat);
            rows.add(rowTitle);
            title.setRownumber(rowNumber);
            ++rowNumber;
        }
        RowDefinition rowHead = new RowDefinition();
        rowHead.setRowNumber(rowNumber);
        rowHead.setHeight(18);
        rowHead.setBand(Band.headerrepeat);
        rows.add(rowHead);
        RowDefinition row = new RowDefinition();
        row.setRowNumber(++rowNumber);
        row.setHeight(18);
        rows.add(row);
        ++rowNumber;
        if (!StringUtils.isEmpty(groupsList) && groupsList.size() > 0) {
            for (int i = 0; i < groupsList.size(); ++i) {
                RowDefinition rowGroup = new RowDefinition();
                rowGroup.setRowNumber(rowNumber);
                rowGroup.setHeight(18);
                rows.add(rowGroup);
                ++rowNumber;
            }
        }
        if (fieldList.stream().anyMatch(e -> !StringUtils.isEmpty(e.get("summaryType")))) {
            RowDefinition rowtotal = new RowDefinition();
            rowtotal.setRowNumber(rowNumber);
            rowtotal.setHeight(18);
            rowtotal.setBand(Band.summary);
            rows.add(rowtotal);
        }
        for (ReportTitle title : titles) {
            CellDefinition cellTitle = this.generateTitle(title, fieldList.size(), style);
            cells.add(cellTitle);
        }
        for (int i = 0; i < fieldList.size(); ++i) {
            Map<String, Object> fieldMap = fieldList.get(i);
            Field field = new Field(fieldMap.get("colName").toString());
            fields.add(field);
            CellDefinition cellHeader = this.getCellHead(stylehead, fieldMap.get("colText").toString(), i, rowHead.getRowNumber());
            cells.add(cellHeader);
            CellDefinition cellBody = this.getCellBody(style, i, fieldMap, groupFields, row.getRowNumber());
            cells.add(cellBody);
            List<CellDefinition> cellGroups = this.getCellSummary(style, i, fieldMap, groupsList, row.getRowNumber(), fieldList);
            if (!StringUtils.isEmpty(cellGroups) && cellGroups.size() > 0) {
                cells.addAll(cellGroups);
            }
            if (!StringUtils.isEmpty((Object)fieldMap.get("summaryType"))) {
                CellDefinition cellTotal = this.getCellTotal(style, i, rows.size(), fieldMap, fieldList);
                cells.add(cellTotal);
            }
            ColumnDefinition column = new ColumnDefinition();
            column.setColumnNumber(i + 1);
            int width = StringUtils.isEmpty((Object)fieldMap.get("colWidth")) ? 150 : Integer.parseInt(fieldMap.get("colWidth").toString());
            column.setWidth(width);
            columns.add(column);
        }
        this.fillEmptyCell(rows, columns, cells, style);
        return fields;
    }

    public void fillEmptyCell(List<RowDefinition> rows, List<ColumnDefinition> columns, List<CellDefinition> cells, CellStyle style) {
        List spans = cells.stream().filter(e -> e.getColSpan() > 0 || e.getRowSpan() > 0).collect(Collectors.toList());
        ArrayList<CellDefinition> total = new ArrayList<CellDefinition>();
        total.addAll(cells);
        for (CellDefinition cell : spans) {
            int i;
            Integer colspan = StringUtils.isEmpty((Object)cell.getColSpan()) ? 0 : cell.getColSpan();
            Integer rowspan = StringUtils.isEmpty((Object)cell.getRowSpan()) ? 0 : cell.getRowSpan();
            int rownumber = cell.getRowNumber();
            int colnumber = cell.getColumnNumber();
            if (colspan > 0 && rowspan > 0) {
                for (i = 0; i < rowspan; ++i) {
                    ++rownumber;
                    for (int j = 0; j < colspan; ++j) {
                        CellDefinition def = new CellDefinition();
                        def.setColumnNumber(++colnumber);
                        def.setRowNumber(rownumber);
                        def.setName(this.getCellName(def.getRowNumber() - 1, def.getColumnNumber() - 1));
                        total.add(def);
                    }
                }
                continue;
            }
            if (rowspan > 0 && colspan == 0) {
                for (i = 0; i < rowspan; ++i) {
                    CellDefinition def = new CellDefinition();
                    def.setColumnNumber(colnumber);
                    def.setRowNumber(++rownumber);
                    def.setName(this.getCellName(def.getRowNumber() - 1, def.getColumnNumber() - 1));
                    total.add(def);
                }
                continue;
            }
            if (colspan <= 0 || rowspan != 0) continue;
            for (i = 0; i < colspan; ++i) {
                CellDefinition def = new CellDefinition();
                def.setColumnNumber(++colnumber);
                def.setRowNumber(rownumber);
                def.setName(this.getCellName(def.getRowNumber() - 1, def.getColumnNumber() - 1));
                total.add(def);
            }
        }
        for (int i = 0; i < rows.size(); ++i) {
            for (int j = 0; j < columns.size(); ++j) {
                String cellName = this.getCellName(i, j);
                if (total.stream().anyMatch(e -> cellName.equals(e.getName()))) continue;
                CellDefinition emptyCell = new CellDefinition();
                emptyCell.setExpand(Expand.None);
                emptyCell.setName(cellName);
                emptyCell.setRowNumber(i + 1);
                emptyCell.setColumnNumber(j + 1);
                emptyCell.setValue((Value)new SimpleValue(""));
                emptyCell.setCellStyle(style);
                cells.add(emptyCell);
            }
        }
    }

    public void setDataSource(ReportDefinition report, List<DatasourceDefinition> datasources) {
        report.setDatasources(datasources);
    }

    protected Paper getDefaultPaper() {
        PaperType paperType = Enum.valueOf(PaperType.class, this.papertype);
        Paper paper = new Paper();
        paper.setPaperType(paperType);
        paper.setLeftMargin(90);
        paper.setRightMargin(90);
        paper.setTopMargin(72);
        paper.setBottomMargin(72);
        paper.setPagingMode(PagingMode.fixrows);
        paper.setFixRows(this.pageSizes.intValue());
        paper.setWidth(paperType.getPaperSize().getWidth());
        paper.setHeight(paperType.getPaperSize().getHeight());
        paper.setOrientation(Orientation.landscape);
        paper.setHtmlReportAlign(HtmlReportAlign.left);
        paper.setBgImage("");
        paper.setHtmlIntervalRefreshValue(0);
        paper.setColumnEnabled(false);
        return paper;
    }

    public CellDefinition getCellHead(CellStyle style, String title, int col, Integer rowNumber) {
        CellDefinition cellHeader = new CellDefinition();
        cellHeader.setRowNumber(rowNumber.intValue());
        cellHeader.setExpand(Expand.None);
        cellHeader.setName(this.getCellName(rowNumber - 1, col));
        cellHeader.setColumnNumber(col + 1);
        cellHeader.setValue((Value)new SimpleValue(title));
        cellHeader.setCellStyle(style);
        return cellHeader;
    }

    public CellDefinition getCellBody(CellStyle style, int col, Map<String, Object> fieldMap, List<String> groupFields, Integer rowNumber) {
        CellStyle bodystyle = new CellStyle();
        BeanUtils.copyProperties((Object)style, (Object)bodystyle);
        String fieldName = TypeUtils.castToString((Object)fieldMap.get("colName"));
        CellDefinition cellBody = new CellDefinition();
        cellBody.setRowNumber(rowNumber.intValue());
        cellBody.setExpand(Expand.Down);
        cellBody.setName(this.getCellName(rowNumber - 1, col));
        cellBody.setColumnNumber(col + 1);
        if (!StringUtils.isEmpty((Object)fieldMap.get("colAlign"))) {
            bodystyle.setAlign(Alignment.valueOf((String)fieldMap.get("colAlign").toString()));
        }
        if (!StringUtils.isEmpty((Object)fieldMap.get("colFormat"))) {
            bodystyle.setFormat(fieldMap.get("colFormat").toString());
        }
        if (!StringUtils.isEmpty((Object)fieldMap.get("whiteSpace"))) {
            bodystyle.setWhiteSpace(WhiteSpace.valueOf((String)fieldMap.get("whiteSpace").toString()));
        }
        cellBody.setCellStyle(bodystyle);
        DatasetValue value = new DatasetValue();
        value.setDatasetName(TypeUtils.castToString((Object)fieldMap.get("dsName")));
        if (this.isGroupField(fieldName, groupFields)) {
            value.setAggregate(AggregateType.group);
        } else {
            value.setAggregate(AggregateType.select);
        }
        value.setProperty(fieldName);
        value.setOrder(Order.none);
        if (!StringUtils.isEmpty((Object)TypeUtils.castToString((Object)fieldMap.get("colDataset")))) {
            value.setMappingType(MappingType.dataset);
            String mapDataset = String.format("RDS_%1$s", TypeUtils.castToString((Object)fieldMap.get("colDataset")));
            value.setMappingDataset(mapDataset);
            value.setMappingValueProperty(TypeUtils.castToString((Object)fieldMap.get("colValueField")));
            value.setMappingKeyProperty(TypeUtils.castToString((Object)fieldMap.get("colKeyField")));
        } else {
            value.setMappingType(MappingType.simple);
        }
        cellBody.setValue((Value)value);
        return cellBody;
    }

    public List<CellDefinition> getCellSummary(CellStyle style, int col, Map<String, Object> fieldMap, List<Map<String, Object>> groupsList, Integer rowNumber, List<Map<String, Object>> fieldList) {
        String fieldName = fieldMap.get("colName").toString();
        CellStyle summaryStyle = new CellStyle();
        BeanUtils.copyProperties((Object)style, (Object)summaryStyle);
        summaryStyle.setBold(Boolean.valueOf(true));
        if (!StringUtils.isEmpty((Object)fieldMap.get("colFormat"))) {
            summaryStyle.setFormat(fieldMap.get("colFormat").toString());
        }
        ArrayList<CellDefinition> cells = new ArrayList<CellDefinition>();
        Integer rowIndex = rowNumber;
        for (int i = 0; i < groupsList.size(); ++i) {
            Integer n = rowIndex;
            rowIndex = rowIndex + 1;
            JSONObject group = (JSONObject)groupsList.get(i);
            JSONArray array = group.getJSONArray("reportsummarydetail");
            if (!array.stream().anyMatch(e -> fieldName.equals(JSON.parseObject((String)e.toString()).get((Object)"colName")))) continue;
            Map groupFieldMap = (Map)array.stream().filter(e -> fieldName.equals(JSON.parseObject((String)e.toString()).get((Object)"colName"))).collect(Collectors.toList()).get(0);
            String summaryType = groupFieldMap.get("summaryType").toString();
            if (summaryType.equals(SummaryType.TEXT.toString())) {
                summaryStyle.setAlign(Alignment.right);
            } else if (!StringUtils.isEmpty((Object)fieldMap.get("colAlign"))) {
                summaryStyle.setAlign(Alignment.valueOf((String)fieldMap.get("colAlign").toString()));
            }
            CellDefinition cell = new CellDefinition();
            cell.setExpand(Expand.None);
            cell.setRowNumber(rowIndex.intValue());
            cell.setColumnNumber(col + 1);
            cell.setName(this.getCellName(cell.getRowNumber() - 1, cell.getColumnNumber() - 1));
            cell.setLeftParentCellName(this.getGroupFieldLeftCol(Integer.valueOf(group.get((Object)"leftCellCol").toString()), rowNumber));
            cell.setTopParentCellName("root");
            if (summaryType.equals(SummaryType.TEXT.toString())) {
                cell.setValue((Value)new SimpleValue(groupFieldMap.get("summaryMemo").toString()));
            } else if (summaryType.equals(SummaryType.EXPRESSION.toString())) {
                String expression = groupFieldMap.get("summaryMemo").toString().toLowerCase();
                expression = this.transfer(expression, cell.getRowNumber(), fieldList);
                cell.setValue((Value)new ExpressionValue(expression));
            } else {
                cell.setValue((Value)new ExpressionValue(summaryType.toLowerCase() + "(" + this.getCellName(rowNumber - 1, col) + ")"));
            }
            cell.setCellStyle(summaryStyle);
            cells.add(cell);
        }
        return cells;
    }

    public CellDefinition getCellTotal(CellStyle style, int col, int row, Map<String, Object> fieldMap, List<Map<String, Object>> fieldList) {
        CellStyle totalstyle = new CellStyle();
        BeanUtils.copyProperties((Object)style, (Object)totalstyle);
        totalstyle.setBold(Boolean.valueOf(true));
        String fieldName = TypeUtils.castToString((Object)fieldMap.get("colName"));
        CellDefinition cellTotal = new CellDefinition();
        cellTotal.setExpand(Expand.None);
        cellTotal.setRowNumber(row);
        cellTotal.setColumnNumber(col + 1);
        cellTotal.setName(this.getCellName(row - 1, col));
        if (!StringUtils.isEmpty((Object)fieldMap.get("colAlign"))) {
            totalstyle.setAlign(Alignment.valueOf((String)fieldMap.get("colAlign").toString()));
        }
        if (!StringUtils.isEmpty((Object)fieldMap.get("colFormat"))) {
            totalstyle.setFormat(fieldMap.get("colFormat").toString());
        }
        cellTotal.setCellStyle(totalstyle);
        if (fieldMap.get("summaryType").toString().equalsIgnoreCase("TEXT")) {
            cellTotal.setValue((Value)new SimpleValue(fieldMap.get("summaryMemo").toString()));
        } else if (fieldMap.get("summaryType").toString().equalsIgnoreCase("EXPRESSION")) {
            String expression = fieldMap.get("summaryMemo").toString().toLowerCase();
            expression = this.transfer(expression, row, fieldList);
            cellTotal.setValue((Value)new ExpressionValue(expression));
        } else {
            DatasetValue value = new DatasetValue();
            value.setDatasetName(TypeUtils.castToString((Object)fieldMap.get("dsName")) + "_TOTAL");
            value.setAggregate(AggregateType.select);
            value.setProperty(fieldName);
            value.setOrder(Order.none);
            value.setMappingType(MappingType.simple);
            cellTotal.setValue((Value)value);
        }
        return cellTotal;
    }

    public String transfer(String expression, int row, List<Map<String, Object>> fieldList) {
        String exp = expression;
        fieldList = fieldList.stream().sorted(Comparator.comparing(x -> x.get("colName").toString().length())).collect(Collectors.toList());
        Collections.reverse(fieldList);
        for (Map<String, Object> map : fieldList) {
            String colname = map.get("colName").toString().toLowerCase();
            if (!exp.contains(colname)) continue;
            String cellName = this.getCellName(row - 1, Integer.parseInt(map.get("colCol").toString()));
            exp = exp.replace(colname, cellName);
        }
        return exp;
    }

    public boolean isGroupField(String field, List<String> list) {
        Boolean flag = false;
        for (String str : list) {
            if (!str.contains(field)) continue;
            return true;
        }
        return flag;
    }

    public String getGroupFieldLeftCol(int colindex, int rowIndex) {
        String cellName = "";
        cellName = StringUtils.isEmpty((Object)colindex) || colindex == -1 ? "root" : this.getCellName(rowIndex - 1, colindex);
        return cellName;
    }

    public int getLeftCellCol(String[] strs, List<String> list) {
        int i = -1;
        for (String str : strs) {
            int postion = list.indexOf(str);
            if (i >= postion) continue;
            i = postion;
        }
        return i;
    }

    public void setPaper(ReportDefinition report, Paper paper) {
        report.setPaper(paper);
    }
}

