/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.component;

import com.alibaba.fastjson.util.TypeUtils;
import com.bstek.ureport.definition.searchform.Align;
import com.bstek.ureport.definition.searchform.CheckboxInputComponent;
import com.bstek.ureport.definition.searchform.ColComponent;
import com.bstek.ureport.definition.searchform.Component;
import com.bstek.ureport.definition.searchform.DateInputComponent;
import com.bstek.ureport.definition.searchform.FormPosition;
import com.bstek.ureport.definition.searchform.GridComponent;
import com.bstek.ureport.definition.searchform.LabelPosition;
import com.bstek.ureport.definition.searchform.Option;
import com.bstek.ureport.definition.searchform.RadioInputComponent;
import com.bstek.ureport.definition.searchform.ResetButtonComponent;
import com.bstek.ureport.definition.searchform.SearchForm;
import com.bstek.ureport.definition.searchform.SelectInputComponent;
import com.bstek.ureport.definition.searchform.SubmitButtonComponent;
import com.bstek.ureport.definition.searchform.TextInputComponent;
import com.bstek.ureport.definition.searchform.VueISelectComponent;
import com.bstek.ureport.definition.searchform.VueTreeSelectComponent;
import com.google.common.base.Splitter;
import com.shiji.core.ureport.component.TreeCheckboxInputComponent;
import java.util.List;
import java.util.ListIterator;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReportComponentWriter {
    private static final Logger log = LoggerFactory.getLogger(ReportComponentWriter.class);

    protected SearchForm createSearchForm(List<Component> components) {
        SearchForm component = new SearchForm();
        component.setFormPosition(FormPosition.up);
        component.setComponents(components);
        return component;
    }

    protected GridComponent createGridComponent(List<ColComponent> cols) {
        GridComponent component = new GridComponent();
        component.setType("GridCustom");
        component.setShowBorder(false);
        component.setBorderWidth(1);
        component.setBorderColor("#cccccc");
        component.setCols(cols);
        return component;
    }

    protected ColComponent createColComponent(int size, List<Component> children) {
        ColComponent component = new ColComponent();
        component.setSize(size);
        component.setChildren(children);
        return component;
    }

    protected DateInputComponent createDateInput(String bindParameter, String label, String format, LabelPosition labelPosition) {
        DateInputComponent component = new DateInputComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("Datetime");
        component.setLabelPosition(labelPosition);
        component.setFormat(format);
        log.info("createTextInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected CheckboxInputComponent createCheckboxInput(String bindParameter, String label, List<Option> options, LabelPosition labelPosition) {
        CheckboxInputComponent component = new CheckboxInputComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("Checkbox");
        component.setLabelPosition(labelPosition);
        component.setOptions(options);
        component.setOptionsInline(true);
        log.info("createCheckboxInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected SelectInputComponent createSelectInput(String bindParameter, String label, String dataset, String labelField, String valueField, LabelPosition labelPosition) {
        SelectInputComponent component = new SelectInputComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("Select");
        component.setLabelPosition(labelPosition);
        component.setUseDataset(true);
        component.setDataset(dataset);
        component.setLabelField(labelField);
        component.setValueField(valueField);
        log.info("createSelectInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected TextInputComponent createTextInput(String bindParameter, String label, LabelPosition labelPosition) {
        TextInputComponent component = new TextInputComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("Text");
        component.setLabelPosition(labelPosition);
        log.info("createTextInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected TreeCheckboxInputComponent createISelectInput(String bindParameter, String label, List<Option> options, LabelPosition labelPosition) {
        TreeCheckboxInputComponent component = new TreeCheckboxInputComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("Checkbox");
        component.setLabelPosition(labelPosition);
        component.setOptions(options);
        component.setOptionsInline(true);
        log.info("createTreeCheckboxInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected VueISelectComponent createVueISelectInput(String bindParameter, String label, String dataset, String labelField, String valueField, List<Option> options, LabelPosition labelPosition) {
        VueISelectComponent component = new VueISelectComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("input-iselect");
        component.setLabelPosition(labelPosition);
        component.setUseDataset(true);
        component.setDataset(dataset);
        component.setLabelField(labelField);
        component.setValueField(valueField);
        component.setOptions(options);
        log.info("createVueISelectInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected VueTreeSelectComponent createVueTreeSelectInput(String bindParameter, String label, String dataset, String labelField, String valueField, List<Option> options, LabelPosition labelPosition) {
        VueTreeSelectComponent component = new VueTreeSelectComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("tree-select");
        component.setLabelPosition(labelPosition);
        component.setUseDataset(true);
        component.setDataset(dataset);
        component.setLabelField(labelField);
        if (!StringUtils.isEmpty((CharSequence)valueField)) {
            List dataList = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)valueField);
            if (dataList.size() > 1) {
                component.setCodeField((String)dataList.get(0));
                component.setParentField((String)dataList.get(1));
            } else if (dataList.size() > 0) {
                component.setCodeField((String)dataList.get(0));
                component.setParentField((String)dataList.get(0));
            } else {
                component.setCodeField(valueField);
                component.setParentField(valueField);
            }
        } else {
            component.setCodeField(valueField);
            component.setParentField(valueField);
        }
        component.setOptions(options);
        log.info("createVueTreeSelectInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected RadioInputComponent createRadioInput(String bindParameter, String label, List<Option> options, LabelPosition labelPosition) {
        RadioInputComponent component = new RadioInputComponent();
        component.setBindParameter(bindParameter);
        component.setLabel(label);
        component.setType("Radio");
        component.setLabelPosition(labelPosition);
        component.setOptions(options);
        component.setOptionsInline(true);
        log.info("createRadioInput bindParameter:{} label:{} labelPosition:{}", new Object[]{bindParameter, label, labelPosition});
        return component;
    }

    protected SubmitButtonComponent createSubmitButton(String label, String style, String type, Align align) {
        SubmitButtonComponent btn = new SubmitButtonComponent();
        btn.setLabel(label);
        btn.setStyle(style);
        btn.setType(type);
        btn.setAlign(align);
        log.info("createSubmitButton label:{} style:{} type:{} align:{}", new Object[]{label, style, type, align});
        return btn;
    }

    protected ResetButtonComponent createResetButton(String label, String style, String type, Align align) {
        ResetButtonComponent btn = new ResetButtonComponent();
        btn.setLabel(label);
        btn.setStyle(style);
        btn.setType(type);
        btn.setAlign(align);
        log.info("createResetButton label:{} style:{} type:{} align:{}", new Object[]{label, style, type, align});
        return btn;
    }

    protected void onWriteTextInputComponent(TransformerHandler handler, TextInputComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        handler.startElement("", "", "input-text", colAtts);
        handler.endElement("", "", "input-text");
    }

    protected void onWriteDateInputComponent(TransformerHandler handler, DateInputComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        colAtts.addAttribute("", "", "format", "", TypeUtils.castToString((Object)component.getFormat()));
        handler.startElement("", "", "input-datetime", colAtts);
        handler.endElement("", "", "input-datetime");
    }

    protected void onWriteRadioInputComponent(TransformerHandler handler, RadioInputComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        colAtts.addAttribute("", "", "options-inline", "", TypeUtils.castToString((Object)component.isOptionsInline()));
        handler.startElement("", "", "input-radio", colAtts);
        if (component.getOptions() != null) {
            for (Option option : component.getOptions()) {
                AttributesImpl optionAtts = new AttributesImpl();
                optionAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)option.getLabel()));
                optionAtts.addAttribute("", "", "value", "", TypeUtils.castToString((Object)option.getValue()));
                handler.startElement("", "", "option", optionAtts);
                handler.endElement("", "", "option");
            }
        }
        handler.endElement("", "", "input-radio");
    }

    protected void onWriteCheckboxInputComponent(TransformerHandler handler, CheckboxInputComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        colAtts.addAttribute("", "", "options-inline", "", TypeUtils.castToString((Object)component.isOptionsInline()));
        handler.startElement("", "", "input-checkbox", colAtts);
        if (component.getOptions() != null) {
            for (Option option : component.getOptions()) {
                AttributesImpl optionAtts = new AttributesImpl();
                optionAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)option.getLabel()));
                optionAtts.addAttribute("", "", "value", "", TypeUtils.castToString((Object)option.getValue()));
                handler.startElement("", "", "option", optionAtts);
                handler.endElement("", "", "option");
            }
        }
        handler.endElement("", "", "input-checkbox");
    }

    protected void onWriteSelectInputComponent(TransformerHandler handler, SelectInputComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        colAtts.addAttribute("", "", "use-dataset", "", TypeUtils.castToString((Object)component.isUseDataset()));
        colAtts.addAttribute("", "", "dataset", "", TypeUtils.castToString((Object)component.getDataset()));
        colAtts.addAttribute("", "", "label-field", "", TypeUtils.castToString((Object)component.getLabelField()));
        colAtts.addAttribute("", "", "value-field", "", TypeUtils.castToString((Object)component.getValueField()));
        handler.startElement("", "", "input-select", colAtts);
        if (component.getOptions() != null) {
            for (Option option : component.getOptions()) {
                AttributesImpl optionAtts = new AttributesImpl();
                optionAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)option.getLabel()));
                optionAtts.addAttribute("", "", "value", "", TypeUtils.castToString((Object)option.getValue()));
                handler.startElement("", "", "option", optionAtts);
                handler.endElement("", "", "option");
            }
        }
        handler.endElement("", "", "input-select");
    }

    protected void onWriteTreeCheckboxInputComponent(TransformerHandler handler, TreeCheckboxInputComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        colAtts.addAttribute("", "", "options-inline", "", TypeUtils.castToString((Object)component.isOptionsInline()));
        handler.startElement("", "", "input-checkbox", colAtts);
        if (component.getOptions() != null) {
            for (Option option : component.getOptions()) {
                AttributesImpl optionAtts = new AttributesImpl();
                optionAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)option.getLabel()));
                optionAtts.addAttribute("", "", "value", "", TypeUtils.castToString((Object)option.getValue()));
                handler.startElement("", "", "option", optionAtts);
                handler.endElement("", "", "option");
            }
        }
        handler.endElement("", "", "input-checkbox");
    }

    protected void onWriteISelectInputComponent(TransformerHandler handler, VueISelectComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        colAtts.addAttribute("", "", "use-dataset", "", TypeUtils.castToString((Object)component.isUseDataset()));
        colAtts.addAttribute("", "", "dataset", "", TypeUtils.castToString((Object)component.getDataset()));
        colAtts.addAttribute("", "", "label-field", "", TypeUtils.castToString((Object)component.getLabelField()));
        colAtts.addAttribute("", "", "value-field", "", TypeUtils.castToString((Object)component.getValueField()));
        handler.startElement("", "", "input-iselect", colAtts);
        if (component.getOptions() != null) {
            for (Option option : component.getOptions()) {
                AttributesImpl optionAtts = new AttributesImpl();
                optionAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)option.getLabel()));
                optionAtts.addAttribute("", "", "value", "", TypeUtils.castToString((Object)option.getValue()));
                handler.startElement("", "", "option", optionAtts);
                handler.endElement("", "", "option");
            }
        }
        handler.endElement("", "", "input-iselect");
    }

    protected void onWriteITreeSelectImputComponent(TransformerHandler handler, VueTreeSelectComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "label-position", "", TypeUtils.castToString((Object)component.getLabelPosition()));
        colAtts.addAttribute("", "", "bind-parameter", "", TypeUtils.castToString((Object)component.getBindParameter()));
        colAtts.addAttribute("", "", "use-dataset", "", TypeUtils.castToString((Object)component.isUseDataset()));
        colAtts.addAttribute("", "", "dataset", "", TypeUtils.castToString((Object)component.getDataset()));
        colAtts.addAttribute("", "", "label-field", "", TypeUtils.castToString((Object)component.getLabelField()));
        String valueFiled = String.format("%1$s,%2$s", TypeUtils.castToString((Object)component.getCodeField()), TypeUtils.castToString((Object)component.getParentField()));
        colAtts.addAttribute("", "", "value-field", "", valueFiled);
        handler.startElement("", "", "tree-select", colAtts);
        handler.endElement("", "", "tree-select");
    }

    protected void onWriteColComponent(TransformerHandler handler, ColComponent colComponent) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "size", "", TypeUtils.castToString((Object)colComponent.getSize()));
        handler.startElement("", "", "col", colAtts);
        ListIterator li = colComponent.getChildren().listIterator();
        while (li.hasNext()) {
            Component component = (Component)li.next();
            if (component instanceof TextInputComponent) {
                this.onWriteTextInputComponent(handler, (TextInputComponent)component);
                continue;
            }
            if (component instanceof DateInputComponent) {
                this.onWriteDateInputComponent(handler, (DateInputComponent)component);
                continue;
            }
            if (component instanceof RadioInputComponent) {
                this.onWriteRadioInputComponent(handler, (RadioInputComponent)component);
                continue;
            }
            if (component instanceof CheckboxInputComponent) {
                this.onWriteCheckboxInputComponent(handler, (CheckboxInputComponent)component);
                continue;
            }
            if (component instanceof TreeCheckboxInputComponent) {
                this.onWriteTreeCheckboxInputComponent(handler, (TreeCheckboxInputComponent)component);
                continue;
            }
            if (component instanceof SelectInputComponent) {
                this.onWriteSelectInputComponent(handler, (SelectInputComponent)component);
                continue;
            }
            if (component instanceof VueISelectComponent) {
                this.onWriteISelectInputComponent(handler, (VueISelectComponent)component);
                continue;
            }
            if (component instanceof VueTreeSelectComponent) {
                this.onWriteITreeSelectImputComponent(handler, (VueTreeSelectComponent)component);
                continue;
            }
            if (component instanceof SubmitButtonComponent) {
                this.onWriteSubmitButtonComponent(handler, (SubmitButtonComponent)component);
                continue;
            }
            if (!(component instanceof ResetButtonComponent)) continue;
            this.onWriteResetButtonComponent(handler, (ResetButtonComponent)component);
        }
        handler.endElement("", "", "col");
    }

    protected void onWriteSubmitButtonComponent(TransformerHandler handler, SubmitButtonComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "align", "", TypeUtils.castToString((Object)component.getAlign()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "style", "", TypeUtils.castToString((Object)component.getStyle()));
        handler.startElement("", "", "button-submit", colAtts);
        handler.endElement("", "", "button-submit");
    }

    protected void onWriteResetButtonComponent(TransformerHandler handler, ResetButtonComponent component) throws SAXException {
        AttributesImpl colAtts = new AttributesImpl();
        colAtts.addAttribute("", "", "label", "", TypeUtils.castToString((Object)component.getLabel()));
        colAtts.addAttribute("", "", "align", "", TypeUtils.castToString((Object)component.getAlign()));
        colAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)component.getType()));
        colAtts.addAttribute("", "", "style", "", TypeUtils.castToString((Object)component.getStyle()));
        handler.startElement("", "", "button-reset", colAtts);
        handler.endElement("", "", "button-reset");
    }

    protected void onWriteGridComponent(TransformerHandler handler, GridComponent gridComponent) throws SAXException {
        AttributesImpl gridAtts = new AttributesImpl();
        gridAtts.addAttribute("", "", "show-border", "", TypeUtils.castToString((Object)gridComponent.isShowBorder()));
        gridAtts.addAttribute("", "", "type", "", TypeUtils.castToString((Object)gridComponent.getType()));
        gridAtts.addAttribute("", "", "border-width", "", TypeUtils.castToString((Object)gridComponent.getBorderWidth()));
        gridAtts.addAttribute("", "", "border-color", "", TypeUtils.castToString((Object)gridComponent.getBorderColor()));
        handler.startElement("", "", "grid", gridAtts);
        ListIterator li = gridComponent.getCols().listIterator();
        while (li.hasNext()) {
            ColComponent component = (ColComponent)li.next();
            this.onWriteColComponent(handler, component);
        }
        handler.endElement("", "", "grid");
    }

    protected void onWriteSearchForm(TransformerHandler handler, SearchForm searchForm) throws SAXException {
        AttributesImpl searchFormAtts = new AttributesImpl();
        searchFormAtts.addAttribute("", "", "form-position", "", TypeUtils.castToString((Object)searchForm.getFormPosition()));
        handler.startElement("", "", "search-form", searchFormAtts);
        ListIterator li = searchForm.getComponents().listIterator();
        while (li.hasNext()) {
            Component component = (Component)li.next();
            if (!(component instanceof GridComponent)) continue;
            GridComponent gridComponent = (GridComponent)component;
            this.onWriteGridComponent(handler, gridComponent);
        }
        handler.endElement("", "", "search-form");
    }
}

