/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.component;

import com.bstek.ureport.definition.dataset.BeanDatasetDefinition;
import com.bstek.ureport.definition.dataset.DatasetDefinition;
import com.bstek.ureport.definition.dataset.Field;
import com.bstek.ureport.definition.datasource.DatasourceDefinition;
import com.bstek.ureport.definition.datasource.SpringBeanDatasourceDefinition;
import com.shiji.core.ureport.component.ReportRowColumnWriter;
import java.util.List;
import java.util.ListIterator;
import javax.xml.transform.sax.TransformerHandler;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReportDataSourceWriter
extends ReportRowColumnWriter {
    protected void onWriteFilelds(TransformerHandler handler, List<Field> fields) throws SAXException {
        ListIterator<Field> li = fields.listIterator();
        while (li.hasNext()) {
            Field field = li.next();
            AttributesImpl fieldAtts = new AttributesImpl();
            fieldAtts.addAttribute("", "", "name", "", field.getName());
            handler.startElement("", "", "field", fieldAtts);
            handler.endElement("", "", "field");
        }
    }

    protected void onWriteDatasets(TransformerHandler handler, List<DatasetDefinition> datasets) throws SAXException {
        ListIterator<DatasetDefinition> li = datasets.listIterator();
        while (li.hasNext()) {
            DatasetDefinition dataset = li.next();
            AttributesImpl datasetAtts = new AttributesImpl();
            if (dataset instanceof BeanDatasetDefinition) {
                BeanDatasetDefinition beanDataset = (BeanDatasetDefinition)dataset;
                datasetAtts.addAttribute("", "", "name", "", beanDataset.getName());
                datasetAtts.addAttribute("", "", "type", "", "bean");
                datasetAtts.addAttribute("", "", "method", "", beanDataset.getMethod());
                datasetAtts.addAttribute("", "", "clazz", "", beanDataset.getClazz());
            }
            handler.startElement("", "", "dataset", datasetAtts);
            List fields = dataset.getFields();
            this.onWriteFilelds(handler, fields);
            handler.endElement("", "", "dataset");
        }
    }

    protected void onWriteDatasources(TransformerHandler handler, List<DatasourceDefinition> datasources) throws SAXException {
        ListIterator<DatasourceDefinition> li = datasources.listIterator();
        while (li.hasNext()) {
            DatasourceDefinition datasource = li.next();
            AttributesImpl datasourceAtts = new AttributesImpl();
            if (!(datasource instanceof SpringBeanDatasourceDefinition)) continue;
            SpringBeanDatasourceDefinition sbdd = (SpringBeanDatasourceDefinition)datasource;
            datasourceAtts.addAttribute("", "", "name", "", sbdd.getName());
            datasourceAtts.addAttribute("", "", "type", "", sbdd.getType().name());
            datasourceAtts.addAttribute("", "", "bean", "", sbdd.getBeanId());
            if (!StringUtils.isEmpty((Object)sbdd.getProxy())) {
                datasourceAtts.addAttribute("", "", "proxy", "", sbdd.getProxy());
            }
            if (!StringUtils.isEmpty((Object)sbdd.getId())) {
                datasourceAtts.addAttribute("", "", "id", "", sbdd.getId());
            }
            handler.startElement("", "", "datasource", datasourceAtts);
            List datasets = sbdd.getDatasets();
            this.onWriteDatasets(handler, datasets);
            handler.endElement("", "", "datasource");
        }
    }
}

