/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.component;

import com.alibaba.fastjson.util.TypeUtils;
import com.bstek.ureport.definition.HeaderFooterDefinition;
import com.bstek.ureport.definition.Paper;
import com.bstek.ureport.definition.ReportDefinition;
import com.shiji.core.ureport.component.ReportDataSourceWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReportWirter
extends ReportDataSourceWriter {
    protected void onWritePaper(TransformerHandler handler, Paper paper) throws SAXException {
        AttributesImpl paperAtts = new AttributesImpl();
        paperAtts.addAttribute("", "", "type", "", paper.getPaperType().name());
        paperAtts.addAttribute("", "", "left-margin", "", TypeUtils.castToString((Object)paper.getLeftMargin()));
        paperAtts.addAttribute("", "", "right-margin", "", TypeUtils.castToString((Object)paper.getRightMargin()));
        paperAtts.addAttribute("", "", "top-margin", "", TypeUtils.castToString((Object)paper.getTopMargin()));
        paperAtts.addAttribute("", "", "bottom-margin", "", TypeUtils.castToString((Object)paper.getBottomMargin()));
        paperAtts.addAttribute("", "", "paging-mode", "", TypeUtils.castToString((Object)paper.getPagingMode()));
        paperAtts.addAttribute("", "", "fixrows", "", TypeUtils.castToString((Object)paper.getFixRows()));
        paperAtts.addAttribute("", "", "width", "", TypeUtils.castToString((Object)paper.getWidth()));
        paperAtts.addAttribute("", "", "height", "", TypeUtils.castToString((Object)paper.getHeight()));
        paperAtts.addAttribute("", "", "orientation", "", TypeUtils.castToString((Object)paper.getOrientation()));
        paperAtts.addAttribute("", "", "html-report-align", "", TypeUtils.castToString((Object)paper.getHtmlReportAlign()));
        paperAtts.addAttribute("", "", "bg-image", "", TypeUtils.castToString((Object)paper.getBgImage()));
        paperAtts.addAttribute("", "", "html-interval-refresh-value", "", TypeUtils.castToString((Object)paper.getHtmlIntervalRefreshValue()));
        paperAtts.addAttribute("", "", "column-enabled", "", TypeUtils.castToString((Object)paper.isColumnEnabled()));
        paperAtts.addAttribute("", "", "autoloader", "", TypeUtils.castToString((Object)paper.isAutoloader()));
        handler.startElement("", "", "paper", paperAtts);
        handler.endElement("", "", "paper");
    }

    protected void onWriteHeaderFooter(TransformerHandler handler, HeaderFooterDefinition headerFooter, String type) throws SAXException {
        AttributesImpl headerFooterAtts = new AttributesImpl();
        headerFooterAtts.addAttribute("", "", "font-family", "", headerFooter.getFontFamily());
        headerFooterAtts.addAttribute("", "", "font-size", "", TypeUtils.castToString((Object)headerFooter.getFontSize()));
        headerFooterAtts.addAttribute("", "", "forecolor", "", headerFooter.getForecolor());
        headerFooterAtts.addAttribute("", "", "margin", "", TypeUtils.castToString((Object)headerFooter.getMargin()));
        if (type.equals("header")) {
            handler.startElement("", "", "header", headerFooterAtts);
            this.onWritHeaderFooterExpr(handler, headerFooter);
            handler.endElement("", "", "header");
        } else if (type.equals("footer")) {
            handler.startElement("", "", "footer", headerFooterAtts);
            this.onWritHeaderFooterExpr(handler, headerFooter);
            handler.endElement("", "", "footer");
        }
    }

    protected void onWritHeaderFooterExpr(TransformerHandler handler, HeaderFooterDefinition headerFooter) throws SAXException {
        AttributesImpl valueAtts = new AttributesImpl();
        if (!StringUtils.isEmpty((Object)headerFooter.getLeft())) {
            handler.startElement("", "", "left", valueAtts);
            handler.startCDATA();
            handler.characters(headerFooter.getLeft().toCharArray(), 0, headerFooter.getLeft().length());
            handler.endCDATA();
            handler.endElement("", "", "left");
        }
        if (!StringUtils.isEmpty((Object)headerFooter.getCenter())) {
            handler.startElement("", "", "center", valueAtts);
            handler.startCDATA();
            handler.characters(headerFooter.getCenter().toCharArray(), 0, headerFooter.getCenter().length());
            handler.endCDATA();
            handler.endElement("", "", "center");
        }
        if (!StringUtils.isEmpty((Object)headerFooter.getRight())) {
            handler.startElement("", "", "right", valueAtts);
            handler.startCDATA();
            handler.characters(headerFooter.getRight().toCharArray(), 0, headerFooter.getRight().length());
            handler.endCDATA();
            handler.endElement("", "", "right");
        }
    }

    protected void onWriteReport(TransformerHandler handler, ReportDefinition report) throws SAXException {
        handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "", "ureport", atts);
        List cells = report.getCells();
        this.onWriteCells(handler, cells);
        List rows = report.getRows();
        this.onWriteRows(handler, rows);
        List columns = report.getColumns();
        this.onWriteColumns(handler, columns);
        List datasources = report.getDatasources();
        this.onWriteDatasources(handler, datasources);
        Paper paper = report.getPaper();
        this.onWritePaper(handler, paper);
        if (!StringUtils.isEmpty((Object)report.getHeader())) {
            this.onWriteHeaderFooter(handler, report.getHeader(), "header");
        }
        if (!StringUtils.isEmpty((Object)report.getFooter())) {
            this.onWriteHeaderFooter(handler, report.getFooter(), "footer");
        }
        handler.endElement("", "", "ureport");
        handler.endDocument();
    }

    public void writerXML(ReportDefinition report, String filename) {
        try {
            File f = new File(filename);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream osw = new FileOutputStream(f);
            this.writerXML(report, osw);
            osw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writerXML(ReportDefinition report, OutputStream outputStream) {
        SAXTransformerFactory stf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            TransformerHandler handler = stf.newTransformerHandler();
            Transformer tr = handler.getTransformer();
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(outputStream);
            handler.setResult(result);
            this.onWriteReport(handler, report);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

