/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.ureport.datasource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.product.util.MapAs;
import com.product.util.TypeUtils;
import com.shiji.core.util.ParserUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="idasReport")
public class IDasReportDataSource {
    private static final Logger log = LoggerFactory.getLogger(IDasReportDataSource.class);
    protected final DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private JdbcTemplate jdbcTemplate;

    private Map<String, Object> getReportMaster(Long entId, String reportCode) {
        String querySQL = "SELECT * FROM reportdefine WHERE reportCode=? AND entId=?";
        log.debug("getReportMaster:{} params(entId={},reportCode={})", new Object[]{querySQL, entId, reportCode});
        List dataList = this.jdbcTemplate.queryForList(querySQL, new Object[]{reportCode, entId});
        Optional optional = dataList.stream().findFirst();
        if (optional.isPresent()) {
            return (Map)optional.get();
        }
        return null;
    }

    private List<Map<String, Object>> getReportCondition(Long entId, Long reportId) {
        String querySQL = "SELECT * FROM reportconds WHERE reportId=? AND entId=? ORDER BY colIndex,dataId";
        log.debug("getReportCondition:{} params(entId={},reportId={})", new Object[]{querySQL, entId, reportId});
        List dataList = this.jdbcTemplate.queryForList(querySQL, new Object[]{reportId, entId});
        return dataList;
    }

    private List<Map<String, Object>> query(String querySQL) {
        log.debug("query:{}", (Object)querySQL);
        List dataList = this.jdbcTemplate.queryForList(querySQL);
        return dataList;
    }

    public List<Map<String, Object>> query(String dataSourceName, String reportCode, Map<String, Object> parameters) {
        List<Map<String, Object>> response = new ArrayList<Map<String, Object>>();
        reportCode = reportCode.startsWith("RDS_") ? reportCode.substring(4) : reportCode;
        log.info("query ---> dsName:{} reportCode:{} parameters:{}", new Object[]{dataSourceName, reportCode, JSON.toJSONStringWithDateFormat(parameters, (String)JSON.DEFFAULT_DATE_FORMAT, (SerializerFeature[])new SerializerFeature[0])});
        Map<String, Object> reportMap = this.getReportMaster(0L, reportCode);
        if (reportMap == null) {
            log.error("\u672a\u627e\u5230\u62a5\u8868\u3010{}\u3011\u7684\u5b9a\u4e49\u4fe1\u606f", (Object)reportCode);
            return response;
        }
        if (!reportMap.containsKey("querySQL")) {
            log.error("\u672a\u627e\u5230\u62a5\u8868\u3010{}\u3011\u7684\u6267\u884c\u8bed\u53e5\u914d\u7f6e\u4fe1\u606f", (Object)reportCode);
            return response;
        }
        String querySQL = TypeUtils.castToString(reportMap.get("querySQL"));
        if (StringUtils.isEmpty((CharSequence)querySQL)) {
            log.error("\u62a5\u8868\u3010{}\u3011\u7684\u6267\u884c\u8bed\u53e5\u914d\u7f6e\u9519\u8bef", (Object)reportCode);
            return response;
        }
        Long reportId = TypeUtils.castToLong(reportMap.get("dataId"));
        List<Map<String, Object>> condList = this.getReportCondition(0L, reportId);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (parameters.size() > 0) {
            for (Map<String, Object> conditionMap : condList) {
                String colName = TypeUtils.castToString(conditionMap.get("colName"));
                String colType = TypeUtils.castToString(conditionMap.get("colType"));
                String colNormal = TypeUtils.castToString(conditionMap.get("colNormal"));
                Object value = null;
                if (parameters.containsKey(colName)) {
                    value = parameters.get(colName);
                }
                if (value == null) continue;
                value = value instanceof Date ? String.format("'%1$s'", this.formatter.format((Date)value)) : (value instanceof Long ? Long.toString((Long)value) : (value instanceof Integer ? Integer.toString((Integer)value) : (value instanceof Float ? Float.toString(((Float)value).floatValue()) : (value instanceof Double ? Double.toString((Double)value) : ("undefined".equalsIgnoreCase(value.toString()) ? "" : String.format("'%1$s'", value.toString()))))));
                if (StringUtils.isEmpty((CharSequence)colNormal)) {
                    colNormal = String.format(" AND %1$s=${value}", colName);
                }
                colNormal = ParserUtils.parseNameHolder("${", "}", colNormal, MapAs.of("value", value.toString()));
                log.debug("query column:{} condition:{}", (Object)colName, (Object)colNormal);
                if (StringUtils.isEmpty((CharSequence)value.toString())) continue;
                paramsMap.put(colName, colNormal);
            }
        }
        querySQL = ParserUtils.parseNameHolder("${", "}", querySQL, paramsMap);
        log.debug("query reportSQL:{} params:{}", (Object)querySQL, (Object)JSON.toJSONString(paramsMap));
        if (!StringUtils.isEmpty((CharSequence)querySQL)) {
            response = this.query(querySQL);
        }
        return response;
    }
}

