/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.alibaba.fastjson.JSONException;
import com.product.exception.ServiceRuntimeException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import org.apache.ibatis.transaction.TransactionException;
import org.apache.ibatis.type.TypeException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;

public class ExceptionHandlerUtils {
    public static String getFriendlyErrorMessage(Throwable rootCause) {
        if (rootCause != null) {
            String className = rootCause.getClass().getName();
            if (className.startsWith("java.lang")) {
                return ExceptionHandlerUtils.getJavaLangExceptionMsg(rootCause);
            }
            if (className.startsWith("org.springframework") || className.startsWith("org.mybatis") || className.startsWith("org.apache.ibatis")) {
                return ExceptionHandlerUtils.getSpringFrameworkExceptionMsg(rootCause);
            }
            return ExceptionHandlerUtils.getCommonLibraryExceptionMsg(rootCause);
        }
        return "\u7cfb\u7edf\u672a\u77e5\u5f02\u5e38\uff01";
    }

    private static String getJavaLangExceptionMsg(Throwable rootCause) {
        String errorMessage = rootCause instanceof IllegalArgumentException ? "\u65b9\u6cd5\u53c2\u6570\u9519\u8bef\uff01" : (rootCause instanceof ServiceRuntimeException ? "\u670d\u52a1\u8fd0\u884c\u65f6\u5f02\u5e38\uff01" : (rootCause instanceof NullPointerException ? "\u7a7a\u6307\u9488\u5f02\u5e38\uff01" : (rootCause instanceof ArrayIndexOutOfBoundsException ? "\u6570\u7ec4\u8d8a\u754c\u5f02\u5e38\uff01" : (rootCause instanceof NumberFormatException ? "\u6570\u5b57\u683c\u5f0f\u5f02\u5e38\uff01" : (rootCause instanceof NoSuchMethodException ? "[]" : (rootCause instanceof ArithmeticException ? "\u6570\u5b66\u8fd0\u7b97\u5f02\u5e38\uff01" : (rootCause instanceof ClassCastException ? "\u7c7b\u8f6c\u6362\u5f02\u5e38\uff01" : "\u7cfb\u7edf\u5176\u5b83\u5f02\u5e38\uff01")))))));
        return errorMessage;
    }

    private static String getSpringFrameworkExceptionMsg(Throwable rootCause) {
        String errorMessage = rootCause instanceof DataIntegrityViolationException ? "sql\u6761\u4ef6\u6570\u636e\u5b8c\u6574\u6027\u5f02\u5e38\uff01" : (rootCause instanceof DataAccessException ? "\u6570\u636e\u8bbf\u95ee\u5f02\u5e38\uff01" : (rootCause instanceof DuplicateKeyException ? "\u6570\u636e\u5e93\u91cd\u590d\u952e\u5f02\u5e38\uff01" : (rootCause instanceof MyBatisSystemException ? "MyBatis\u89e3\u6790sql\u5f02\u5e38\uff01" : (rootCause instanceof TransactionException ? "\u4e8b\u52a1\u64cd\u4f5c\u5f02\u5e38\uff01" : (rootCause instanceof TypeException ? "MyBatis\u89e3\u6790sql\u5f02\u5e38\uff01" : "Spring Framework\u6846\u67b6\u5176\u5b83\u5f02\u5e38\uff01")))));
        return errorMessage;
    }

    private static String getCommonLibraryExceptionMsg(Throwable rootCause) {
        String errorMessage = rootCause instanceof JSONException ? "JSON \u89e3\u6790\u6216\u64cd\u4f5c\u5f02\u5e38\uff01" : (rootCause instanceof FileNotFoundException ? "\u6587\u4ef6\u672a\u627e\u5230\u5f02\u5e38\uff01" : (rootCause instanceof IOException ? "\u8f93\u5165\u8f93\u51fa\u64cd\u4f5c\u5f02\u5e38\uff01" : (rootCause instanceof ParseException ? "\u89e3\u6790\u64cd\u4f5c\u5f02\u5e38\uff01" : (rootCause instanceof ServiceRuntimeException ? rootCause.getMessage() : "\u7cfb\u7edf\u5176\u5b83\u5f02\u5e38"))));
        return errorMessage;
    }
}

