/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.product.util.SpringContext;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nUtil {
    private static final Logger log = LoggerFactory.getLogger(I18nUtil.class);
    private static MessageSource messageSource = (MessageSource)SpringContext.getContext().getBean(MessageSource.class);

    public static String getMessage(String code) {
        return I18nUtil.getMessage(code, null, I18nUtil.getDefaultLocal());
    }

    public static String getMessage(String code, Locale locale) {
        return I18nUtil.getMessage(code, null, locale);
    }

    public static String getMessageWithStringLocale(String code, String locale) {
        return I18nUtil.getMessage(code, I18nUtil.toLocale(locale));
    }

    public static String getMessage(String code, String defaultMessage) {
        return I18nUtil.getMessage(code, null, defaultMessage, I18nUtil.getDefaultLocal());
    }

    public static String getMessage(String code, Object[] args) {
        return I18nUtil.getMessage(code, args, I18nUtil.getDefaultLocal());
    }

    public static String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        return messageSource.getMessage(code, args, defaultMessage, locale);
    }

    public static String getMessage(String code, Object[] args, String locale) {
        return I18nUtil.getMessage(code, args, I18nUtil.toLocale(locale));
    }

    public static String getMessage(String code, Object[] args, Locale locale) {
        try {
            return messageSource.getMessage(code, args, locale);
        }
        catch (Exception e) {
            log.error("Query message value by key[{}] error. The reason is:" + e.getMessage(), (Object)code);
            return null;
        }
    }

    public static String getMessageJoin(String[] codes) {
        return I18nUtil.getMessageJoin(codes, I18nUtil.getDefaultLocal());
    }

    public static String getMessageJoin(String[] codes, String lang) {
        Locale locale = I18nUtil.toLocale(lang);
        return I18nUtil.getMessageJoin(codes, locale);
    }

    public static String getMessageJoin(String[] codes, Locale locale) {
        ArrayList<String> msg = new ArrayList<String>();
        for (String code : codes) {
            msg.add(I18nUtil.getMessage(code, locale));
        }
        return String.join((CharSequence)" ", msg);
    }

    public static String getMessage(MessageSourceResolvable resolvable, Locale locale) {
        try {
            return messageSource.getMessage(resolvable, locale);
        }
        catch (Exception e) {
            log.error("Query message value error. The reason is:" + e.getMessage());
            return null;
        }
    }

    public static Locale getLocal() {
        return LocaleContextHolder.getLocale();
    }

    public static Locale getDefaultLocal() {
        return Locale.US;
    }

    public static Locale toLocale(String lang) {
        Locale locale = null;
        locale = lang.toLowerCase().contains("cn") ? Locale.SIMPLIFIED_CHINESE : (lang.toLowerCase().contains("en") ? Locale.US : LocaleUtils.toLocale((String)lang));
        return locale;
    }
}

