/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.Collection;
import java.util.Set;

public class ParamCheckUtil {
    private static Validator validator = null;

    public static <T> String checkParam(T obj) {
        Set<ConstraintViolation<T>> valideSert = ParamCheckUtil.getConstraintViolations(obj);
        if (valideSert != null && valideSert.size() > 0) {
            StringBuilder strBuff = new StringBuilder();
            for (ConstraintViolation<T> cv : valideSert) {
                strBuff.append(cv.getPropertyPath()).append(":").append(cv.getMessage()).append(";");
            }
            return strBuff.toString();
        }
        return null;
    }

    public static <T> void validate(T obj) {
        Set<ConstraintViolation<T>> valideSert = ParamCheckUtil.getConstraintViolations(obj);
        if (valideSert != null && valideSert.size() > 0) {
            ConstraintViolation<T> cv = valideSert.iterator().next();
            throw new IllegalArgumentException(cv.getMessage());
        }
    }

    public static <T> void validate(Collection<T> collection) {
        for (T obj : collection) {
            Set<ConstraintViolation<T>> valideSert = ParamCheckUtil.getConstraintViolations(obj);
            if (valideSert == null || valideSert.size() <= 0) continue;
            ConstraintViolation<T> cv = valideSert.iterator().next();
            throw new IllegalArgumentException(cv.getMessage());
        }
    }

    private static <T> Set<ConstraintViolation<T>> getConstraintViolations(T obj) {
        if (validator == null) {
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            validator = validatorFactory.getValidator();
        }
        return validator.validate(obj, new Class[0]);
    }
}

