/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.product.exception.ServiceRuntimeException;

public class SQLCheckUtil {
    public static SQLExpr filterIllegalChar(SQLExpr value) {
        if (value == null) {
            return null;
        }
        if (value instanceof SQLCharExpr) {
            SQLCharExpr charExpr = (SQLCharExpr)value;
            String strValue = charExpr.getText();
            if (SQLCheckUtil.containsSqlQuery(strValue)) {
                throw new ServiceRuntimeException("SQL\u53c2\u6570\u4e2d\u51fa\u73b0SQL\u6ce8\u5165\u8bed\u53e5: " + strValue);
            }
            if (SQLCheckUtil.containsIllegalChars(strValue)) {
                String sanitizedValue = strValue.replaceAll("[\"'*]", "");
                return new SQLCharExpr(sanitizedValue);
            }
            return value;
        }
        return value;
    }

    private static boolean containsIllegalChars(String strValue) {
        return strValue.contains("'") || strValue.contains("\"") || strValue.contains("*");
    }

    private static boolean containsSqlQuery(String value) {
        if (value == null) {
            return false;
        }
        String lowerCaseValue = value.toLowerCase();
        return lowerCaseValue.contains("select") && lowerCaseValue.contains("from") || lowerCaseValue.contains("update") && lowerCaseValue.contains("set") || lowerCaseValue.contains("delete") && lowerCaseValue.contains("from") || lowerCaseValue.contains("insert") && lowerCaseValue.contains("into") || lowerCaseValue.contains("case") && lowerCaseValue.contains("when") || lowerCaseValue.contains("drop") && lowerCaseValue.contains("table") || lowerCaseValue.contains("truncate") && lowerCaseValue.contains("table");
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }
}

