/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceSession;
import com.product.util.SpringContext;
import com.product.util.TypeUtils;
import com.shiji.core.service.InvokerHandler;
import com.shiji.core.util.BaseInvoker;
import com.shiji.core.util.ExtensionLoader;
import com.shiji.core.util.I18nUtil;
import com.shiji.core.util.ReflectUtils;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestParam;

@Component
public class SpringInvoker
extends BaseInvoker
implements InvokerHandler,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringInvoker.class);
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    protected ApplicationContext applicationContext;
    @Autowired
    private ExtensionLoader loader;

    private <T> Map.Entry<Boolean, String> validateBean(T bean, Class<?> ... groups) {
        HashMap<Boolean, String> responseMap = new HashMap<Boolean, String>();
        Set constraintViolations = validator.validate(bean, (Class[])groups);
        if (constraintViolations.isEmpty()) {
            responseMap.put(true, "\u6821\u9a8c\u901a\u8fc7");
            return (Map.Entry)responseMap.entrySet().stream().findFirst().get();
        }
        ArrayList<CallSite> errors = new ArrayList<CallSite>(10);
        for (ConstraintViolation constraintViolation : constraintViolations) {
            errors.add((CallSite)((Object)(constraintViolation.getPropertyPath() + constraintViolation.getMessage())));
        }
        responseMap.put(false, StringUtils.join(errors, (String)","));
        return (Map.Entry)responseMap.entrySet().stream().findFirst().get();
    }

    public Method getComponentMethod(String componentName, String methodName) {
        Object component = this.applicationContext.getBean(componentName);
        Class<?> componentClazz = ReflectUtils.getClass(component);
        return this.getFirstMethod(componentClazz, methodName);
    }

    public Object getRealComponent(String componentName) {
        Object component = this.applicationContext.getBean(componentName);
        try {
            component = SpringInvoker.getTarget(component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return component;
    }

    public Method getRealComponentMethod(String componentName, String methodName) {
        Object component = this.applicationContext.getBean(componentName);
        try {
            component = SpringInvoker.getTarget(component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class<?> componentClazz = ReflectUtils.getClass(component);
        return this.getFirstMethod(componentClazz, methodName);
    }

    public ApplicationContext getContext() {
        return this.applicationContext;
    }

    @Override
    public Object invoke(String componentName, String componentMethod, Object ... args) {
        Assert.hasText((String)componentName, (String)"componentName is empty");
        Assert.hasText((String)componentMethod, (String)"componentMethod is empty");
        Object component = this.applicationContext.getBean(componentName);
        Method method = this.getMethod(component, componentMethod);
        if (method == null) {
            throw new ServiceRuntimeException(I18nUtil.getMessage("50010", new Object[]{componentMethod}));
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        System.out.println("---->");
        return ReflectionUtils.invokeMethod((Method)method, (Object)component, (Object[])args);
    }

    @Override
    public Object invoke(String methodStr, JSONObject paramsObject) {
        return this.invoke(methodStr, paramsObject, null, null);
    }

    private void onParameterAction(JSONObject paramsObject, Parameter paramItem, Type genericType, List<Object> paramsList) {
        Class actualTypeClazz = Object.class;
        try {
            ParameterizedType parameterizedType;
            Type[] typeList;
            if (genericType instanceof ParameterizedType && (typeList = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()) != null && typeList.length > 0) {
                actualTypeClazz = Class.forName(typeList[0].getTypeName());
            }
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        String name = paramItem.getName();
        Class<?> type = paramItem.getType();
        Object value = paramsObject.get((Object)name);
        Object targetValue = null;
        if (value == null) {
            targetValue = null;
        } else if (value.getClass().getName().equalsIgnoreCase(paramItem.getType().getName())) {
            targetValue = value;
        } else if (value instanceof JSONObject) {
            targetValue = this.toJavaObject((JSONObject)value, paramItem.getType());
        } else if (value instanceof JSONArray) {
            targetValue = this.toJavaObjectList((JSONArray)value, actualTypeClazz);
        } else if (type.equals(String.class)) {
            log.debug("params is String");
            targetValue = paramsObject.getString(name);
        } else if (type.equals(Integer.class)) {
            log.debug("params is Integer");
            targetValue = paramsObject.getIntValue(name);
        } else if (type.equals(Long.class)) {
            log.debug("params is Long");
            targetValue = paramsObject.getLong(name);
        } else if (type.equals(Date.class)) {
            log.debug("params is Date");
            targetValue = paramsObject.getDate(name);
        } else if (type.equals(JSONObject.class)) {
            log.debug("params is JSONObject");
            targetValue = paramsObject.getJSONObject(name);
        } else if (type.equals(JSONArray.class)) {
            log.debug("params is JSONArray");
            targetValue = paramsObject.getJSONArray(name);
        } else if (type.equals(List.class)) {
            log.debug("params is List");
            targetValue = paramsObject.getObject(name, List.class);
        } else if (type.equals(Map.class)) {
            log.debug("params is Map");
            targetValue = paramsObject.getObject(name, Map.class);
        } else {
            log.debug("params is {}", (Object)type.getName());
            targetValue = TypeUtils.cast(value, type, null);
        }
        paramsList.add(targetValue);
    }

    @Override
    public Object invoke(String methodStr, JSONObject paramsObject, AtomicReference<Object> componentRef, AtomicReference<Method> methodRef) {
        Class<?> componentClazz;
        Method method;
        Assert.hasText((String)methodStr, (String)"method is empty");
        if (!methodStr.contains(".")) {
            throw new IllegalArgumentException("method name invalid");
        }
        int lastDot = methodStr.lastIndexOf(".");
        String componentName = methodStr.substring(0, lastDot);
        String componentMethod = methodStr.substring(lastDot + 1);
        Object component = null;
        if (this.loader != null) {
            component = this.loader.with(componentName).queryFirst((Map<String, Object>)paramsObject, true);
            if (component == null) {
                log.info("ExtensionLoader not found:{} with paramsObject:{}", (Object)componentName, (Object)JSON.toJSONString((Object)paramsObject));
            } else {
                log.info("ExtensionLoader found:{} with Object Class:{}", (Object)componentName, (Object)component.getClass().getName());
            }
        }
        if (component == null) {
            component = this.applicationContext.getBean(componentName);
        }
        if (componentRef != null) {
            componentRef.set(component);
        }
        if ((method = this.getFirstMethod(componentClazz = ReflectUtils.getClass(component), componentMethod)) == null) {
            throw new ServiceRuntimeException(I18nUtil.getMessage("50010", new Object[]{componentMethod}));
        }
        if (methodRef != null) {
            methodRef.set(method);
        }
        if (method.getParameterCount() < 1) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)component);
        }
        ArrayList<Object> paramsList = new ArrayList<Object>();
        Type[] genericTypes = method.getGenericParameterTypes();
        Parameter[] parameters = method.getParameters();
        int pCount = method.getParameterCount();
        if (pCount == 1) {
            Parameter paramItem = parameters[0];
            if (!paramsObject.containsKey((Object)paramItem.getName())) {
                Class<?> type = paramItem.getType();
                log.debug("params is {}", (Object)type.getName());
                paramsList.add(TypeUtils.toJavaObject((JSON)paramsObject, type));
            } else {
                Type genericType = genericTypes[0];
                this.onParameterAction(paramsObject, paramItem, genericType, paramsList);
            }
        } else {
            boolean firstSession = false;
            for (int i = 0; i < parameters.length; ++i) {
                Parameter paramItem = parameters[i];
                Type genericType = genericTypes[i];
                Class<?> type = paramItem.getType();
                if (type.equals(ServiceSession.class)) {
                    ServiceSession session = SpringContext.getSession();
                    paramsList.add(session);
                    firstSession = true;
                    continue;
                }
                if (firstSession && type.equals(JSONObject.class) && !paramsObject.containsKey((Object)paramItem.getName())) {
                    paramsList.add(paramsObject);
                    continue;
                }
                this.onParameterAction(paramsObject, paramItem, genericType, paramsList);
            }
        }
        log.debug("paramsList:{}", (Object)JSON.toJSONString(paramsList));
        for (int i = 0; i < parameters.length; ++i) {
            Validated pv;
            Parameter p = parameters[i];
            if (p.isAnnotationPresent(Validated.class)) {
                pv = p.getAnnotation(Validated.class);
                System.out.println("Validated:" + pv.value());
                if (pv.value() == null || pv.value().length < 1) {
                    entry = this.validateBean(paramsList.get(i), new Class[0]);
                    if (!entry.getKey().booleanValue()) {
                        System.out.println("\u6821\u9a8c\u5931\u8d251:" + entry.getValue());
                        throw new ServiceRuntimeException(I18nUtil.getMessage("10025", new Object[]{entry.getValue()}));
                    }
                } else {
                    entry = this.validateBean(paramsList.get(i), pv.value());
                    if (!entry.getKey().booleanValue()) {
                        System.out.println("\u6821\u9a8c\u5931\u8d252:" + entry.getValue());
                        throw new ServiceRuntimeException(I18nUtil.getMessage("10025", new Object[]{entry.getValue()}));
                    }
                }
            }
            if (p.isAnnotationPresent(RequestParam.class) && (pv = p.getAnnotation(RequestParam.class)).required() && paramsList.get(i) == null) {
                System.out.println("\u6821\u9a8c\u5931\u8d253:\u5fc5\u987b\u4f20\u9012\u53c2\u6570:" + p.getName());
                throw new ServiceRuntimeException(I18nUtil.getMessage("10026", new Object[]{p.getName()}));
            }
            if (!p.isAnnotationPresent(NotNull.class)) continue;
            pv = p.getAnnotation(NotNull.class);
            if (paramsList.get(i) != null) continue;
            if (!StringUtils.isEmpty((CharSequence)pv.message())) {
                System.out.println("\u6821\u9a8c\u5931\u8d254:" + pv.message());
                throw new ServiceRuntimeException(I18nUtil.getMessage("10025", new Object[]{pv.message()}));
            }
            System.out.println("\u6821\u9a8c\u5931\u8d255:\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a:" + p.getName());
            throw new ServiceRuntimeException(I18nUtil.getMessage("10027", new Object[]{p.getName()}));
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)component, (Object[])paramsList.toArray());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static Object getTarget(Object proxy) throws Exception {
        if (!AopUtils.isAopProxy((Object)proxy)) {
            return proxy;
        }
        if (AopUtils.isJdkDynamicProxy((Object)proxy)) {
            return SpringInvoker.getJdkDynamicProxyTargetObject(proxy);
        }
        return SpringInvoker.getCglibProxyTargetObject(proxy);
    }

    private static Object getCglibProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
        h.setAccessible(true);
        Object dynamicAdvisedInterceptor = h.get(proxy);
        Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        return target;
    }

    private static Object getJdkDynamicProxyTargetObject(Object proxy) throws Exception {
        Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
        h.setAccessible(true);
        AopProxy aopProxy = (AopProxy)h.get(proxy);
        Field advised = aopProxy.getClass().getDeclaredField("advised");
        advised.setAccessible(true);
        Object target = ((AdvisedSupport)advised.get(aopProxy)).getTargetSource().getTarget();
        return target;
    }
}

