<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<title>API调用调用</title>
</head>
<body>
#if($prefixurl)
<link href="${prefixurl}/static/css/style.css" rel="stylesheet">
<link href="${prefixurl}/static/css/app.css" rel="stylesheet">
<script type="text/javascript" src="${prefixurl}/static/js/jquery-2.1.4.js"></script>
#else
<link href="/static/css/style.css" rel="stylesheet">
<link href="/static/css/app.css" rel="stylesheet">
<script type="text/javascript" src="/static/js/jquery-2.1.4.js"></script>
#end

<script>
	$(function () {
		// 界面加载给table这个class下的所有input增加监听事件
		$(".table input").each(function () {
			$(this).bind("input propertychange", function () {
				getParam();
			});
		});
            
            // 按钮监听事件
            $(".submit").click(function () {
                var methodURL = $('#requestURL').val();
                console.log("requestURL:", methodURL);
                
                var queryParam = $('.input').val();
                console.log("queryParam:", queryParam);
                
                // jquery中使用$.post（）时默认的contentType是application / x-www-form-urlencoded
                // $.post(methodURL, JSON.parse(queryParam), function (data, status) {
                //    // data返回数据，status请求状态
                //    $(".output").val(JSON.stringify(data));
                // }, "json");
                
                $.ajax({
                    url: methodURL,
                    type: 'post',
                    dataType: 'json',
                    data: queryParam,
                    contentType: 'application/json',
                    success: function (data) {
                        console.log("response:", JSON.stringify(data));
                        $('.output').val(JSON.stringify(data));
                    },
                });
           }); 
        });

        // 获取请求参数方法
        function getParam() {
            let param = {};
            $(".table input").each(function () {
                let key = $(this).attr('name');
                let value = $(this).val();
                param[key] = value
            });
            $('.input').val(JSON.stringify(param));
        }
    </script>
    
   <div class="card">
      <div class="card-block">
	    <div>
	        <p><span class="sql">API在线调用 ${componentName}.${methodName}</span>  API说明:${methodDesc}</p>
	        <table class="table" style="border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;">
	            <tr>
	               <td  style="width:80px;border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;"><span style="width: 60px; height:24px;color: red;float:left; text-align:right;" class="sql">请求地址:</span></td>
	               <td  style="width:100%;border-width: 0px;border-style: solid;border-spacing: 0px;padding: 1px;"><input style="width: 100%;height:24px;display: inline-block" type="text" id="requestURL" value="${methodURL!''}" /></td>
	            </tr>
	        </table>
	        
		    <!-- list循环 -->
		    <#if valueList?exists>
		        <table class="table">
		            <tr>
		                <th style="width:200px">参数序号</th>
		                <th>参数名称</th>
		                <th>参数类型</th>
		                <th>参数需求</th>
		                <th>参数描述</th>
		                <th>参数数值</th>
		            </tr>
				    <#list valueList as model>
			            <tr>
			               <td>${model.id!''}</td>
			               <td>${model.name!''}</td>
			               <td>${model.type!''}</td>
			               <td>${model.must!''}</td>
			               <td>${model.desc!''}</td>
			               <td><input type="text" name="${model.name!''}" value="${model.value!''}" /></td>
			            </tr>
				    </#list>
		        </table>
		        <div>
					<textarea class="input" rows="3" cols="20"
							  style="width:100%;height:300px;padding:0px;">${simple}</textarea>
				</div>
				<button class="submit" type="button">在线调用</button>
				<button class="save" type="button">保存参数</button>
				<br>
				<b><span style="color: red">API输出结果</span></b>
				<textarea class="output" rows="3" cols="20" style="width:100%;height:300px;padding:0px;">暂无结果</textarea>
			</#if>
		</div>
	  </div>
   </div>
#if($prefixurl)
<script src="${prefixurl}/static/js/jquery-2.1.4.js"></script>
#else
<script src="/static/js/jquery-2.1.4.js"></script>
#end
</body>
</html>
