/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.processor;

import com.shiji.core.annotation.DmlStatement;
import com.shiji.core.processor.GenerateTagProcessor;
import com.shiji.core.utils.ReleaseUtil;
import com.shiji.core.utils.StringUtil;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.shiji.core.annotation.DmlStatement"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class DmlStatementProcessor
extends AbstractProcessor {
    private void outMessage(String message) {
        System.out.println(message);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    private String getTemplate(String path, DmlStatement option) {
        this.outMessage(String.format("\u5f00\u59cb\u88c5\u5165\u6a21\u7248\u6587\u4ef6:%1$s", GenerateTagProcessor.class.getResource(path)));
        StringBuilder buffer = new StringBuilder();
        InputStream in = GenerateTagProcessor.class.getResourceAsStream(path);
        try (BufferedReader bfReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line = bfReader.readLine();
            while (line != null) {
                buffer.append(line).append('\n');
                line = bfReader.readLine();
            }
            ReleaseUtil.release(bfReader);
            ReleaseUtil.release(in);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return buffer.toString();
    }

    private String getStatementValue(TreeMaker treeMaker, Names names, JCTree.JCAnnotation annotation) {
        AtomicReference dataRef = new AtomicReference();
        annotation.getArguments().forEach(action -> {
            JCTree.JCAssign jcAssign = (JCTree.JCAssign)action;
            dataRef.set(jcAssign.rhs.toString());
        });
        return (String)dataRef.get();
    }

    private java.util.List<Map<String, String>> getMethodDefine(TreeMaker treeMaker, Names names, List<JCTree> memberList) {
        ArrayList<Map<String, String>> configList = new ArrayList<Map<String, String>>();
        for (JCTree item : memberList) {
            if (!item.getKind().equals((Object)Tree.Kind.METHOD)) continue;
            JCTree.JCMethodDecl jcMethod = (JCTree.JCMethodDecl)item;
            HashMap<String, String> methodConfig = new HashMap<String, String>();
            configList.add(methodConfig);
            String returnType = jcMethod.getReturnType().toString();
            java.util.List throwList = jcMethod.getThrows();
            methodConfig.put("methodType", returnType);
            methodConfig.put("methodName", jcMethod.getName().toString());
            methodConfig.put("methodThrow", ((List)throwList).size() > 0 ? String.format(" throws %1$s", throwList) : "");
            java.util.List variableList = jcMethod.getParameters();
            StringBuffer paraBuffer = new StringBuffer();
            StringBuffer initBuffer = new StringBuffer();
            String variableType = "";
            String variableName = "";
            Iterator iterator = ((List)variableList).iterator();
            while (iterator.hasNext()) {
                JCTree.JCVariableDecl variable = (JCTree.JCVariableDecl)iterator.next();
                variableType = variable.getType().toString();
                variableName = variable.getName().toString();
                paraBuffer.append(String.format("%1$s %2$s%3$s", variableType, variableName, iterator.hasNext() ? "," : ""));
                if ("Map<String, Object>".equals(variableType)) {
                    initBuffer.append(String.format("\t\tparamsMap.putAll(%1$s);\n", variable.getName()));
                    continue;
                }
                initBuffer.append(String.format("\t\tparamsMap.put(\"%1$s\",%1$s);\n", variable.getName()));
            }
            methodConfig.put("InitBlock", String.format("\n%1$s", initBuffer.toString()));
            methodConfig.put("paramsList", paraBuffer.toString());
            String statementValue = "";
            JCTree.JCModifiers jcModifiers = jcMethod.getModifiers();
            java.util.List annotationList = jcModifiers.getAnnotations();
            for (JCTree.JCAnnotation annotation : annotationList) {
                JCTree.JCIdent jcIdent = (JCTree.JCIdent)annotation.getAnnotationType();
                methodConfig.put("return", "");
                methodConfig.put("finish", "");
                methodConfig.put("doMethod", "onUpdate");
                if (jcIdent.name.contentEquals("InsertStatement")) {
                    statementValue = this.getStatementValue(treeMaker, names, annotation);
                } else if (jcIdent.name.contentEquals("UpdateStatement")) {
                    statementValue = this.getStatementValue(treeMaker, names, annotation);
                } else if (jcIdent.name.contentEquals("DeleteStatement")) {
                    statementValue = this.getStatementValue(treeMaker, names, annotation);
                } else if (jcIdent.name.contentEquals("SelectStatement")) {
                    statementValue = this.getStatementValue(treeMaker, names, annotation);
                    methodConfig.put("doMethod", "onQuery");
                    if ("Map<String, Object>".equals(returnType)) {
                        methodConfig.put("return", "List<Map<String,Object>> dataList = ");
                        methodConfig.put("finish", "return dataList.stream().findFirst().isPresent()?dataList.stream().findFirst().get():new HashMap<>();");
                    } else {
                        methodConfig.put("return", "return ");
                    }
                }
                if (StringUtil.isEmpty(statementValue)) continue;
                methodConfig.put("statementSQL", statementValue);
            }
        }
        return configList;
    }

    private void onProcessorIServiceImpl(Map<String, String> configMap, DmlStatement option, java.util.List<Map<String, String>> paramsList) throws IOException {
        this.outMessage(String.format("\u5f00\u59cb\u751f\u6210\u63a5\u53e3\u6587\u4ef6:%1$s", configMap.get("modelname")));
        String templateImpl = this.getTemplate("/jet/mapper/NormalMapperImpl.jet", option);
        String templateItem = this.getTemplate("/jet/mapper/NormalMapperItem.jet", option);
        StringBuffer buffer = new StringBuffer();
        if (paramsList != null && paramsList.size() > 0) {
            for (Map<String, String> methodMap : paramsList) {
                String context = StringUtil.parseNameHolder("${", "}", templateItem, methodMap);
                buffer.append(context);
            }
        }
        configMap.put("methodList", buffer.toString());
        String context = StringUtil.parseNameHolder("${", "}", templateImpl, configMap);
        this.onGenerate(String.format("%1$s.%2$sImpl", configMap.get("packageName"), configMap.get("basename")), context);
    }

    private void onGenerate(String builderClassName, String context) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(builderClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.print(context);
        }
    }

    private void writeBuilderFile(String className, DmlStatement option, java.util.List<Map<String, String>> paramsList) throws IOException {
        String packageName = null;
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            packageName = className.substring(0, lastDot);
        }
        String simpleClassName = className.substring(lastDot + 1);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("packageName", packageName);
        context.put("modelname", simpleClassName);
        context.put("basename", simpleClassName);
        context.put("beanName", option.jdbcTemplate());
        context.put("statementSQL", option.jdbcTemplate());
        this.onProcessorIServiceImpl(context, option, paramsList);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        System.out.println("\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002onProcessorIService");
        JavacElements elementUtils = (JavacElements)this.processingEnv.getElementUtils();
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        TreeMaker treeMaker = TreeMaker.instance(context);
        Names names = Names.instance(context);
        System.out.println("onProcessorIService1");
        Set<? extends Element> optionSet = roundEnv.getElementsAnnotatedWith(DmlStatement.class);
        optionSet.forEach(element -> {
            DmlStatement option = element.getAnnotation(DmlStatement.class);
            Type.ClassType classType = (Type.ClassType)element.asType();
            String className = classType.toString();
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)elementUtils.getTree((Element)element);
            java.util.List memberList = jcClassDecl.getMembers();
            java.util.List<Map<String, String>> configList = this.getMethodDefine(treeMaker, names, (List<JCTree>)memberList);
            System.out.println("onProcessorIService2");
            try {
                this.outMessage(String.format("\u5f00\u59cb\u5904\u7406:%1$s \u8868\u540d:%2$s \u4e3b\u952e:%3$s", className, option.tableName(), option.keyName(), option.jdbcTemplate()));
                this.writeBuilderFile(className, option, configList);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

