/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.processor;

import com.shiji.core.annotation.GenerateOption;
import com.shiji.core.utils.ReleaseUtil;
import com.shiji.core.utils.StringUtil;
import com.sun.tools.javac.code.Type;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.shiji.core.annotation.GenerateOption"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class GenerateTagProcessor
extends AbstractProcessor {
    private void outMessage(String message) {
        System.out.println(message);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    private String getTemplate(String path, GenerateOption option) {
        this.outMessage(String.format("\u5f00\u59cb\u88c5\u5165\u6a21\u7248\u6587\u4ef6:%1$s", GenerateTagProcessor.class.getResource(path)));
        StringBuilder buffer = new StringBuilder();
        InputStream in = GenerateTagProcessor.class.getResourceAsStream(path);
        try (BufferedReader bfReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line = bfReader.readLine();
            while (line != null) {
                buffer.append(line).append('\n');
                line = bfReader.readLine();
            }
            ReleaseUtil.release(bfReader);
            ReleaseUtil.release(in);
            if (option.debug()) {
                this.outMessage(String.format("\u6a21\u7248\u6587\u4ef6\u5185\u5bb9:%1$s", buffer.toString()));
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return buffer.toString();
    }

    private void onProcessorIService(Map<String, String> configMap, GenerateOption option) throws IOException {
        this.outMessage(String.format("\u5f00\u59cb\u751f\u6210\u63a5\u53e3\u6587\u4ef6:%1$s", configMap.get("modelname")));
        String template = this.getTemplate("/jet/normal/NormalService.jet", option);
        String context = StringUtil.parseNameHolder("${", "}", template, configMap);
        this.onGenerate(String.format("%1$s.%2$sIService", configMap.get("packageName"), configMap.get("basename")), context);
    }

    private void onProcessorServiceImpl(Map<String, String> configMap, GenerateOption option) throws IOException {
        this.outMessage(String.format("\u5f00\u59cb\u751f\u6210\u670d\u52a1\u6587\u4ef6:%1$s", configMap.get("modelname")));
        String template = this.getTemplate("/jet/normal/NormalServiceImpl.jet", option);
        String context = StringUtil.parseNameHolder("${", "}", template, configMap);
        this.onGenerate(String.format("%1$s.%2$sServiceImpl", configMap.get("packageName"), configMap.get("basename")), context);
    }

    private void onProcessorExposerImpl(Map<String, String> configMap, GenerateOption option) throws IOException {
        this.outMessage(String.format("\u5f00\u59cb\u751f\u6210\u66b4\u9732\u6587\u4ef6:%1$s", configMap.get("modelname")));
        String template = this.getTemplate("/jet/normal/NormalExposerImpl.jet", option);
        String context = StringUtil.parseNameHolder("${", "}", template, configMap);
        this.onGenerate(String.format("%1$s.%2$sExposerImpl", configMap.get("packageName"), configMap.get("basename")), context);
    }

    private void onGenerate(String builderClassName, String context) throws IOException {
        JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(builderClassName, new Element[0]);
        try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
            out.print(context);
        }
    }

    private void writeBuilderFile(String className, GenerateOption option) throws IOException {
        String packageName = null;
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            packageName = className.substring(0, lastDot);
        }
        String simpleClassName = className.substring(lastDot + 1);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("packageName", packageName);
        context.put("modelname", simpleClassName);
        context.put("tablename", option.tablename());
        context.put("basename", StringUtil.upperCaseFirst(option.tablename()));
        context.put("modelkey", option.tablekey());
        context.put("basenote", option.tablenote());
        if (!StringUtil.isEmpty(option.pathKey())) {
            context.put("pathKey", option.pathKey());
        } else {
            context.put("pathKey", option.tablename());
        }
        this.onProcessorIService(context, option);
        this.onProcessorServiceImpl(context, option);
        this.onProcessorExposerImpl(context, option);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> optionSet = roundEnv.getElementsAnnotatedWith(GenerateOption.class);
        optionSet.forEach(element -> {
            GenerateOption option = element.getAnnotation(GenerateOption.class);
            Type.ClassType classType = (Type.ClassType)element.asType();
            String className = classType.toString();
            try {
                this.outMessage(String.format("\u5f00\u59cb\u5904\u7406:%1$s", className));
                this.writeBuilderFile(className, option);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return true;
    }
}

