/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.core.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.shiji.core.annotation.AutoServiceKeeper;
import com.shiji.core.processor.ServiceKeeperFiles;
import com.shiji.core.utils.APUtils;
import com.shiji.core.utils.StringUtil;
import com.sun.tools.javac.code.Type;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.shiji.core.annotation.AutoServiceKeeper"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class ServiceKeeperProcessor
extends AbstractProcessor {
    @VisibleForTesting
    static final String MISSING_SERVICES_ERROR = "No service interfaces provided for element!";
    private Set<String> providers = Sets.newTreeSet();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.processImpl(annotations, roundEnv);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            this.fatalError(writer.toString());
            return true;
        }
    }

    private boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(AutoServiceKeeper.class);
        this.log(annotations.toString());
        this.log(elements.toString());
        for (Element element : elements) {
            AutoServiceKeeper option = element.getAnnotation(AutoServiceKeeper.class);
            Type.ClassType classType = (Type.ClassType)element.asType();
            String className = classType.toString();
            LinkedHashMap<String, Object> configMap = new LinkedHashMap<String, Object>();
            List<? extends TypeMirror> types = APUtils.getTypeMirrorFromAnnotationValue(() -> option.value());
            configMap.put("serviceName", option.serviceName());
            configMap.put("interfaceName", ((TypeMirror)types.stream().findFirst().get()).toString());
            configMap.put("className", className);
            configMap.put("dataId", 1);
            configMap.put("sortIndex", 1);
            if (!StringUtil.isEmpty(option.identifyKey1()) && !StringUtil.isEmpty(option.identifyValue1())) {
                configMap.put("identifyKey1", option.identifyKey1());
                configMap.put("identifyValue1", option.identifyValue1());
            }
            if (!StringUtil.isEmpty(option.identifyKey2()) && !StringUtil.isEmpty(option.identifyValue2())) {
                configMap.put("identifyKey2", option.identifyKey2());
                configMap.put("identifyValue2", option.identifyValue2());
            }
            if (!StringUtil.isEmpty(option.identifyKey3()) && !StringUtil.isEmpty(option.identifyValue3())) {
                configMap.put("identifyKey3", option.identifyKey3());
                configMap.put("identifyValue3", option.identifyValue3());
            }
            if (!StringUtil.isEmpty(option.identifyKey4()) && !StringUtil.isEmpty(option.identifyValue4())) {
                configMap.put("identifyKey4", option.identifyKey4());
                configMap.put("identifyValue4", option.identifyValue4());
            }
            if (!StringUtil.isEmpty(option.identifyKey5()) && !StringUtil.isEmpty(option.identifyValue5())) {
                configMap.put("identifyKey5", option.identifyKey5());
                configMap.put("identifyValue5", option.identifyValue5());
            }
            this.providers.add(JSON.toJSONString(configMap));
            System.out.println(String.format("\u89e3\u6790\u914d\u7f6e\u9879:%1$s", JSON.toJSONString(configMap)));
        }
    }

    private Set<String> oParser(Set<String> oldServices) {
        TreeSet response = Sets.newTreeSet();
        List<String> keyList = Arrays.asList("interfaceName", "className", "serviceName", "dataId", "sortIndex", "identifyKey1", "identifyValue1", "identifyKey2", "identifyValue2", "identifyKey3", "identifyValue3", "identifyKey4", "identifyValue4", "identifyKey5", "identifyValue5");
        for (String itemValue : oldServices) {
            Map dataMap = (Map)JSON.parseObject((String)itemValue, (TypeReference)new TypeReference<Map<String, List<Map<String, Object>>>>(){}, (Feature[])new Feature[0]);
            for (String serviceName : dataMap.keySet()) {
                List itemList = (List)dataMap.get(serviceName);
                for (Map itemMap : itemList) {
                    LinkedHashMap<String, String> configMap = new LinkedHashMap<String, String>();
                    configMap.put("serviceName", serviceName);
                    for (String keyName : keyList) {
                        if (!itemMap.containsKey(keyName)) continue;
                        configMap.put(keyName, (String)itemMap.get(keyName));
                    }
                    response.add(JSON.toJSONString(configMap));
                }
            }
        }
        System.out.println(String.format("\u539f\u914d\u7f6e:%1$s\n\u65b0\u914d\u7f6e:%2$s", JSON.toJSONString(oldServices), JSON.toJSONString((Object)response)));
        return response;
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        String resourceFile = "META-INF/spi/servicekeeper.factories";
        this.log("Working on resource file: " + resourceFile);
        try {
            TreeSet allServices = Sets.newTreeSet();
            try {
                FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                this.log("Looking for existing resource file at " + existingFile.toUri());
                Set<String> oldServices = ServiceKeeperFiles.readServiceFile(existingFile.openInputStream());
                this.log("Existing service entries: " + oldServices);
                allServices.addAll(this.oParser(oldServices));
            }
            catch (IOException e) {
                this.log("Resource file did not already exist.");
            }
            HashSet<String> newServices = new HashSet<String>(this.providers);
            if (allServices.containsAll(newServices)) {
                this.log("No new service entries being added.");
                return;
            }
            allServices.addAll(newServices);
            this.log("New service file contents: " + allServices);
            System.out.println(String.format("\u6700\u7ec8\u914d\u7f6e:%1$s", JSON.toJSONString((Object)allServices)));
            ArrayList<Map> dataList = new ArrayList<Map>();
            for (String itemValue : allServices) {
                Map dataMap = (Map)JSON.parseObject((String)itemValue, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                dataList.add(dataMap);
            }
            System.out.println(JSON.toJSONString(dataList));
            Map<String, List<Map>> mapList = dataList.stream().collect(Collectors.groupingBy(classifier -> StringUtil.isEmpty(classifier.get("serviceName").toString()) ? classifier.get("className").toString() : classifier.get("serviceName").toString()));
            TreeSet dataSet = Sets.newTreeSet();
            for (Map.Entry<String, List<Map>> entry : mapList.entrySet()) {
                HashMap<String, List<Map>> dataMap = new HashMap<String, List<Map>>();
                dataMap.put(entry.getKey(), entry.getValue());
                dataSet.add(JSON.toJSONString(dataMap));
            }
            FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
            OutputStream out = fileObject.openOutputStream();
            ServiceKeeperFiles.writeServiceFile(dataSet, out);
            out.close();
            this.log("Wrote to: " + fileObject.toUri());
        }
        catch (IOException e) {
            this.fatalError("Unable to create " + resourceFile + ", " + e);
            return;
        }
    }

    private void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
            System.out.println(msg);
        }
    }

    private void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
        System.out.println(msg + element + annotation);
    }

    private void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
        System.out.println("FATAL ERROR: " + msg);
    }
}

