/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.redis.util;

import com.efuture.redis.constant.RedisConstant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.query.SortQuery;
import org.springframework.data.redis.core.query.SortQueryBuilder;
import org.springframework.data.redis.core.script.DefaultRedisScript;

public class LuaUtil {
    static String itemName = null;

    public static SortQuery<String> getSortQuery(String store_key, String item, RedisConstant.Sort sort, int start, int count) {
        SortQueryBuilder sq = SortQueryBuilder.sort((Object)store_key);
        sq.limit((long)start, (long)count);
        if (null == item || "".equals(item)) {
            switch (sort) {
                case desc: {
                    sq.order(SortParameters.Order.DESC);
                    break;
                }
                case asc: {
                    sq.order(SortParameters.Order.ASC);
                    break;
                }
                case alpha: {
                    sq.alphabetical(true);
                    break;
                }
                default: {
                    sq.noSort();
                    break;
                }
            }
        } else {
            switch (sort) {
                case desc: {
                    sq.by(itemName + ":*").order(SortParameters.Order.DESC);
                    break;
                }
                case asc: {
                    sq.by(itemName + ":*").order(SortParameters.Order.ASC);
                    break;
                }
                case alpha: {
                    sq.by(itemName + ":*").alphabetical(true);
                }
            }
        }
        return sq.build();
    }

    public List<String> queryIdsByLua(String script, String tableName, Object ... args) {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append(" local resultKeys={};");
        buffer.append(" local key = KEYS[1];");
        buffer.append(" local all = redis.call('zrange', key, 0, -1);");
        buffer.append(" for k,v in ipairs(all) do ");
        buffer.append("   local hashkey = key..':'..v;");
        buffer.append("\t  local tmp2 = redis.call('hget', hashkey, 'name');");
        buffer.append("\t   if tmp2 == ARGV[1] then ");
        buffer.append("\t\t table.insert(resultKeys,v);");
        buffer.append("\t   end;");
        buffer.append("\tend;");
        buffer.append("\treturn resultKeys;");
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText(buffer.toString());
        redisScript.setResultType(List.class);
        ArrayList<String> zsetKey = new ArrayList<String>();
        zsetKey.add(tableName);
        List<String> resultIds = null;
        return resultIds;
    }

    public boolean luaTest() {
        StringBuilder buffer = new StringBuilder(64);
        buffer.append("local function ismember(value, array)");
        buffer.append(" local find=false;");
        buffer.append(" for k,v in ipairs(array) do");
        buffer.append("   if v == value then");
        buffer.append("\t  \t find = true;break;");
        buffer.append("\t  end;");
        buffer.append("\tend;");
        buffer.append("return find;");
        buffer.append("end;");
        buffer.append("local array={'aaa','bbb'};");
        buffer.append("return ismember('aaa1', array);");
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setScriptText(buffer.toString());
        redisScript.setResultType(Boolean.class);
        ArrayList<String> zsetKey = new ArrayList<String>();
        zsetKey.add("aaa");
        return true;
    }

    public static String createLuaScript(String tableName, List<String> fieldList, List<String> operatorList, List<Object> argslist) {
        String luaScript = "";
        StringBuilder buffer = new StringBuilder(64);
        if (operatorList.contains("in")) {
            buffer.append("local function ismember(value, array)");
            buffer.append(" local find=false;");
            buffer.append(" for k,v in ipairs(array) do");
            buffer.append("   if v == value then");
            buffer.append("\t  \t find = true;break;");
            buffer.append("\t  end;");
            buffer.append("\tend;");
            buffer.append("return find;");
            buffer.append("end;");
        }
        buffer.append(" local resultKeys={};");
        buffer.append(" local key = '" + tableName + "';");
        buffer.append(" local all = redis.call('zrange', key, 0, -1);");
        buffer.append(" for k,v in ipairs(all) do");
        buffer.append("   local hashkey = key..':'..v;");
        String luaIfCondition = "";
        for (int i = 0; i < fieldList.size(); ++i) {
            String field = fieldList.get(i);
            String operator = operatorList.get(i);
            Object matchValue = argslist.get(i);
            buffer.append("local tmp_" + field + " = redis.call('hget', hashkey, '" + field + "');");
            luaIfCondition = "".equals(luaIfCondition) ? LuaUtil.getLuaCond(field, operator, matchValue) : luaIfCondition + " and " + LuaUtil.getLuaCond(field, operator, matchValue);
        }
        buffer.append("\t  if " + luaIfCondition + " then");
        buffer.append("\t  \ttable.insert(resultKeys,v);");
        buffer.append("\t  end;");
        buffer.append("\tend;");
        buffer.append("\treturn resultKeys;");
        luaScript = buffer.toString();
        return luaScript;
    }

    private static String getLuaCond(String field, String operator, Object matchValue) {
        String luaIfCondition = "";
        if (matchValue == null) {
            matchValue = "";
        }
        switch (operator) {
            case "=": {
                luaIfCondition = "tmp_" + field + " == '" + matchValue.toString() + "'";
                break;
            }
            case "!=": {
                luaIfCondition = "tmp_" + field + " ~= '" + matchValue.toString() + "'";
                break;
            }
            case "like": {
                luaIfCondition = "string.find(tmp_" + field + ", '" + matchValue.toString() + "')";
                break;
            }
            case "in": {
                if (!(matchValue instanceof List)) break;
                List list = (List)matchValue;
                String luaArray = LuaUtil.convertLuaArray(list);
                luaIfCondition = "ismember(tmp_" + field + "," + luaArray + ")";
                break;
            }
            default: {
                luaIfCondition = "tmp_" + field + operator + "'" + matchValue.toString() + "'";
            }
        }
        return luaIfCondition;
    }

    private static String convertLuaArray(List list) {
        String luaArray = "";
        for (Object object : list) {
            if ("".equals(luaArray)) {
                luaArray = "'" + object.toString() + "'";
                continue;
            }
            luaArray = luaArray + "," + "'" + object.toString() + "'";
        }
        luaArray = "{" + luaArray + "}";
        return luaArray;
    }
}

