/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.redis.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public interface DateUtils {
    public static long getCurrentTimeStamps() {
        Date date = new Date();
        long timestamp = date.getTime();
        return timestamp;
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String formatFileDateTime(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        return format.format(date);
    }

    public static String addMonthFormat(int n) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            String datetime = sdf.format(new Date());
            date = sdf.parse(datetime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        cl.add(2, n);
        date = cl.getTime();
        return sdf.format(date);
    }

    public static String subMonthFormat(int n) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            String datetime = sdf.format(new Date());
            date = sdf.parse(datetime);
            Calendar cl = Calendar.getInstance();
            cl.setTime(date);
            cl.add(2, n);
            date = cl.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sdf.format(date);
    }

    public static Timestamp convertStrToTime(String timeStr) {
        Timestamp ts = null;
        if (timeStr != null && !"".equals(timeStr)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = sdf.parse(timeStr.substring(0, 19));
                ts = new Timestamp(date.getTime());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ts;
    }

    public static Date getFormatDate() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d = new Date();
        String dd = format.format(d);
        Date ddd = null;
        try {
            ddd = format.parse(dd);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return ddd;
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return "weekDay" + weekDays[w];
    }
}

