/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.print.gainscha;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.shiji.common.ChannelDJPrintDataHandler;
import com.shiji.common.ChannelprintrespmappingModel;
import com.shiji.common.RequestCommon;
import com.shiji.common.ResponseCommon;
import com.shiji.common.print.request.AddPrintReq;
import com.shiji.common.print.request.AddPrintReqData;
import com.shiji.common.print.request.DeletePrintReq;
import com.shiji.common.print.request.DeletePrintReqData;
import com.shiji.common.print.request.GetPrintStatusReq;
import com.shiji.common.print.request.GetPrintStatusReqData;
import com.shiji.common.print.request.SendModelPrintReq;
import com.shiji.common.print.request.SendModelPrintReqData;
import com.shiji.common.print.request.SetSoundReq;
import com.shiji.common.print.request.SetSoundReqData;
import com.shiji.common.print.response.AddPrintRespData;
import com.shiji.common.print.response.DeletePrintRespData;
import com.shiji.common.print.response.GetPrintStatusRespData;
import com.shiji.common.print.response.SendModelPrintRespData;
import com.shiji.common.print.response.SetSoundRespData;
import com.shiji.print.gainscha.model.GainschaAuthParam;
import com.shiji.print.gainscha.model.GainschaResModel;
import com.shiji.print.gainscha.model.GetPrintStatusRespModel;
import com.shiji.print.gainscha.utils.GainschaUtil;
import com.shiji.print.gainscha.utils.HttpUtils;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelDJPrintDataAPIImpl
implements ChannelDJPrintDataHandler {
    private static final Logger log = LoggerFactory.getLogger(ChannelDJPrintDataAPIImpl.class);

    public ResponseCommon<GetPrintStatusRespData> getPrintStatus(GetPrintStatusReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        GetPrintStatusRespData respData = new GetPrintStatusRespData();
        GainschaAuthParam authParam = GainschaUtil.getAuthParam((RequestCommon)req);
        GetPrintStatusReqData getPrintStatusReqData = (GetPrintStatusReqData)req.getReqData();
        HashMap<String, String> params = new HashMap<String, String>();
        String reqTime = String.valueOf(Calendar.getInstance().getTimeInMillis());
        params.put("reqTime", reqTime);
        String securityCode = DigestUtils.md5Hex((String)(authParam.getMemberCode() + reqTime + authParam.getSecurityCode()));
        params.put("securityCode", securityCode);
        params.put("memberCode", authParam.getMemberCode());
        params.put("deviceID", getPrintStatusReqData.getDeviceID());
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)HttpUtils.sendPost("https://api.poscom.cn/apisc/getStatus", params));
            if (jsonObject.containsKey((Object)"code")) {
                if (jsonObject.getInteger("code") != 1) {
                    if (jsonObject.containsKey((Object)"msg")) {
                        return ResponseCommon.fail((String)"50000", (String)jsonObject.getString("msg"));
                    }
                    return ResponseCommon.fail((String)"50000", (String)"\u672a\u77e5\u9519\u8bef");
                }
            } else {
                return ResponseCommon.fail((String)"50000", (String)"\u8fd4\u56de\u4e2d\u6ca1\u6709CODE\u5b57\u6bb5\uff0c\u65e0\u6cd5\u5224\u65ad\u60c5\u51b5");
            }
            GetPrintStatusRespModel getPrintStatusRespModel = (GetPrintStatusRespModel)JSON.toJavaObject((JSON)jsonObject, GetPrintStatusRespModel.class);
            respData.setOnline(getPrintStatusRespModel.getStatusList().get(0).getOnline());
            respData.setStatus(getPrintStatusRespModel.getStatusList().get(0).getStatus());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<AddPrintRespData> addPrint(AddPrintReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        AddPrintRespData respData = new AddPrintRespData();
        GainschaAuthParam authParam = GainschaUtil.getAuthParam((RequestCommon)req);
        AddPrintReqData addPrintReqData = (AddPrintReqData)req.getReqData();
        HashMap<String, String> params = new HashMap<String, String>();
        String reqTime = String.valueOf(Calendar.getInstance().getTimeInMillis());
        params.put("reqTime", reqTime);
        String securityCode = DigestUtils.md5Hex((String)(authParam.getMemberCode() + reqTime + authParam.getSecurityCode() + addPrintReqData.getDeviceID()));
        params.put("securityCode", securityCode);
        params.put("memberCode", authParam.getMemberCode());
        params.put("deviceID", addPrintReqData.getDeviceID());
        params.put("devName", addPrintReqData.getDevName());
        if (addPrintReqData.getGrpID() != null) {
            params.put("grpID", addPrintReqData.getGrpID().toString());
        }
        try {
            GainschaResModel gainschaResModel = (GainschaResModel)JSON.parseObject((String)HttpUtils.sendPost("https://api.poscom.cn/apisc/adddev", params), GainschaResModel.class);
            if (gainschaResModel.getCode() != 1) {
                return ResponseCommon.fail((String)"50000", (String)gainschaResModel.getMsg());
            }
            respData.setCode(String.valueOf(gainschaResModel.getCode()));
            respData.setMsg(gainschaResModel.getMsg());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<DeletePrintRespData> deletePrint(DeletePrintReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        DeletePrintRespData respData = new DeletePrintRespData();
        GainschaAuthParam authParam = GainschaUtil.getAuthParam((RequestCommon)req);
        DeletePrintReqData deletePrintReqData = (DeletePrintReqData)req.getReqData();
        HashMap<String, String> params = new HashMap<String, String>();
        String reqTime = String.valueOf(Calendar.getInstance().getTimeInMillis());
        params.put("reqTime", reqTime);
        String securityCode = DigestUtils.md5Hex((String)(authParam.getMemberCode() + reqTime + authParam.getSecurityCode() + deletePrintReqData.getDeviceID()));
        params.put("securityCode", securityCode);
        params.put("memberCode", authParam.getMemberCode());
        params.put("deviceID", deletePrintReqData.getDeviceID());
        try {
            GainschaResModel gainschaResModel = (GainschaResModel)JSON.parseObject((String)HttpUtils.sendPost("https://api.poscom.cn/apisc/deldev", params), GainschaResModel.class);
            if (gainschaResModel.getCode() != 1) {
                return ResponseCommon.fail((String)"50000", (String)gainschaResModel.getMsg());
            }
            respData.setCode(String.valueOf(gainschaResModel.getCode()));
            respData.setMsg(gainschaResModel.getMsg());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<SendModelPrintRespData> SendModelPrint(SendModelPrintReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        SendModelPrintRespData respData = new SendModelPrintRespData();
        GainschaAuthParam authParam = GainschaUtil.getAuthParam((RequestCommon)req);
        SendModelPrintReqData sendModelPrintReqData = (SendModelPrintReqData)req.getReqData();
        HashMap<String, String> params = new HashMap<String, String>();
        String reqTime = String.valueOf(Calendar.getInstance().getTimeInMillis());
        params.put("reqTime", reqTime);
        String securityCode = DigestUtils.md5Hex((String)(authParam.getMemberCode() + sendModelPrintReqData.getDeviceID() + sendModelPrintReqData.getMsgNo() + reqTime + authParam.getSecurityCode()));
        params.put("securityCode", securityCode);
        params.put("memberCode", authParam.getMemberCode());
        params.put("deviceID", sendModelPrintReqData.getDeviceID());
        params.put("templetID", sendModelPrintReqData.getTempletID());
        params.put("tData", sendModelPrintReqData.getTData());
        params.put("msgNo", sendModelPrintReqData.getMsgNo());
        if (sendModelPrintReqData.getCharset() != null) {
            params.put("charset", sendModelPrintReqData.getCharset());
        }
        if (sendModelPrintReqData.getCharset() != null) {
            params.put("reprint", sendModelPrintReqData.getReprint().toString());
        }
        if (sendModelPrintReqData.getCharset() != null) {
            params.put("multi", sendModelPrintReqData.getMulti().toString());
        }
        try {
            GainschaResModel gainschaResModel = (GainschaResModel)JSON.parseObject((String)HttpUtils.sendPost("https://api.poscom.cn/apisc/templetPrint", params), GainschaResModel.class);
            ChannelprintrespmappingModel model = GainschaUtil.getPlatformStatus(req.getChannelId(), String.valueOf(gainschaResModel.getCode()), gainschaResModel.getMsg());
            respData.setCode(String.valueOf(model.getPlatformStatusCode()));
            respData.setMsg(model.getChannelStatusName());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    public ResponseCommon<SetSoundRespData> setSound(SetSoundReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        SetSoundRespData respData = new SetSoundRespData();
        GainschaAuthParam authParam = GainschaUtil.getAuthParam((RequestCommon)req);
        SetSoundReqData setSoundReqData = (SetSoundReqData)req.getReqData();
        HashMap<String, String> params = new HashMap<String, String>();
        String reqTime = String.valueOf(Calendar.getInstance().getTimeInMillis());
        params.put("reqTime", reqTime);
        String securityCode = DigestUtils.md5Hex((String)(authParam.getMemberCode() + reqTime + authParam.getSecurityCode() + setSoundReqData.getDeviceID()));
        params.put("securityCode", securityCode);
        params.put("memberCode", authParam.getMemberCode());
        params.put("deviceID", setSoundReqData.getDeviceID());
        if (setSoundReqData.getSoundType() == 1) {
            params.put("voiceType", "0");
        }
        if (setSoundReqData.getSoundType() == 2) {
            params.put("voiceType", "1");
        }
        try {
            GainschaResModel gainschaResModel = (GainschaResModel)JSON.parseObject((String)HttpUtils.sendPost("https://api.poscom.cn/apisc/setVoiceType", params), GainschaResModel.class);
            if (gainschaResModel.getCode() == 0) {
                return this.sendVolume(req);
            }
            ChannelprintrespmappingModel model = GainschaUtil.getPlatformStatus(req.getChannelId(), String.valueOf(gainschaResModel.getCode()), gainschaResModel.getMsg());
            respData.setCode(String.valueOf(model.getPlatformStatusCode()));
            respData.setMsg(model.getChannelStatusName());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }

    private ResponseCommon<SetSoundRespData> sendVolume(SetSoundReq req) throws Exception {
        ResponseCommon resp = new ResponseCommon();
        SetSoundRespData respData = new SetSoundRespData();
        GainschaAuthParam authParam = GainschaUtil.getAuthParam((RequestCommon)req);
        SetSoundReqData setSoundReqData = (SetSoundReqData)req.getReqData();
        HashMap<String, String> params = new HashMap<String, String>();
        String reqTime = String.valueOf(Calendar.getInstance().getTimeInMillis());
        params.put("reqTime", reqTime);
        String securityCode = DigestUtils.md5Hex((String)(authParam.getMemberCode() + reqTime + authParam.getSecurityCode() + setSoundReqData.getDeviceID()));
        params.put("securityCode", securityCode);
        params.put("memberCode", authParam.getMemberCode());
        params.put("deviceID", setSoundReqData.getDeviceID());
        params.put("volume", setSoundReqData.getVoice().toString());
        try {
            GainschaResModel gainschaResModel = (GainschaResModel)JSON.parseObject((String)HttpUtils.sendPost("https://api.poscom.cn/apisc/sendVolume", params), GainschaResModel.class);
            ChannelprintrespmappingModel model = GainschaUtil.getPlatformStatus(req.getChannelId(), String.valueOf(gainschaResModel.getCode()), gainschaResModel.getMsg());
            respData.setCode(String.valueOf(model.getPlatformStatusCode()));
            respData.setMsg(model.getChannelStatusName());
            resp.setRespCode("0");
            resp.setRespData((Object)respData);
        }
        catch (Exception e) {
            return ResponseCommon.fail((String)"50000", (String)e.getMessage());
        }
        return resp;
    }
}

