/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.print.gainscha.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static int connectTimeOut = 10000;
    private static int readTimeOut = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String urlStr, Map<String, String> params) {
        String result = "";
        HttpURLConnection conn = null;
        String BOUNDARY = "----------------------------------------------";
        try {
            String line;
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(connectTimeOut);
            conn.setReadTimeout(readTimeOut);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (params != null) {
                StringBuffer strBuf = new StringBuffer();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                log.info("\u4f73\u535a\u6253\u5370\u673aRequest" + strBuf.toString());
                out.write(strBuf.toString().getBytes("UTF-8"));
            }
            String endData = "\r\n--" + BOUNDARY + "--\r\n";
            out.write(endData.getBytes());
            out.flush();
            out.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                result = result + line;
            }
            log.info("\u4f73\u535a\u6253\u5370\u673aRESP" + result);
            reader.close();
            reader = null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return result;
    }
}

