/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.mockwebserver.rule;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.mockwebserver.MockWebServer;
import com.squareup.okhttp.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.ExternalResource;

public class MockWebServerRule
extends ExternalResource {
    private static final Logger logger = Logger.getLogger(MockWebServerRule.class.getName());
    private final MockWebServer server = new MockWebServer();
    private boolean started;

    protected void before() {
        if (this.started) {
            return;
        }
        this.started = true;
        try {
            this.server.play();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void after() {
        try {
            this.server.shutdown();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "MockWebServer shutdown failed", e);
        }
    }

    public int getPort() {
        if (!this.started) {
            this.before();
        }
        return this.server.getPort();
    }

    public int getRequestCount() {
        return this.server.getRequestCount();
    }

    public void enqueue(MockResponse response) {
        this.server.enqueue(response);
    }

    public RecordedRequest takeRequest() throws InterruptedException {
        return this.server.takeRequest();
    }

    public URL getUrl(String path) {
        return this.server.getUrl(path);
    }

    public MockWebServer get() {
        return this.server;
    }
}

