/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex;

import com.stimulsoft.base.utils.StiParsedParameters;
import com.stimulsoft.base.utils.StiParserParametersUtil;
import com.stimulsoft.flex.adapters.StiJdbcAdapter;
import com.stimulsoft.flex.adapters.StiMsSqlAdapter;
import com.stimulsoft.flex.adapters.StiMySqlAdapter;
import com.stimulsoft.flex.adapters.StiOracleAdapter;
import com.stimulsoft.flex.adapters.StiPostgreSqlAdapter;
import com.stimulsoft.flex.interactionObject.StiConnectionXml;
import com.stimulsoft.flex.utils.StiJDBCParameters;
import com.stimulsoft.flex.utils.StiJdbcUtil;
import com.stimulsoft.web.utils.StiConnectionType;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;

public class StiLoadDataAction {
    private StiConnectionXml connection;

    public void setConnection(StiConnectionXml connection) {
        this.connection = connection;
    }

    private void fillCustomDatabase() {
        this.connection.setCustomConnectionString(this.getConnectionString());
        this.connection.setUserName(this.getUserName());
        this.connection.setCustomPassword(this.getPassword());
    }

    protected String getConnectionType() {
        return this.connection.getConnectionType();
    }

    protected String getDataSourceName() {
        return this.connection.getDataSourceName();
    }

    public String getQuery() {
        return this.connection.getCorrectQuery();
    }

    protected String getUserName() {
        return this.connection.getUserName();
    }

    protected String getPassword() {
        return this.connection.getDecodePassword();
    }

    protected String getConnectionString() {
        return this.connection.getDecodeConnectionString();
    }

    private StiParsedParameters getParams() {
        return StiParserParametersUtil.parsConectionString((String)this.connection.getDecodeConnectionString());
    }

    public StiJDBCParameters getJDBCConnection() {
        StiConnectionType type = StiConnectionType.valueOf((String)this.connection.getConnectionType());
        String password = this.connection.getDecodePassword();
        String user = this.connection.getUserName();
        switch (type) {
            case StiJdbcDatabase: {
                return new StiJdbcAdapter(this.getParams(), user, password).getJDBCConection();
            }
            case StiMySqlDatabase: {
                return new StiMySqlAdapter(this.getParams(), user, password).getJDBCConection();
            }
            case StiPostgreSQLDatabase: {
                return new StiPostgreSqlAdapter(this.getParams(), user, password).getJDBCConection();
            }
            case StiOracleDatabase: {
                return new StiOracleAdapter(this.getParams(), user, password).getJDBCConection();
            }
            case StiSqlDatabase: {
                return new StiMsSqlAdapter(this.getParams(), user, password).getJDBCConection();
            }
        }
        throw new IllegalArgumentException("This type of connection '" + type.name() + "' is not supported");
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException {
        this.fillCustomDatabase();
        return StiJdbcUtil.getConnection(this.getJDBCConnection());
    }

    public Connection getConnection(HttpServletRequest request) throws ClassNotFoundException, SQLException {
        return null;
    }
}

