/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex;

import com.stimulsoft.base.mail.StiMailProperties;
import com.stimulsoft.flex.interactionObject.StiMailData;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import javax.servlet.http.HttpServletRequest;

public class StiMailAction {
    protected StiMailData mailData;
    protected StiMailProperties mailConf;
    protected Session session;
    protected HttpServletRequest request;

    public void init(StiMailData mailData, StiMailProperties mailConf) {
        this.mailData = mailData;
        this.mailConf = mailConf;
        this.session = this.getSession();
    }

    protected Session getSession() {
        Properties props = this.getProperties();
        return Session.getInstance((Properties)props);
    }

    protected Properties getProperties() {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        return props;
    }

    protected Message getMessage() throws MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.mailConf.getFrom()));
        message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)(StiValidationUtil.isNotNullOrEmpty((String)this.mailData.getMailOptions().getEmail()) ? this.mailData.getMailOptions().getEmail() : this.mailConf.getRecipients())));
        message.setSubject(StiValidationUtil.isNotNullOrEmpty((String)this.mailData.getMailOptions().getSubject()) ? this.mailData.getMailOptions().getSubject() : this.mailConf.getSubject());
        BodyPart text = this.getTextPart();
        BodyPart body = this.getFilePart();
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart(text);
        mp.addBodyPart(body);
        message.setContent((Multipart)mp);
        return message;
    }

    protected BodyPart getTextPart() throws MessagingException {
        MimeBodyPart text = new MimeBodyPart();
        text.setText(StiValidationUtil.isNotNullOrEmpty((String)this.mailData.getMailOptions().getMessage()) ? this.mailData.getMailOptions().getMessage() : this.mailConf.getBody(), "UTF-8", "plain");
        return text;
    }

    protected BodyPart getFilePart() throws MessagingException {
        PreencodedMimeBodyPart body = new PreencodedMimeBodyPart("base64");
        body.setFileName(this.mailData.getMailOptions().getFileName());
        body.setContent((Object)this.mailData.getData(), this.mailData.getMIMEType());
        return body;
    }

    private Transport getTransport() throws MessagingException {
        Transport transport = this.session.getTransport("smtp");
        transport.connect(this.mailConf.getHost(), this.mailConf.getSmtpPort(), this.mailConf.getUserName(), this.mailConf.getPassword());
        return transport;
    }

    public void sendMessage() throws MessagingException {
        Message message = this.getMessage();
        Transport transport = this.getTransport();
        transport.sendMessage(message, message.getAllRecipients());
        transport.close();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }
}

