/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.adapters;

import com.stimulsoft.base.utils.StiParsedParameters;
import com.stimulsoft.flex.utils.StiJDBCParameters;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class StiAbstractAdapter {
    private static final String NOT_FOUND_OPTIONS = "In connection options ''{0}'' not found ''{1}'' ";
    private static final List<String> DATABASE_KEY = Arrays.asList("database", "database name", "databaseName", "data source");
    private static final List<String> PORT_KEY = Arrays.asList("port");
    private static final List<String> HOST_KEY = Arrays.asList("host", "server", "location");
    private static final List<String> USERS_KEYS = Arrays.asList("jdbc.username", "username", "uid", "user", "user id", "userId", "connection.username");
    private static final List<String> PASSWORD_KEYS = Arrays.asList("jdbc.password", "pwd", "password", "connection.password");
    protected static final List<String> URL_KEYS = Arrays.asList("jdbc.url", "connectionurl", "url", "connection.url");
    private static final List<String> DRIVER_KEYS = Arrays.asList("jdbc.driverclassname", "jdbc.driverclass", "jdbc.drivername", "jdbc.driver", "driverclassname", "driverclass", "drivername", "driver", "connection.driver", "connection.driver_class");
    private static final String DEFAULT_PASSWORD = "";
    private static final String DEFAULT_HOST = "localhost";
    private final Map<String, String> params;
    private final String user;
    private final String password;
    protected final StiParsedParameters parsedParameters;

    public StiAbstractAdapter(StiParsedParameters parsedParameters, String user, String password) {
        this.parsedParameters = parsedParameters;
        this.params = (Map)parsedParameters.getLowerKeyValue().clone();
        this.user = user;
        this.password = password;
    }

    public StiJDBCParameters getJDBCConection() {
        String driverName = this.validation(this.getDriverName(), "driver name");
        String connectionURL = this.validation(this.getConnectionURL(), "connection URL");
        String user = this.validation(this.getUser(), "user");
        String password = this.validation(this.getPassword(), "password");
        Map<String, String> otherParams = this.getOtherParams();
        return new StiJDBCParameters(driverName, connectionURL, user, password, otherParams);
    }

    private Map<String, String> getOtherParams() {
        return this.parsedParameters.getOriginalKeyValue(this.params);
    }

    protected String validation(String value, String name) {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format(NOT_FOUND_OPTIONS, this.parsedParameters.getOriginalKeyValue(), name));
        }
        return value;
    }

    protected abstract String getDriverName();

    protected abstract String getConnectionURL();

    protected abstract String getDefaultPort();

    protected String getUser() {
        return this.user == null ? this.getUserForKey() : this.user;
    }

    protected String getPassword() {
        return this.password == null ? this.getPasswordForKey() : this.password;
    }

    protected String getHost() {
        String host = this.getLeastOne(this.getHostKey());
        return host != null ? host : DEFAULT_HOST;
    }

    protected String getPort() {
        String port = this.getLeastOne(this.getPortKey());
        return port != null ? port : this.getDefaultPort();
    }

    protected String getDataBase() {
        return this.getLeastOne(this.getDatabaseName());
    }

    private String getUserForKey() {
        return this.getLeastOne(USERS_KEYS);
    }

    private String getPasswordForKey() {
        String foundPassword = this.getLeastOne(PASSWORD_KEYS);
        return foundPassword != null ? foundPassword : DEFAULT_PASSWORD;
    }

    public boolean hasLeastOne(List<String> keys) {
        return this.hasLeastOne(keys, this.params);
    }

    public boolean hasLeastOne(List<String> keys, Map<String, String> params) {
        for (String key : keys) {
            String value = params.get(key);
            if (value == null) continue;
            return true;
        }
        return false;
    }

    protected String getLeastOne(List<String> keys) {
        for (String key : keys) {
            String value = this.params.get(key);
            if (value == null) continue;
            this.params.remove(key);
            return value;
        }
        return null;
    }

    public List<String> getUrlKeys() {
        return URL_KEYS;
    }

    public List<String> getPortKey() {
        return PORT_KEY;
    }

    public List<String> getHostKey() {
        return HOST_KEY;
    }

    public List<String> getDatabaseName() {
        return DATABASE_KEY;
    }

    public List<String> getDriverKeys() {
        return DRIVER_KEYS;
    }

    protected Map<String, String> getParams() {
        return this.params;
    }
}

