/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.adapters;

import com.stimulsoft.base.utils.StiParsedParameters;
import com.stimulsoft.flex.adapters.StiAbstractAdapter;
import com.stimulsoft.flex.utils.StiJDBCParameters;
import java.util.HashMap;
import java.util.Map;

public class StiJdbcAdapter
extends StiAbstractAdapter {
    public StiJdbcAdapter(StiParsedParameters parsedParameters, String user, String password) {
        super(parsedParameters, user, password);
    }

    @Override
    public StiJDBCParameters getJDBCConection() {
        String validDriverName = this.validation(this.getDriverName(), "driver name");
        String validConnectionURL = this.validation(this.getConnectionURL(), "connection URL");
        String validUser = this.validation(this.getUser(), "user");
        String validPassword = this.validation(this.getPassword(), "password");
        String url = this.completeURL(validConnectionURL);
        HashMap<String, String> other = new HashMap<String, String>();
        return new StiJDBCParameters(validDriverName, url, validUser, validPassword, other);
    }

    private String completeURL(String validConnectionURL) {
        String result = validConnectionURL;
        for (Map.Entry<String, String> element : this.getParams().entrySet()) {
            String originalKey = this.parsedParameters.getOriginalKey(element.getKey());
            result = result + ";" + originalKey + "=" + element.getValue();
        }
        return result;
    }

    @Override
    protected String getConnectionURL() {
        return this.getLeastOne(this.getUrlKeys());
    }

    @Override
    protected String getDriverName() {
        return this.getLeastOne(this.getDriverKeys());
    }

    @Override
    protected String getDefaultPort() {
        throw new UnsupportedOperationException("in JdbcAdapter no default port ");
    }
}

