/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.adapters;

import com.stimulsoft.base.utils.StiParsedParameters;
import com.stimulsoft.flex.adapters.StiAbstractAdapter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.Arrays;
import java.util.List;

public class StiMsSqlAdapter
extends StiAbstractAdapter {
    private static final String DRIVER_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DEFAULT_PORT = "1433";
    private static final String URL = "jdbc:sqlserver://%s%s;databaseName=%s";
    private static final List<String> HOST_KEY = Arrays.asList("host", "server", "data source", "datasource");
    private static final List<String> DATABASE_KEY = Arrays.asList("database", "database name", "databaseName", "initial catalog", "initialcatalog");
    private static final List<String> INSTANCE_KEY = Arrays.asList("instancename", "instance", "instanceName");

    public StiMsSqlAdapter(StiParsedParameters parsedParameters, String user, String password) {
        super(parsedParameters, user, password);
    }

    @Override
    protected String getConnectionURL() {
        String instance = this.getInstance();
        boolean hasPort = this.hasLeastOne(this.getPortKey());
        if (StiValidationUtil.isNotNullOrEmpty((String)instance) && !hasPort) {
            return String.format(URL, this.getHost(), "", this.getDataBase()) + ";instanceName=" + instance;
        }
        return String.format(URL, this.getHost(), this.getPort(), this.getDataBase());
    }

    public String getInstance() {
        return this.getLeastOne(INSTANCE_KEY);
    }

    @Override
    protected String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    protected String getDefaultPort() {
        return DEFAULT_PORT;
    }

    @Override
    public List<String> getHostKey() {
        return HOST_KEY;
    }

    @Override
    public List<String> getDatabaseName() {
        return DATABASE_KEY;
    }
}

