/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.events;

import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.flex.StiFlexConfig;
import com.stimulsoft.flex.StiLoadDataAction;
import com.stimulsoft.flex.interactionObject.StiConnectionXml;
import com.stimulsoft.lib.base64.StiBase64EncoderUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiInteraction;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiDataBand;
import com.stimulsoft.report.components.interfaces.IStiInteraction;
import com.stimulsoft.report.dictionary.databases.StiDatabase;
import com.stimulsoft.report.dictionary.databases.StiJDBCDatabase;
import com.stimulsoft.web.events.StiAbstractAction;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiRenderReport
extends StiAbstractAction {
    private static String DOCUMENT_TAG = "-=reportsnapshot=-";

    public static Element getInteractions(StiReport report, Document doc) {
        Element interactions = doc.createElement("Interactions");
        boolean isInteraction = false;
        Integer pageIndex = 0;
        Hashtable<String, String> dataBandsSorting = new Hashtable<String, String>();
        Element pageElement = null;
        Element componentElement = null;
        for (StiPage page : report.getRenderedPages()) {
            pageElement = doc.createElement("Page");
            pageElement.setAttribute("index", pageIndex.toString());
            interactions.appendChild(pageElement);
            Integer componentIndex = 0;
            for (StiComponent comp : page.GetComponents()) {
                StiComponent interactionComp;
                Object object = interactionComp = comp instanceof IStiInteraction ? comp : null;
                if (interactionComp != null && interactionComp.getInteraction() != null) {
                    StiInteraction interaction = interactionComp.getInteraction();
                    componentElement = doc.createElement("Component");
                    componentElement.setAttribute("index", componentIndex.toString());
                    if (interaction.getSortingEnabled() && !StiValidationUtil.isNullOrEmpty((String)interaction.getSortingColumn())) {
                        isInteraction = true;
                        String dataBandName = interaction.GetSortDataBandName();
                        if (!dataBandsSorting.containsKey(dataBandName)) {
                            dataBandsSorting.put(dataBandName, "");
                            StiDataBand dataBand = (StiDataBand)report.GetComponentByName(dataBandName);
                            for (String sort : dataBand.getSort()) {
                                if (dataBandsSorting.containsKey(dataBandName) && ((String)dataBandsSorting.get(dataBandName)).equals("")) {
                                    dataBandsSorting.put(dataBandName, sort);
                                    continue;
                                }
                                dataBandsSorting.put(dataBandName, (String)dataBandsSorting.get(dataBandName) + ";" + sort);
                            }
                        }
                        String direction = "";
                        switch (interaction.getSortingDirection()) {
                            case Ascending: {
                                direction = "Ascending";
                                break;
                            }
                            case Descending: {
                                direction = "Descending";
                                break;
                            }
                            case None: {
                                direction = "None";
                            }
                        }
                        componentElement.setAttribute("sortingEnabled", String.valueOf(interaction.getSortingEnabled()));
                        componentElement.setAttribute("column", StiXMLConvert.encodeName((String)interaction.getSortingColumn()));
                        componentElement.setAttribute("sortingIndex", String.valueOf(interaction.getSortingIndex()));
                        componentElement.setAttribute("direction", direction);
                    }
                    if (interaction.getDrillDownEnabled() && (interaction.drillDownPageGuid != null || !StiValidationUtil.isNullOrEmpty((String)interaction.getDrillDownReport()))) {
                        isInteraction = true;
                        String drillDownPageGuid = "";
                        if (interaction.getDrillDownPage() != null) {
                            drillDownPageGuid = interaction.getDrillDownPage().getGuid();
                        }
                        componentElement.setAttribute("drillDownEnabled", String.valueOf(interaction.getDrillDownEnabled()));
                        componentElement.setAttribute("pageGuid", drillDownPageGuid);
                        componentElement.setAttribute("reportFile", StiXMLConvert.encodeName((String)interaction.getDrillDownReport()));
                    }
                    pageElement.appendChild(componentElement);
                }
                Integer n = componentIndex;
                Integer n2 = componentIndex = Integer.valueOf(componentIndex + 1);
            }
            Integer n = pageIndex;
            Integer n3 = pageIndex = Integer.valueOf(pageIndex + 1);
        }
        for (String dataBandName : dataBandsSorting.keySet()) {
            pageElement = doc.createElement("DataBand");
            pageElement.setAttribute("name", StiXMLConvert.encodeName((String)dataBandName));
            pageElement.setAttribute("sort", (String)dataBandsSorting.get(dataBandName));
            interactions.appendChild(pageElement);
        }
        if (isInteraction) {
            return interactions;
        }
        return null;
    }

    public void process(InputStream is, OutputStream os, HttpServletRequest request) throws Exception {
        StiReport reportMrt = StiSerializeManager.deserializeReport((InputStream)is);
        for (StiDatabase db : reportMrt.getDictionary().getDatabases()) {
            if (!(db instanceof StiJDBCDatabase) || !"OverrideConnectionString".equals(((StiJDBCDatabase)db).getConnectionString())) continue;
            StiLoadDataAction stubAction = StiFlexConfig.getConfig().getLoadDataActionInstance();
            StiConnectionXml stubConnection = new StiConnectionXml();
            stubConnection.setConnectionString(StiBase64EncoderUtil.encode((String)"OverrideConnectionString"));
            stubAction.setConnection(stubConnection);
            ((StiJDBCDatabase)db).setConnection(stubAction.getConnection());
        }
        StiReport render = StiFlexConfig.getConfig().getRenderReportAction().render(reportMrt, request);
        if (render == null) {
            render = StiFlexConfig.getConfig().getRenderReportAction().render(reportMrt);
        }
        StiSerializeManager.serializeDocument((StiReport)render, (String)"False", (OutputStream)os);
    }
}

