/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.events;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.utils.StiXMLConvert;
import com.stimulsoft.base.utils.StiXmlMarshalUtil;
import com.stimulsoft.base.utils.XmlObject;
import com.stimulsoft.flex.StiFlexConfig;
import com.stimulsoft.flex.StiLoadDataAction;
import com.stimulsoft.flex.interactionObject.StiRetrieveColumns;
import com.stimulsoft.flex.utils.StiWebXmlMarshalUtil;
import com.stimulsoft.report.StiJsonToDataSetConverter;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import com.stimulsoft.report.utils.data.StiDataColumnsUtil;
import com.stimulsoft.report.utils.data.StiSqlField;
import com.stimulsoft.report.utils.data.StiTableFieldsRequest;
import com.stimulsoft.report.utils.data.StiXmlTable;
import com.stimulsoft.report.utils.data.StiXmlTableFieldsRequest;
import com.stimulsoft.web.events.StiAbstractAction;
import com.stimulsoft.web.utils.StiConnectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;

public class StiReturnColumns
extends StiAbstractAction {
    public void process(InputStream is, OutputStream os, HttpServletRequest request) throws IOException, SQLException, ClassNotFoundException, StiException, InstantiationException, IllegalAccessException, JSONException {
        StiRetrieveColumns retrieveColumns = StiWebXmlMarshalUtil.unmarshalConnection(is, StiRetrieveColumns.class);
        StiConnectionType type = StiConnectionType.valueOf((String)retrieveColumns.getConnectionType());
        switch (type) {
            case StiXmlDatabase: {
                this.processXML(os, retrieveColumns);
                break;
            }
            case StiJsonDatabase: {
                this.processJson(os, retrieveColumns);
                break;
            }
            default: {
                this.processLoadData(os, retrieveColumns);
            }
        }
    }

    private void processXML(OutputStream os, StiRetrieveColumns retrieveColumns) throws StiException {
        InputStream schema = StiFlexConfig.getConfig().getXMLDataAction().loadSchema(retrieveColumns.getSchemaPath());
        StiXmlTableFieldsRequest result = StiDataColumnsUtil.parceXSDSchema((InputStream)schema, (boolean)false);
        StiXmlMarshalUtil.marshal((XmlObject)result, (OutputStream)os);
    }

    private void processJson(OutputStream os, StiRetrieveColumns retrieveColumns) throws StiException, JSONException, IOException {
        InputStream jsonStream = StiFlexConfig.getConfig().getJSONDataAction().load(retrieveColumns.getDataPath());
        DataSet dataSet = StiJsonToDataSetConverter.getDataTable((InputStream)jsonStream);
        StiXmlTableFieldsRequest result = new StiXmlTableFieldsRequest();
        for (DataTable table : dataSet.getTables()) {
            StiXmlTable xmlTable = new StiXmlTable(StiXMLConvert.encode((String)table.getName()));
            for (StiDataColumn column : table.getColumns()) {
                xmlTable.getColumns().add(new StiSqlField(StiXMLConvert.encode((String)column.getName()), column.getType().name().replace("System", "").toLowerCase()));
            }
            result.getTables().add(xmlTable);
        }
        StiXmlMarshalUtil.marshal((XmlObject)result, (OutputStream)os);
    }

    private void processLoadData(OutputStream os, StiRetrieveColumns retrieveColumns) throws StiException {
        Connection con = null;
        try {
            StiLoadDataAction loadAction = StiFlexConfig.getConfig().getLoadDataActionInstance();
            loadAction.setConnection(retrieveColumns);
            con = loadAction.getConnection();
            StiTableFieldsRequest tableFilds = StiDataColumnsUtil.getFields((Connection)con, (String)retrieveColumns.getCorrectQuery(), null);
            StiXmlMarshalUtil.marshal((XmlObject)tableFilds, (OutputStream)os);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }
}

