/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.events;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.system.type.StiSystemString;
import com.stimulsoft.base.system.type.StiSystemType;
import com.stimulsoft.base.utils.StiXmlMarshalUtil;
import com.stimulsoft.base.utils.XmlObject;
import com.stimulsoft.flex.StiFlexConfig;
import com.stimulsoft.flex.StiLoadDataAction;
import com.stimulsoft.flex.StiXMLDataAction;
import com.stimulsoft.flex.interactionObject.StiDatabase;
import com.stimulsoft.flex.interactionObject.StiRowData;
import com.stimulsoft.flex.interactionObject.StiTableDataRequest;
import com.stimulsoft.flex.utils.StiWebXmlMarshalUtil;
import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataCell;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.web.events.StiAbstractAction;
import com.stimulsoft.web.utils.StiConnectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;

public class StiReturnXmlOrSqlData
extends StiAbstractAction {
    public void process(InputStream is, OutputStream os, HttpServletRequest request) throws IOException, InstantiationException, IllegalAccessException, StiException, ClassNotFoundException, SQLException {
        StiDatabase dataBase = this.getDataBase(is);
        StiConnectionType type = StiConnectionType.valueOf((String)dataBase.getConnectionType());
        switch (type) {
            case StiXmlDatabase: {
                this.processXML(os, dataBase, request);
                break;
            }
            default: {
                this.processLoadData(os, dataBase, request);
            }
        }
    }

    private void processXML(OutputStream os, StiDatabase dataBase, HttpServletRequest request) throws InstantiationException, IllegalAccessException, IOException, StiException {
        StiXMLDataAction saveAction = StiFlexConfig.getConfig().getXMLDataAction();
        InputStream loadIS = saveAction.load(dataBase.getDataPath(), dataBase.getSchemaPath(), request);
        if (loadIS == null) {
            loadIS = saveAction.load(dataBase.getDataPath(), dataBase.getSchemaPath());
        }
        StiIOUtil.writeInputStream((OutputStream)os, (InputStream)loadIS);
    }

    public StiDatabase getDataBase(InputStream is) throws StiException {
        StiDatabase database = StiWebXmlMarshalUtil.unmarshalConnection(is, StiDatabase.class);
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLoadData(OutputStream os, StiDatabase dataBase, HttpServletRequest request) throws InstantiationException, IllegalAccessException, IOException, ClassNotFoundException, SQLException, StiException {
        StiLoadDataAction loadAction = StiFlexConfig.getConfig().getLoadDataActionInstance();
        loadAction.setConnection(dataBase);
        Statement st = null;
        Connection con = null;
        try {
            con = loadAction.getConnection(request);
            if (con == null) {
                con = loadAction.getConnection();
            }
            st = con.createStatement();
            ResultSet rs = st.executeQuery(loadAction.getQuery());
            StiTableDataRequest tableData = this.getData(dataBase, rs);
            StiXmlMarshalUtil.marshal((XmlObject)tableData, (OutputStream)os);
            os.flush();
        }
        catch (Throwable throwable) {
            StiCloseUtil.close(st, (Connection)con);
            throw throwable;
        }
        StiCloseUtil.close((Statement)st, (Connection)con);
    }

    private StiTableDataRequest getData(StiDatabase database, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        StiTableDataRequest tableData = new StiTableDataRequest(database.getDataSourceName());
        while (rs.next()) {
            StiRowData rowData = new StiRowData();
            for (int columnIndex = 1; columnIndex < columnCount + 1; ++columnIndex) {
                String columnLabel = rsmd.getColumnLabel(columnIndex);
                StiDataColumn dataColumn = new StiDataColumn(columnLabel, columnLabel, (StiSystemType)new StiSystemString());
                DataCell cell = DataRow.create((StiDataColumn)dataColumn, (int)columnIndex, (int)rsmd.getColumnType(columnIndex), (ResultSet)rs, (Boolean)true);
                if (cell.getValue() == null) continue;
                rowData.add(cell);
            }
            tableData.add(rowData);
        }
        return tableData;
    }
}

