/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.events;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.flex.StiFlexConfig;
import com.stimulsoft.flex.StiLoadDataAction;
import com.stimulsoft.flex.interactionObject.StiTestConnectionRequest;
import com.stimulsoft.flex.utils.StiWebXmlMarshalUtil;
import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.web.events.StiAbstractAction;
import com.stimulsoft.web.utils.StiConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class StiTestConnection
extends StiAbstractAction {
    private static final Logger LOG = Logger.getLogger(StiTestConnection.class.getName());
    private static final String SERVER_ERROR = "ServerError: Error '%s'";
    private static final String SERVER_WARNING = "ServerError: Warning '%s'";
    private static final String SQL_WARNING = "SQLState:'%s' Message:'%s' Vendor:'%s' \n";
    private String result = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(InputStream is, OutputStream os, HttpServletRequest request) throws IOException {
        Connection con = null;
        try {
            con = this.getConnection(is);
            this.valid(con);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "", e);
            this.result = String.format(SERVER_ERROR, e.toString());
        }
        finally {
            os.write(this.result.getBytes());
            StiCloseUtil.close((Connection)con);
        }
    }

    private Connection getConnection(InputStream is) throws IOException, ClassNotFoundException, SQLException, StiException, InstantiationException, IllegalAccessException {
        StiTestConnectionRequest testConnection = StiWebXmlMarshalUtil.unmarshalConnection(is, StiTestConnectionRequest.class);
        StiLoadDataAction loadAction = StiFlexConfig.getConfig().getLoadDataActionInstance();
        loadAction.setConnection(testConnection);
        return loadAction.getConnection();
    }

    private void valid(Connection con) throws SQLException {
        SQLWarning warn = con.getWarnings();
        this.result = warn != null ? String.format(SERVER_WARNING, StiTestConnection.getWarning(warn)) : StiConstants.SUCCESSFULL.value;
    }

    private static String getWarning(SQLWarning warn) throws SQLException {
        StringBuffer result = new StringBuffer();
        for (SQLWarning curentWarn = warn; curentWarn != null; curentWarn = curentWarn.getNextWarning()) {
            result.append(String.format(SQL_WARNING, warn.getSQLState(), warn.getMessage(), warn.getErrorCode()));
        }
        return result.toString();
    }
}

