/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.utils;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.localization.StiLocalizationInfo;
import com.stimulsoft.base.settings.StiConfig;
import com.stimulsoft.flex.StiFlexConfig;
import com.stimulsoft.lib.utils.StiXmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StiConvertPropertiesToXml {
    private Element rootElement;
    private final DocumentBuilderFactory documentBuilderFactory;
    private final DocumentBuilder documentBuilder;
    private final Document document;
    private final Properties properties = (Properties)StiConfig.getConfig().getProperties().clone();
    private final List<StiLocalizationInfo> localizationList;

    public StiConvertPropertiesToXml(Properties customProperties) throws ParserConfigurationException, IOException, StiException {
        if (customProperties != null) {
            this.properties.putAll((Map<?, ?>)customProperties);
        }
        this.localizationList = StiFlexConfig.getConfig().getLocalizationAction().getLocalizations();
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        this.document = this.documentBuilder.newDocument();
    }

    public void process(OutputStream out) throws IOException, TransformerException {
        this.rootElement = this.createRoot();
        this.document.appendChild(this.rootElement);
        this.setProperty();
        this.setLocalization();
        this.saveResult(out);
    }

    private void saveResult(OutputStream out) throws IOException, TransformerException {
        StiXmlUtil.xmlDocumentToOutputStream((Document)this.document, (OutputStream)out, (boolean)true);
    }

    private void setProperty() {
        ArrayList<String> props = new ArrayList<String>();
        for (Map.Entry<Object, Object> propElement : this.properties.entrySet()) {
            props.add((String)propElement.getKey());
        }
        Collections.sort(props);
        for (String key : props) {
            this.createChild(key, this.properties.getProperty(key));
        }
    }

    private void setLocalization() {
        Element branch = this.getBranch("Localizations.LocalizationsList.Value");
        for (StiLocalizationInfo localization : this.localizationList) {
            Element value = this.document.createElement("Value");
            branch.appendChild(value);
            this.addDataElement(value, "FileName", localization.getKey());
            this.addDataElement(value, "Language", localization.getLanguage());
            this.addDataElement(value, "Description", localization.getDescription());
            this.addDataElement(value, "CultureName", localization.getCultureName());
        }
    }

    private Element createRoot() {
        String rootName = "StiSerializer";
        Element result = this.document.createElement(rootName);
        result.setAttribute("type", "Flex");
        result.setAttribute("version", "1.0");
        result.setAttribute("application", "StiOptions");
        return result;
    }

    private void createChild(String propName, String propData) {
        String[] arrayBranches = this.splitPropertyName(propName);
        Element branch = this.getBranch(propName);
        this.addDataElement(branch, arrayBranches[arrayBranches.length - 1], propData);
    }

    private String[] splitPropertyName(String propName) {
        return propName.split("\\.");
    }

    private Element getBranch(String propName) {
        String[] split = this.splitPropertyName(propName);
        Element branch = this.rootElement;
        for (int i = 0; i < split.length - 1; ++i) {
            Element element = (Element)branch.getElementsByTagName(split[i]).item(0);
            if (element == null) {
                Element newElement = this.document.createElement(split[i]);
                branch.appendChild(newElement);
                element = newElement;
            }
            branch = element;
        }
        return branch;
    }

    private void addDataElement(Element branch, String name, String data) {
        Element newElement = this.document.createElement(name);
        newElement.appendChild(this.document.createTextNode(data));
        branch.appendChild(newElement);
    }
}

