/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.utils;

import com.stimulsoft.base.StiAttribute;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.settings.StiConfig;
import com.stimulsoft.flex.StiResourceFlex;
import com.stimulsoft.flex.utils.StiReplacer;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.web.servlet.StiHttpParam;
import com.stimulsoft.web.utils.StiConstants;
import com.stimulsoft.web.utils.StiURLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class StiHtmlWrapBuilder {
    private final String requestURI;
    private final String fxKey;
    private final String queryParams;

    public StiHtmlWrapBuilder(String requestURI, Map<String, String[]> map, String fxKey) {
        this.requestURI = requestURI;
        this.queryParams = this.createQueryParam(map);
        this.fxKey = fxKey;
    }

    public StiHtmlWrapBuilder(int port, String queryParams, String fxKey) {
        this.requestURI = "http://localhost:" + port + "/";
        this.queryParams = queryParams;
        this.fxKey = fxKey;
    }

    private String createQueryParam(Map<String, String[]> map) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            Object[] array = entry.getValue();
            if (!StiValidationUtil.isNotEmpty((Object[])array)) continue;
            result.append('&').append(entry.getKey()).append('=').append(StiURLUtil.encode((String)array[0]));
        }
        return result.length() < 1 ? "" : result.substring(1);
    }

    public String getHtmlText() throws StiException {
        HashMap<String, String> replacePatern = new HashMap<String, String>();
        replacePatern.put("#M_URL#", this.requestURI);
        replacePatern.put("#R_URL#", this.requestURI.replace(StiConstants.STIMULSOFT_DESIGNER.value, "").replace(StiConstants.STIMULSOFT_VIEWER.value, ""));
        replacePatern.put("#M_KEY#", StiConstants.STIMULSOFT_CLIENT_KEY.value);
        replacePatern.put("#M_FX_KEY_VALUE#", this.fxKey);
        replacePatern.put("#M_JS_KEY_VALUE#", StiHttpParam.JS.name());
        replacePatern.put("#M_PLAYER_KEY_VALUE#", StiHttpParam.Player.name());
        replacePatern.put("#M_REPORT_PARAMS#", this.queryParams);
        replacePatern.put("#M_VERSION#", StiAttribute.getVersionForFlex());
        String theme = StiConfig.getConfig().getProperty("Theme");
        if (StiValidationUtil.isNotNullOrEmpty((String)this.queryParams)) {
            String[] lines;
            for (String line : lines = StiURLUtil.decode((String)this.queryParams).split("\r\n")) {
                if (!line.startsWith("Theme=")) continue;
                theme = line.substring(6);
            }
        }
        replacePatern.put("#M_THEME#", theme);
        try {
            return new StiReplacer(new StiResourceFlex().getWrapper(), replacePatern).getResult();
        }
        catch (IOException e) {
            throw new StiException((Throwable)e);
        }
    }

    public InputStream getHtmlStream() throws StiException {
        try {
            return StiIOUtil.toInputStream((String)this.getHtmlText());
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
    }
}

