/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.utils;

import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.io.StiLineIterator;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class StiReplacer {
    private static final Logger LOG = Logger.getLogger(StiReplacer.class.getName());
    private static final String REPLACE_ERROR = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u044d\u043a\u0440\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432:  line ''{0}'' patern ''{1}'' value ''{2}''";
    private final Map<String, String> replacePatern;
    private final InputStream input;

    public StiReplacer(InputStream input, Map<String, String> replacePatern) throws IOException {
        this.input = input;
        this.replacePatern = replacePatern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResult() throws IOException {
        StringBuilder inputStr = new StringBuilder("");
        try {
            StiLineIterator it = StiIOUtil.lineIterator((InputStream)this.input);
            while (it.hasNext()) {
                this.appendln(inputStr, it.nextLine());
            }
        }
        finally {
            StiCloseUtil.close((Closeable)this.input);
        }
        return inputStr.toString();
    }

    private void appendln(StringBuilder inputStr, String line) {
        inputStr.append(this.replace(line) + "\n");
    }

    private String replace(String line) {
        String result = line;
        for (Map.Entry<String, String> patern : this.replacePatern.entrySet()) {
            try {
                String quoteReplacement = Matcher.quoteReplacement(patern.getValue());
                result = result.replaceAll(patern.getKey(), quoteReplacement);
            }
            catch (Exception e) {
                String msg = MessageFormat.format(REPLACE_ERROR, line, patern.getKey(), patern.getValue());
                LOG.log(Level.SEVERE, msg, e);
            }
        }
        return result;
    }
}

