/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.utils;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.utils.StiXmlMarshalUtil;
import com.stimulsoft.flex.interactionObject.StiSaveReportRequest;
import com.stimulsoft.flex.utils.StiOperationResult;
import com.stimulsoft.lib.base64.StiBase64DecoderUtil;
import com.stimulsoft.lib.io.StiFileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StiSaveLoadFileReport {
    private static final String MSG_SAVE = "Save report as '%s'";
    private static final String ERROR_SAVE = "Error save report '%s'";
    private static final String MSG_NOT_FOUND_REPOTR = "The report named ''{0}'' not found";
    private static final String MSG_REPOTR_FILE = "Load file report ''{0}''";
    private static final Logger LOG = Logger.getLogger(StiSaveLoadFileReport.class.getName());

    public StiOperationResult save(String report, String reportPath, boolean newReportFlag) {
        return this.save(report, reportPath);
    }

    public StiOperationResult save(String report, String reportPath) {
        try {
            File file = new File(reportPath);
            LOG.info(String.format(MSG_SAVE, file.getAbsolutePath()));
            StiFileUtil.writeStringToFile((File)file, (String)report);
        }
        catch (Exception e) {
            String msg = String.format(ERROR_SAVE, e.toString());
            LOG.log(Level.SEVERE, msg, e);
            return StiOperationResult.specifiedText(msg);
        }
        return StiOperationResult.notShownMessage();
    }

    public StiOperationResult save(InputStream is) throws IOException, StiException {
        StiSaveReportRequest saveReport = (StiSaveReportRequest)StiXmlMarshalUtil.unmarshal((InputStream)is, StiSaveReportRequest.class);
        String reportName = saveReport.getReportKey();
        boolean newReportFlag = saveReport.isNewReportFlag();
        String report = new String(StiBase64DecoderUtil.decode((String)saveReport.getReport()), "UTF-8");
        return this.save(report, reportName, newReportFlag);
    }

    public InputStream getReport(String repotrName) {
        File file = new File(repotrName);
        this.existsReport(file);
        LOG.log(Level.INFO, MessageFormat.format(MSG_REPOTR_FILE, file.getAbsolutePath()));
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void existsReport(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(MessageFormat.format(MSG_NOT_FOUND_REPOTR, file.getAbsolutePath()));
        }
    }
}

