/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.flex.utils;

import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.flex.interactionObject.StiConnectionXml;
import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiStringUtil;
import java.io.Closeable;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class StiWebXmlMarshalUtil {
    private StiWebXmlMarshalUtil() {
    }

    public static <T extends StiConnectionXml> T unmarshalConnection(InputStream is, Class<T> clazz) throws StiException {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller u = jc.createUnmarshaller();
            String xmlStr = StiIOUtil.toString((InputStream)is);
            String connectionString = StiWebXmlMarshalUtil.correctConnectionString(xmlStr);
            StiConnectionXml result = (StiConnectionXml)((Object)u.unmarshal(StiIOUtil.toInputStream((String)StiWebXmlMarshalUtil.deleteConnectionString(xmlStr))));
            result.setConnectionString(connectionString);
            StiConnectionXml stiConnectionXml = result;
            return (T)((Object)stiConnectionXml);
        }
        catch (Exception e) {
            throw new StiException((Throwable)e);
        }
        finally {
            StiCloseUtil.close((Closeable)is);
        }
    }

    private static String correctConnectionString(String xmlStr) {
        String open = "<ConnectionString>";
        String close = "</ConnectionString>";
        return StiStringUtil.substringBetween((String)xmlStr, (String)open, (String)close);
    }

    private static String deleteConnectionString(String xmlStr) {
        String open = "<ConnectionString>";
        String close = "</ConnectionString>";
        return StiStringUtil.removalBetween((String)xmlStr, (String)open, (String)close);
    }
}

