/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client;

import com.taobao.metamorphosis.utils.ZkUtils;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MetaClientConfig
implements Serializable {
    static final long serialVersionUID = -1L;
    protected String serverUrl;
    private final String diamondPartitionsDataId = "metamorphosis.partitions";
    private final String diamondPartitionsGroup = "DEFAULT_GROUP";
    protected ZkUtils.ZKConfig zkConfig;
    private long recoverMessageIntervalInMills = 300000L;
    private int recoverThreadCount = Runtime.getRuntime().availableProcessors();
    Properties partitionsInfo;

    public int getRecoverThreadCount() {
        return this.recoverThreadCount;
    }

    public void setRecoverThreadCount(int recoverThreadCount) {
        this.recoverThreadCount = recoverThreadCount;
    }

    public long getRecoverMessageIntervalInMills() {
        return this.recoverMessageIntervalInMills;
    }

    public void setRecoverMessageIntervalInMills(long recoverMessageIntervalInMills) {
        this.recoverMessageIntervalInMills = recoverMessageIntervalInMills;
    }

    public ZkUtils.ZKConfig getZkConfig() {
        return this.zkConfig;
    }

    public void setZkConfig(ZkUtils.ZKConfig zkConfig) {
        if (zkConfig == null) {
            throw new IllegalArgumentException("Null zkconfig");
        }
        if (StringUtils.isEmpty((String)zkConfig.zkConnect)) {
            throw new IllegalArgumentException("Empty zookeeper servers");
        }
        this.zkConfig = zkConfig;
    }

    public String getZkRoot() {
        return this.zkConfig.getZkRoot();
    }

    public void setZkRoot(String zkRoot) {
        this.zkConfig.setZkRoot(zkRoot);
    }

    public boolean isZkEnable() {
        return this.zkConfig.isZkEnable();
    }

    public void setZkEnable(boolean zkEnable) {
        this.zkConfig.setZkEnable(zkEnable);
    }

    public String getZkConnect() {
        return this.zkConfig.getZkConnect();
    }

    public void setZkConnect(String zkConnect) {
        this.zkConfig.setZkConnect(zkConnect);
    }

    public int getZkSessionTimeoutMs() {
        return this.zkConfig.getZkSessionTimeoutMs();
    }

    public void setZkSessionTimeoutMs(int zkSessionTimeoutMs) {
        this.zkConfig.setZkSessionTimeoutMs(zkSessionTimeoutMs);
    }

    public int getZkConnectionTimeoutMs() {
        return this.zkConfig.getZkConnectionTimeoutMs();
    }

    public void setZkConnectionTimeoutMs(int zkConnectionTimeoutMs) {
        this.zkConfig.setZkConnectionTimeoutMs(zkConnectionTimeoutMs);
    }

    public int getZkSyncTimeMs() {
        return this.zkConfig.getZkSyncTimeMs();
    }

    public void setZkSyncTimeMs(int zkSyncTimeMs) {
        this.zkConfig.setZkSyncTimeMs(zkSyncTimeMs);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getDiamondPartitionsDataId() {
        return this.diamondPartitionsDataId;
    }

    public String getDiamondPartitionsGroup() {
        return this.diamondPartitionsGroup;
    }

    public void setPartitionsInfo(Properties partitionsInfo) {
        this.partitionsInfo = partitionsInfo;
    }

    public Properties getPartitionsInfo() {
        return this.partitionsInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.diamondPartitionsDataId == null ? 0 : this.diamondPartitionsDataId.hashCode());
        result = 31 * result + (this.diamondPartitionsGroup == null ? 0 : this.diamondPartitionsGroup.hashCode());
        result = 31 * result + (this.partitionsInfo == null ? 0 : this.partitionsInfo.hashCode());
        result = 31 * result + (int)(this.recoverMessageIntervalInMills ^ this.recoverMessageIntervalInMills >>> 32);
        result = 31 * result + this.recoverThreadCount;
        result = 31 * result + (this.serverUrl == null ? 0 : this.serverUrl.hashCode());
        result = 31 * result + (this.zkConfig == null ? 0 : this.zkConfig.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaClientConfig other = (MetaClientConfig)obj;
        if (this.diamondPartitionsDataId == null ? other.diamondPartitionsDataId != null : !this.diamondPartitionsDataId.equals(other.diamondPartitionsDataId)) {
            return false;
        }
        if (this.diamondPartitionsGroup == null ? other.diamondPartitionsGroup != null : !this.diamondPartitionsGroup.equals(other.diamondPartitionsGroup)) {
            return false;
        }
        if (this.partitionsInfo == null ? other.partitionsInfo != null : !this.partitionsInfo.equals(other.partitionsInfo)) {
            return false;
        }
        if (this.recoverMessageIntervalInMills != other.recoverMessageIntervalInMills) {
            return false;
        }
        if (this.recoverThreadCount != other.recoverThreadCount) {
            return false;
        }
        if (this.serverUrl == null ? other.serverUrl != null : !this.serverUrl.equals(other.serverUrl)) {
            return false;
        }
        return !(this.zkConfig == null ? other.zkConfig != null : !this.zkConfig.equals((Object)other.zkConfig));
    }
}

