/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client;

import com.taobao.gecko.core.buffer.IoBuffer;
import com.taobao.gecko.core.command.RequestCommand;
import com.taobao.gecko.core.command.ResponseCommand;
import com.taobao.gecko.core.command.ResponseStatus;
import com.taobao.gecko.core.nio.impl.TimerRef;
import com.taobao.gecko.service.Connection;
import com.taobao.gecko.service.ConnectionLifeCycleListener;
import com.taobao.gecko.service.ConnectionSelector;
import com.taobao.gecko.service.GroupAllConnectionCallBackListener;
import com.taobao.gecko.service.MultiGroupCallBackListener;
import com.taobao.gecko.service.RemotingClient;
import com.taobao.gecko.service.RemotingContext;
import com.taobao.gecko.service.RequestProcessor;
import com.taobao.gecko.service.SingleRequestCallBackListener;
import com.taobao.gecko.service.config.ClientConfig;
import com.taobao.gecko.service.exception.NotifyRemotingException;
import com.taobao.metamorphosis.network.BooleanCommand;
import com.taobao.metamorphosis.network.RemotingUtils;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RemotingClientWrapper
implements RemotingClient {
    private final RemotingClient remotingClient;
    private final ConcurrentHashMap<String, Set<Object>> refsCache = new ConcurrentHashMap();
    private static final boolean ENABLE_LOOPBACK_CONNECTION = Boolean.valueOf(System.getProperty("metaq.client.loopback.connection.enable", "false"));

    public RemotingClientWrapper(RemotingClient remotingClient) {
        this.remotingClient = remotingClient;
    }

    public void connect(String url, String targetGroup, int connCount) throws NotifyRemotingException {
        this.remotingClient.connect(url, targetGroup, connCount);
    }

    public void connect(String url, String targetGroup) throws NotifyRemotingException {
        this.remotingClient.connect(url, targetGroup);
    }

    public void addAllProcessors(Map<Class<? extends RequestCommand>, RequestProcessor<? extends RequestCommand>> map) {
        this.remotingClient.addAllProcessors(map);
    }

    public void addConnectionLifeCycleListener(ConnectionLifeCycleListener connectionLifeCycleListener) {
        this.remotingClient.addConnectionLifeCycleListener(connectionLifeCycleListener);
    }

    public void awaitReadyInterrupt(String url, long time) throws NotifyRemotingException, InterruptedException {
        this.remotingClient.awaitReadyInterrupt(url, time);
    }

    public void awaitReadyInterrupt(String url) throws NotifyRemotingException, InterruptedException {
        this.remotingClient.awaitReadyInterrupt(url);
    }

    public void connect(String url) throws NotifyRemotingException {
        this.connect(url, 1);
    }

    public void connect(String url, int connCount) throws NotifyRemotingException {
        this.connectWithRef(url, connCount, null);
    }

    public void close(String url, boolean allowReconnect) throws NotifyRemotingException {
        this.closeWithRef(url, null, allowReconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithRef(String url, Object ref, boolean allowReconnect) throws NotifyRemotingException {
        Set<Object> refs = this.refsCache.get(url);
        if (refs != null) {
            Set<Object> set = refs;
            synchronized (set) {
                refs.remove(ref);
                if (refs.isEmpty() || this.isOnlyMe(refs)) {
                    this.remotingClient.close(url, allowReconnect);
                }
            }
        }
    }

    private boolean isOnlyMe(Set<Object> refs) {
        return refs.size() == 1 && refs.contains(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectWithRef(String url, int connCount, Object ref) throws NotifyRemotingException {
        Set<Object> refs;
        if (ENABLE_LOOPBACK_CONNECTION) {
            url = RemotingClientWrapper.tryGetLoopbackURL(url);
        }
        Set<Object> set = refs = this.getReferences(url);
        synchronized (set) {
            this.remotingClient.connect(url, connCount);
            refs.add(ref);
        }
    }

    static String tryGetLoopbackURL(String url) {
        try {
            URI uri = new URI(url);
            String localHostName = RemotingUtils.getLocalHost();
            if (uri.getHost().equals(localHostName)) {
                url = uri.getScheme() + "://localhost:" + uri.getPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    private Set<Object> getReferences(String url) {
        Set<Object> oldRefs;
        Set<Object> refs = this.refsCache.get(url);
        if (refs == null && (oldRefs = this.refsCache.putIfAbsent(url, refs = new HashSet<Object>())) != null) {
            refs = oldRefs;
        }
        return refs;
    }

    public void connectWithRef(String url, Object ref) throws NotifyRemotingException {
        this.connectWithRef(url, 1, ref);
    }

    public Object getAttribute(String group, String key) {
        return this.remotingClient.getAttribute(group, key);
    }

    public int getConnectionCount(String group) {
        return this.remotingClient.getConnectionCount(group);
    }

    public Set<String> getGroupSet() {
        return this.remotingClient.getGroupSet();
    }

    public RequestProcessor<? extends RequestCommand> getProcessor(Class<? extends RequestCommand> clazz) {
        return this.remotingClient.getProcessor(clazz);
    }

    public InetSocketAddress getRemoteAddress(String url) {
        return this.remotingClient.getRemoteAddress(url);
    }

    public String getRemoteAddressString(String url) {
        return this.remotingClient.getRemoteAddressString(url);
    }

    public RemotingContext getRemotingContext() {
        return this.remotingClient.getRemotingContext();
    }

    public void insertTimer(TimerRef timerRef) {
        this.remotingClient.insertTimer(timerRef);
    }

    public ResponseCommand invokeToGroup(String group, RequestCommand command, long time, TimeUnit timeUnit) throws InterruptedException, TimeoutException, NotifyRemotingException {
        BooleanCommand booleanCommand;
        ResponseCommand resp = this.remotingClient.invokeToGroup(group, command, time, timeUnit);
        if (resp.getResponseStatus() == ResponseStatus.ERROR_COMM && (booleanCommand = (BooleanCommand)resp).getErrorMsg().contains("\u65e0\u53ef\u7528\u8fde\u63a5")) {
            this.connectWithRef(group, this);
        }
        return resp;
    }

    public ResponseCommand invokeToGroup(String group, RequestCommand command) throws InterruptedException, TimeoutException, NotifyRemotingException {
        return this.remotingClient.invokeToGroup(group, command);
    }

    public Map<Connection, ResponseCommand> invokeToGroupAllConnections(String group, RequestCommand command, long time, TimeUnit timeUnit) throws InterruptedException, NotifyRemotingException {
        return this.remotingClient.invokeToGroupAllConnections(group, command, time, timeUnit);
    }

    public Map<Connection, ResponseCommand> invokeToGroupAllConnections(String group, RequestCommand command) throws InterruptedException, NotifyRemotingException {
        return this.remotingClient.invokeToGroupAllConnections(group, command);
    }

    public boolean isConnected(String url) {
        return this.remotingClient.isConnected(url);
    }

    public boolean isStarted() {
        return this.remotingClient.isStarted();
    }

    public <T extends RequestCommand> void registerProcessor(Class<T> commandClazz, RequestProcessor<T> processor) {
        this.remotingClient.registerProcessor(commandClazz, processor);
    }

    public Object removeAttribute(String group, String key) {
        return this.remotingClient.removeAttribute(group, key);
    }

    public void removeConnectionLifeCycleListener(ConnectionLifeCycleListener connectionLifeCycleListener) {
        this.remotingClient.removeConnectionLifeCycleListener(connectionLifeCycleListener);
    }

    public Connection selectConnectionForGroup(String group, ConnectionSelector connectionSelector, RequestCommand request) throws NotifyRemotingException {
        return this.remotingClient.selectConnectionForGroup(group, connectionSelector, request);
    }

    public void sendToAllConnections(RequestCommand command) throws NotifyRemotingException {
        this.remotingClient.sendToAllConnections(command);
    }

    public void sendToGroup(String group, RequestCommand command, SingleRequestCallBackListener listener, long time, TimeUnit timeunut) throws NotifyRemotingException {
        this.remotingClient.sendToGroup(group, command, listener, time, timeunut);
    }

    public void sendToGroup(String group, RequestCommand command, SingleRequestCallBackListener listener) throws NotifyRemotingException {
        this.remotingClient.sendToGroup(group, command, listener);
    }

    public void sendToGroup(String group, RequestCommand command) throws NotifyRemotingException {
        this.remotingClient.sendToGroup(group, command);
    }

    public void sendToGroupAllConnections(String group, RequestCommand command, GroupAllConnectionCallBackListener listener, long time, TimeUnit timeUnit) throws NotifyRemotingException {
        this.remotingClient.sendToGroupAllConnections(group, command, listener, time, timeUnit);
    }

    public void sendToGroupAllConnections(String group, RequestCommand command, GroupAllConnectionCallBackListener listener) throws NotifyRemotingException {
        this.remotingClient.sendToGroupAllConnections(group, command, listener);
    }

    public void sendToGroupAllConnections(String group, RequestCommand command) throws NotifyRemotingException {
        this.remotingClient.sendToGroupAllConnections(group, command);
    }

    public void sendToGroups(Map<String, RequestCommand> groupObjects, MultiGroupCallBackListener listener, long timeout, TimeUnit timeUnit, Object ... args) throws NotifyRemotingException {
        this.remotingClient.sendToGroups(groupObjects, listener, timeout, timeUnit, args);
    }

    public void sendToGroups(Map<String, RequestCommand> groupObjects) throws NotifyRemotingException {
        this.remotingClient.sendToGroups(groupObjects);
    }

    public void setAttribute(String group, String key, Object value) {
        this.remotingClient.setAttribute(group, key, value);
    }

    public Object setAttributeIfAbsent(String group, String key, Object value) {
        return this.remotingClient.setAttributeIfAbsent(group, key, value);
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.remotingClient.setClientConfig(clientConfig);
    }

    public void setConnectionSelector(ConnectionSelector selector) {
        this.remotingClient.setConnectionSelector(selector);
    }

    public void start() throws NotifyRemotingException {
        this.remotingClient.start();
    }

    public void stop() throws NotifyRemotingException {
        this.remotingClient.stop();
        this.refsCache.clear();
    }

    public RequestProcessor<? extends RequestCommand> unreigsterProcessor(Class<? extends RequestCommand> clazz) {
        return this.remotingClient.unreigsterProcessor(clazz);
    }

    public void transferToGroup(String group, IoBuffer head, IoBuffer tail, FileChannel channel, long position, long size, Integer opaque, SingleRequestCallBackListener listener, long time, TimeUnit unit) throws NotifyRemotingException {
        this.remotingClient.transferToGroup(group, head, tail, channel, position, size, opaque, listener, time, unit);
    }

    public void transferToGroup(String group, IoBuffer head, IoBuffer tail, FileChannel channel, long position, long size) throws NotifyRemotingException {
        this.remotingClient.transferToGroup(group, head, tail, channel, position, size);
    }
}

