/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer;

import com.taobao.metamorphosis.client.consumer.HashAlgorithm;
import com.taobao.metamorphosis.client.consumer.LoadBalanceStrategy;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class ConsisHashStrategy
implements LoadBalanceStrategy {
    static final int NUM_REPS = 160;
    HashAlgorithm alg = HashAlgorithm.KETAMA_HASH;

    public static byte[] computeMd5(String k) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 not supported", e);
        }
        md5.reset();
        md5.update(k.getBytes());
        return md5.digest();
    }

    @Override
    public List<String> getPartitions(String topic, String consumerId, List<String> curConsumers, List<String> curPartitions) {
        TreeMap<Long, String> consumerMap = this.buildConsumerMap(curConsumers);
        HashSet<String> rt = new HashSet<String>();
        for (String partition : curPartitions) {
            String targetConsumer = this.findConsumerByPartition(consumerMap, partition);
            if (!consumerId.equals(targetConsumer)) continue;
            rt.add(partition);
        }
        return new ArrayList<String>(rt);
    }

    private String findConsumerByPartition(TreeMap<Long, String> consumerMap, String partition) {
        Long hash;
        Long target = hash = Long.valueOf(this.alg.hash(partition));
        if (!consumerMap.containsKey(hash) && (target = consumerMap.ceilingKey(hash)) == null && !consumerMap.isEmpty()) {
            target = consumerMap.firstKey();
        }
        String targetConsumer = consumerMap.get(target);
        return targetConsumer;
    }

    private TreeMap<Long, String> buildConsumerMap(List<String> curConsumers) {
        TreeMap<Long, String> consumerMap = new TreeMap<Long, String>();
        for (String consumer : curConsumers) {
            int i;
            if (this.alg == HashAlgorithm.KETAMA_HASH) {
                for (i = 0; i < 40; ++i) {
                    byte[] digest = HashAlgorithm.computeMd5(consumer + "-" + i);
                    for (int h = 0; h < 4; ++h) {
                        long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                        consumerMap.put(k, consumer);
                    }
                }
                continue;
            }
            for (i = 0; i < 160; ++i) {
                long key = this.alg.hash(consumer + "-" + i);
                consumerMap.put(key, consumer);
            }
        }
        return consumerMap;
    }
}

