/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer;

import com.taobao.metamorphosis.client.consumer.FetchRequestQueue;
import com.taobao.metamorphosis.client.consumer.TopicPartitionRegInfo;
import com.taobao.metamorphosis.cluster.Broker;
import com.taobao.metamorphosis.cluster.Partition;
import com.taobao.metamorphosis.utils.MessageUtils;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchRequest
implements Delayed {
    private long delayTimeStamp;
    private long delay;
    private TopicPartitionRegInfo topicPartitionRegInfo;
    private int maxSize;
    private int originalMaxSize;
    private Broker broker;
    private int retries = 0;
    private long tmpOffset;
    private FetchRequestQueue refQueue;
    static final Log log = LogFactory.getLog(FetchRequest.class);

    public TopicPartitionRegInfo getTopicPartitionRegInfo() {
        return this.topicPartitionRegInfo;
    }

    public FetchRequestQueue getRefQueue() {
        return this.refQueue;
    }

    public void setRefQueue(FetchRequestQueue refQueue) {
        this.refQueue = refQueue;
    }

    FetchRequest(long delay) {
        this.delay = delay;
        this.delayTimeStamp = System.currentTimeMillis() + delay;
    }

    public int getRetries() {
        return this.retries;
    }

    public void increaseMaxSize() {
        if (this.maxSize > MessageUtils.MAX_READ_BUFFER_SIZE) {
            log.warn((Object)("\u8b66\u544a\uff1amaxSize\u8d85\u8fc7\u6700\u5927\u9650\u5236" + MessageUtils.MAX_READ_BUFFER_SIZE + "Bytes\uff0c\u8bf7\u8bbe\u7f6e\u73af\u5883\u53d8\u91cf-Dnotify.remoting.max_read_buffer_size\u8d85\u8fc7\u6b64\u9650\u5236"));
            return;
        }
        this.maxSize = 2 * this.maxSize;
    }

    public void decreaseMaxSize() {
        if (this.maxSize < this.originalMaxSize) {
            this.maxSize = this.originalMaxSize;
        } else {
            if (this.maxSize == this.originalMaxSize) {
                return;
            }
            this.maxSize /= 2;
        }
    }

    public void resetRetries() {
        this.retries = 0;
    }

    public int incrementRetriesAndGet() {
        return ++this.retries;
    }

    public FetchRequest(Broker broker, long delay, TopicPartitionRegInfo topicPartitionRegInfo, int maxSize) {
        this.broker = broker;
        this.delay = delay;
        if (delay >= 0L) {
            this.delayTimeStamp = System.currentTimeMillis() + delay;
        }
        this.topicPartitionRegInfo = topicPartitionRegInfo;
        this.maxSize = maxSize;
        this.originalMaxSize = maxSize;
        if (this.maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <=0");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.broker == null ? 0 : this.broker.hashCode());
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        result = 31 * result + this.maxSize;
        result = 31 * result + this.retries;
        result = 31 * result + (this.topicPartitionRegInfo == null ? 0 : this.topicPartitionRegInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchRequest other = (FetchRequest)obj;
        if (this.broker == null ? other.broker != null : !this.broker.equals((Object)other.broker)) {
            return false;
        }
        if (this.delay != other.delay) {
            return false;
        }
        if (this.maxSize != other.maxSize) {
            return false;
        }
        if (this.retries != other.retries) {
            return false;
        }
        return !(this.topicPartitionRegInfo == null ? other.topicPartitionRegInfo != null : !this.topicPartitionRegInfo.equals(other.topicPartitionRegInfo));
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
    }

    public void setDelay(long delay) {
        this.delay = delay;
        this.delayTimeStamp = System.currentTimeMillis() + delay;
    }

    @Override
    public int compareTo(Delayed o) {
        if (o == this) {
            return 0;
        }
        FetchRequest other = (FetchRequest)o;
        long sub = this.delayTimeStamp - other.delayTimeStamp;
        if (sub == 0L) {
            return 0;
        }
        return sub < 0L ? -1 : 1;
    }

    public long getDelay() {
        return this.delay;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delayTimeStamp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOffset(long offset, long msgId, boolean ack) {
        if (ack) {
            TopicPartitionRegInfo topicPartitionRegInfo = this.topicPartitionRegInfo;
            synchronized (topicPartitionRegInfo) {
                this.topicPartitionRegInfo.getOffset().set(offset);
                if (msgId != -1L) {
                    this.topicPartitionRegInfo.setMessageId(msgId);
                }
                this.topicPartitionRegInfo.setModified(true);
            }
            this.rollbackOffset();
        } else {
            this.tmpOffset = offset;
        }
    }

    public String getTopic() {
        return this.topicPartitionRegInfo.getTopic();
    }

    public int getPartition() {
        return this.topicPartitionRegInfo.getPartition().getPartition();
    }

    public Partition getPartitionObject() {
        return this.topicPartitionRegInfo.getPartition();
    }

    public void rollbackOffset() {
        this.tmpOffset = -1L;
    }

    public long getLastMessageId() {
        return this.topicPartitionRegInfo.getMessageId();
    }

    public long getOffset() {
        if (this.tmpOffset > 0L) {
            return this.tmpOffset;
        }
        return this.topicPartitionRegInfo.getOffset().get();
    }
}

