/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer;

import com.taobao.metamorphosis.cluster.Partition;
import com.taobao.metamorphosis.consumer.MessageIterator;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class TopicPartitionRegInfo
implements Serializable {
    static final long serialVersionUID = -1L;
    private String topic;
    private Partition partition;
    private final AtomicLong offset;
    private long messageId = -1L;
    private boolean modified;

    public TopicPartitionRegInfo clone(MessageIterator it) {
        return new TopicPartitionRegInfo(this.topic, this.partition, this.offset.get() + (long)it.getOffset(), this.messageId);
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public synchronized void setModified(boolean modified) {
        this.modified = modified;
    }

    public synchronized long getMessageId() {
        return this.messageId;
    }

    public synchronized void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.messageId ^ this.messageId >>> 32);
        long currOffset = this.offset.get();
        result = 31 * result + (int)(currOffset ^ currOffset >>> 32);
        result = 31 * result + (this.partition == null ? 0 : this.partition.hashCode());
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicPartitionRegInfo other = (TopicPartitionRegInfo)obj;
        if (this.messageId != other.messageId) {
            return false;
        }
        if (this.offset == null ? other.offset != null : this.offset.get() != other.offset.get()) {
            return false;
        }
        if (this.partition == null ? other.partition != null : !this.partition.equals((Object)other.partition)) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    public TopicPartitionRegInfo(String topic, Partition partition, long offset) {
        this.topic = topic;
        this.partition = partition;
        this.offset = new AtomicLong(offset);
    }

    public TopicPartitionRegInfo(String topic, Partition partition, long offset, long messageId) {
        this.topic = topic;
        this.partition = partition;
        this.offset = new AtomicLong(offset);
        this.messageId = messageId;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public void setPartition(Partition partition) {
        this.partition = partition;
    }

    public synchronized AtomicLong getOffset() {
        return this.offset;
    }
}

