/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.consumer.storage;

import com.taobao.metamorphosis.client.consumer.TopicPartitionRegInfo;
import com.taobao.metamorphosis.client.consumer.storage.OffsetStorage;
import com.taobao.metamorphosis.cluster.Partition;
import com.taobao.metamorphosis.utils.JSONUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalOffsetStorage
implements OffsetStorage {
    static final Log log = LogFactory.getLog(LocalOffsetStorage.class);
    private final Map<String, List<TopicPartitionRegInfo>> groupInfoMap = new HashMap<String, List<TopicPartitionRegInfo>>();
    private final AtomicLong counter = new AtomicLong();
    private final String filePath;

    public LocalOffsetStorage() throws IOException {
        this(System.getProperty("user.home") + File.separator + ".meta_offsets");
    }

    public LocalOffsetStorage(String filePath) throws IOException {
        this.filePath = filePath;
        File file = new File(filePath);
        if (file.exists()) {
            this.loadGroupInfo(file);
        } else {
            file.createNewFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroupInfo(File file) {
        String line = null;
        BufferedReader reader = null;
        FileReader fileReader = null;
        StringBuilder jsonSB = new StringBuilder();
        try {
            fileReader = new FileReader(file);
            reader = new BufferedReader(fileReader);
            while ((line = reader.readLine()) != null) {
                jsonSB.append(line);
            }
            this.close(reader);
            this.close(fileReader);
        }
        catch (IOException e) {
            try {
                log.error((Object)("\u8bfb\u53d6\u6587\u4ef6" + file + "\u51fa\u9519"), (Throwable)e);
                this.close(reader);
                this.close(fileReader);
            }
            catch (Throwable throwable) {
                this.close(reader);
                this.close(fileReader);
                throw throwable;
            }
        }
        try {
            if (jsonSB.length() <= 0) {
                log.warn((Object)(file.getAbsolutePath() + "\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u6682\u65f6\u672a\u52a0\u8f7d\u5230offset\u4fe1\u606f,\u5982\u679c\u662f\u7b2c\u4e00\u6b21\u53d1\u5e03\u8fd9\u662f\u6b63\u5e38\u73b0\u8c61"));
                return;
            }
            Map groupInfoStringMap = (Map)JSONUtils.deserializeObject((String)jsonSB.toString(), ConcurrentHashMap.class);
            for (Map.Entry entry1 : groupInfoStringMap.entrySet()) {
                String group = (String)entry1.getKey();
                List infos = (List)entry1.getValue();
                ArrayList<TopicPartitionRegInfo> infoList = new ArrayList<TopicPartitionRegInfo>();
                if (infos != null) {
                    for (Map infoMap : infos) {
                        String topic = (String)infoMap.get("topic");
                        long offset = Long.valueOf(String.valueOf(infoMap.get("offset")));
                        Map partMap = (Map)infoMap.get("partition");
                        infoList.add(new TopicPartitionRegInfo(topic, new Partition(((Integer)partMap.get("brokerId")).intValue(), ((Integer)partMap.get("partition")).intValue()), offset));
                    }
                }
                this.groupInfoMap.put(group, infoList);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u53cd\u5e8f\u5217\u5316json\u5931\u8d25", (Throwable)e);
        }
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitOffset(String group, Collection<TopicPartitionRegInfo> infoList) {
        block13: {
            if (infoList == null || infoList.isEmpty()) {
                return;
            }
            this.groupInfoMap.put(group, (List)infoList);
            FileOutputStream out = null;
            AbstractInterruptibleChannel channel = null;
            try {
                String json = JSONUtils.serializeObject(this.groupInfoMap);
                File tmpFile = new File(this.filePath + ".tmp." + this.counter.incrementAndGet());
                out = new FileOutputStream(tmpFile);
                channel = out.getChannel();
                ByteBuffer buf = ByteBuffer.wrap(json.getBytes());
                while (buf.hasRemaining()) {
                    ((FileChannel)channel).write(buf);
                }
                this.close(channel);
                this.close(out);
                LocalOffsetStorage localOffsetStorage = this;
                synchronized (localOffsetStorage) {
                    if (!tmpFile.renameTo(new File(this.filePath))) {
                        throw new IOException("Could not rename temp file to " + this.filePath);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"commitOffset failed ", (Throwable)e);
                break block13;
            }
            finally {
                if (channel != null && channel.isOpen()) {
                    this.close(channel);
                }
                this.close(out);
            }
            if (channel != null && channel.isOpen()) {
                this.close(channel);
            }
            this.close(out);
        }
    }

    @Override
    public void initOffset(String topic, String group, Partition partition, long offset) {
    }

    @Override
    public TopicPartitionRegInfo load(String topic, String group, Partition partition) {
        Collection topicPartitionRegInfos = this.groupInfoMap.get(group);
        if (topicPartitionRegInfos == null || topicPartitionRegInfos.isEmpty()) {
            return null;
        }
        for (TopicPartitionRegInfo info : topicPartitionRegInfos) {
            if (!info.getTopic().equals(topic) || !info.getPartition().equals((Object)partition)) continue;
            return info;
        }
        return null;
    }
}

