/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension;

import com.taobao.metamorphosis.client.MetaClientConfig;
import com.taobao.metamorphosis.client.MetaMessageSessionFactory;
import com.taobao.metamorphosis.client.consumer.ConsumerConfig;
import com.taobao.metamorphosis.client.consumer.MessageConsumer;
import com.taobao.metamorphosis.client.consumer.RecoverManager;
import com.taobao.metamorphosis.client.consumer.storage.LocalOffsetStorage;
import com.taobao.metamorphosis.client.extension.BroadcastMessageSessionFactory;
import com.taobao.metamorphosis.exception.InvalidConsumerConfigException;
import com.taobao.metamorphosis.exception.MetaClientException;
import com.taobao.metamorphosis.network.RemotingUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class MetaBroadcastMessageSessionFactory
extends MetaMessageSessionFactory
implements BroadcastMessageSessionFactory {
    public MetaBroadcastMessageSessionFactory(MetaClientConfig metaClientConfig) throws MetaClientException {
        super(metaClientConfig);
    }

    @Override
    public MessageConsumer createBroadcastConsumer(ConsumerConfig consumerConfig) {
        return this.createBroadcastConsumer(consumerConfig, null);
    }

    protected MessageConsumer createBroadcastConsumer(ConsumerConfig consumerConfig, RecoverManager recoverManager) {
        if (StringUtils.isBlank((String)consumerConfig.getGroup())) {
            throw new InvalidConsumerConfigException("Blank group");
        }
        return this.createConsumer(MetaBroadcastMessageSessionFactory.updateGroupForBroadcast(consumerConfig), this.newLocalOffsetStorage(), recoverManager);
    }

    private LocalOffsetStorage newLocalOffsetStorage() {
        try {
            return new LocalOffsetStorage();
        }
        catch (IOException e) {
            throw new InvalidConsumerConfigException("\u521b\u5efaConsumer\u5931\u8d25,Create LocalOffsetStorage failed", (Throwable)e);
        }
    }

    static ConsumerConfig updateGroupForBroadcast(ConsumerConfig consumerConfig) {
        try {
            consumerConfig.setGroup(consumerConfig.getGroup() + "-" + RemotingUtils.getLocalHost().replaceAll("[\\.\\:]", "-"));
            return consumerConfig;
        }
        catch (Exception e) {
            throw new InvalidConsumerConfigException("\u83b7\u53d6\u672c\u5730ip\u5931\u8d25", (Throwable)e);
        }
    }
}

