/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension;

import com.taobao.metamorphosis.client.MetaClientConfig;
import com.taobao.metamorphosis.client.MetaMessageSessionFactory;
import com.taobao.metamorphosis.client.consumer.ConsumerConfig;
import com.taobao.metamorphosis.client.consumer.MessageConsumer;
import com.taobao.metamorphosis.client.consumer.storage.OffsetStorage;
import com.taobao.metamorphosis.client.extension.OrderedMessageSessionFactory;
import com.taobao.metamorphosis.client.extension.producer.ConfigPartitionsAware;
import com.taobao.metamorphosis.client.extension.producer.MessageRecoverManager;
import com.taobao.metamorphosis.client.extension.producer.OrderedLocalMessageStorageManager;
import com.taobao.metamorphosis.client.extension.producer.OrderedMessageProducer;
import com.taobao.metamorphosis.client.extension.producer.ProducerDiamondManager;
import com.taobao.metamorphosis.client.producer.MessageProducer;
import com.taobao.metamorphosis.client.producer.PartitionSelector;
import com.taobao.metamorphosis.client.producer.RoundRobinPartitionSelector;
import com.taobao.metamorphosis.exception.MetaClientException;

public class OrderedMetaMessageSessionFactory
extends MetaMessageSessionFactory
implements OrderedMessageSessionFactory {
    protected final MessageRecoverManager localMessageStorageManager;
    protected final ProducerDiamondManager producerDiamondManager;

    public OrderedMetaMessageSessionFactory(MetaClientConfig metaClientConfig) throws MetaClientException {
        super(metaClientConfig);
        this.localMessageStorageManager = new OrderedLocalMessageStorageManager(metaClientConfig);
        this.producerDiamondManager = new ProducerDiamondManager(metaClientConfig);
    }

    @Override
    public void shutdown() throws MetaClientException {
        super.shutdown();
        this.localMessageStorageManager.shutdown();
    }

    @Override
    public MessageProducer createProducer(PartitionSelector partitionSelector) {
        return this.createProducer(partitionSelector, false);
    }

    @Override
    public MessageProducer createProducer() {
        return this.createProducer(new RoundRobinPartitionSelector(), false);
    }

    @Override
    public MessageProducer createProducer(boolean ordered) {
        return this.createProducer(new RoundRobinPartitionSelector(), ordered);
    }

    @Override
    public MessageProducer createProducer(PartitionSelector partitionSelector, boolean ordered) {
        if (partitionSelector == null) {
            throw new IllegalArgumentException("Null partitionSelector");
        }
        if (partitionSelector instanceof ConfigPartitionsAware) {
            ((ConfigPartitionsAware)((Object)partitionSelector)).setConfigPartitions(this.producerDiamondManager.getPartitions());
        }
        return this.addChild(new OrderedMessageProducer(this, this.remotingClient, partitionSelector, this.producerZooKeeper, this.sessionIdGenerator.generateId(), this.localMessageStorageManager));
    }

    @Override
    public MessageConsumer createConsumer(ConsumerConfig consumerConfig) {
        return super.createConsumer(consumerConfig);
    }

    @Override
    public MessageConsumer createConsumer(ConsumerConfig consumerConfig, OffsetStorage offsetStorage) {
        return super.createConsumer(consumerConfig, offsetStorage);
    }
}

