/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.producer;

import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.client.MetaClientConfig;
import com.taobao.metamorphosis.client.extension.producer.AsyncMessageProducer;
import com.taobao.metamorphosis.client.extension.producer.LocalMessageStorageManager;
import com.taobao.metamorphosis.client.extension.producer.MessageRecoverManager;
import com.taobao.metamorphosis.cluster.Partition;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class AsyncIgnoreMessageProcessor
implements AsyncMessageProducer.IgnoreMessageProcessor {
    private static final Log log = LogFactory.getLog(AsyncIgnoreMessageProcessor.class);
    private static final String STORAGE_PATH = System.getProperty("meta.async.storage.path", System.getProperty("user.home") + File.separator + ".meta_async_storage");
    private final int messageCountLimit = 500000;
    private MessageRecoverManager storageManager;

    AsyncIgnoreMessageProcessor(MetaClientConfig metaClientConfig, MessageRecoverManager.MessageRecoverer recoverer) {
        this.storageManager = new LocalMessageStorageManager(metaClientConfig, STORAGE_PATH, recoverer);
    }

    @Override
    public boolean handle(Message message) throws Exception {
        Partition partition = message.getPartition();
        partition = partition != null ? partition : Partition.RandomPartiton;
        int count = this.storageManager.getMessageCount(message.getTopic(), partition);
        if (count < this.messageCountLimit) {
            this.storageManager.append(message, partition);
            return true;
        }
        log.info((Object)"local storage is full,ignore message");
        return false;
    }

    void setStorageManager(MessageRecoverManager storageManager) {
        this.storageManager = storageManager;
    }
}

